(function($) {

    var formatDate = function(now, fmt) {
        // $.formatDate(new Date(),'yyyy-MM-dd hh:mm:ss');
        var o = {
            "M+": now.getMonth() + 1, //月份
            "d+": now.getDate(), //日
            "h+": now.getHours(), //小时
            "m+": now.getMinutes(), //分
            "s+": now.getSeconds(), //秒
            "q+": Math.floor((now.getMonth() + 3) / 3), //季度
            "S": now.getMilliseconds() //毫秒
            };
            if (/(y+)/.test(fmt))
                fmt = fmt.replace(RegExp.$1, (now.getFullYear() + "").substr(4 - RegExp.$1.length));
            for (var k in o)
                if (new RegExp("(" + k + ")").test(fmt))
                    fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            return fmt;
    }


    $.fn.chooseProduct = function(checkboxOrRadio, initParam, isModal, callBack) {
        var initArr = initParam || [];
        // 检查参数
        if(!checkboxOrRadio && initArr.length > 1) {
            callBack && callBack('单选时参数的数组长度大于1');
            return false;
        }
        // 存放当前已选择的元素列表
        var currItemList = null,currFlag = true;

         // var template = Hogan.compile($('#hoganTmpl').html());
        var template = templates.modal;

        var searchParam = null;

        // 重置模式窗体内html
        var htmlStr = template.render({
            modal: true
        });

        var $modal = this;

        // 生成模块部分
        if(isModal) {
            $modal.html(htmlStr);
        }
        else {
            $modal.html($(htmlStr).find('[data-handle="ismodal"]').html());
        }

        // 搜索表单
        var searchModalForm = $modal.find('[data-handle="searchModalForm"]');
        // 确定按钮
        var returnchoose = $modal.find('[data-handle="returnchoose"]');
        // 表格
        var modalDataTable = $modal.find('[data-handle="modalDataTable"]');

        // 显示当前选择的元素
        var currentChooseItem = $modal.find('[data-handle="currentchooseitem"]');

        var buildCurrItem = function(currItem) {
            var itemHtml = template.render({
                currentchooseitem: currItem
            });

            return $(itemHtml);
        }



        // 如果传过来参数,则显示出来
        $(initArr).each(function(idx, item) {
            currentChooseItem.append(buildCurrItem(item));
        });

        // 全选按钮
        var title = checkboxOrRadio ? '<input type="checkbox" class="i-checks" data-handle="all" name="title" value="">' : '';

        var modalTable = modalDataTable.DataTable({
            columns: [

                {
                    className:'td_center',
                    data: 'id',
                    title: title,
                    width: '3%',
                    render:function(data, type, full, meta) {
                        var flag = false;
                        // 初始化的第一次先去取回来当前的值
                        if(currFlag) {
                            currItemList = currentChooseItem.find('[data-curr="item"]');
                            currFlag = false;
                        }
                        currItemList.each(function(idx, item){
                            // console.log(data + ":" + $(item).data('proid'));
                            if(data == $(item).data('proid')) {
                                flag = true;
                                return false;
                            }
                        });
                        return '<input data-procode="' + full.code + '" data-proid="' + data + '" data-proname="' + full.name + '"  type="' + (checkboxOrRadio?'checkbox':'radio') + '" class="i-checks ' + (flag ? 'selected':'') + '" name="chooseitem" value="' + data + '" ' + (flag ? ' checked=checked':'') + '>';
                    },
                    orderable:false
                },
                {
                    title:'序号',
                    data:'index',
                    defaultContent:'',
                    orderable:false
                }
                , {
                    data:'code',
                    title:'商品编码'
                }
                , {
                    data:'name',
                    title:'商品名称'
                }
                , {
                    data:'supplierName',
                    title:'供应商'
                }
                , {
                    data:'product',
                    title:'上架时间',
                    render:function(data, type, full, meta) {
                        return formatDate(new Date(data.listTime), 'yyyy-MM-dd hh:mm:ss');
                    }
                    ,orderable:false
                }
                , {
                    data:'product',
                    title:'下架时间',
                    render:function(data, type, full, meta) {
                        return formatDate(new Date(data.delistTime), 'yyyy-MM-dd hh:mm:ss');
                    }
                    ,orderable:false
                }
                , {
                    data:'stock',
                    title:'库存'
                }
                , {
                    data:'status',
                    title:'启用状态',
                    render:function(data, type, full, meta) {
                        return 'ENABLED' == data ? '启用':'停用';
                    }
                }
                , {
                    data:'product',
                    title:'状态',
                    render:function(data, type, full, meta) {
                        var statusStr = '';
                        switch(data.status) {
                            case "DRAFT":
                                statusStr = '草稿';
                                break;
                            case "AUDIT":
                                statusStr = '审批中';
                                break;
                            case "READY_LIST":
                                statusStr = '待上架';
                                break;
                            case "REFUSE":
                                statusStr = '已拒绝';
                                break;
                            case "LIST":
                                statusStr = '已上架';
                                break;
                            case "DELIST":
                                statusStr = '已下架';
                                break;
                            case "DISCARD":
                                statusStr = '已作废';
                                break;
                        }
                        return statusStr;
                    }
                    ,orderable:false
                }
                , {
                    data:'cent',
                    title:'积分价'
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/choosesku',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            //pagingType:'full_numbers', //simple - 只有上一页、下一页两个按钮 full - 有四个按钮首页、上一页、下一页、末页 simple_numbers - 除了上一页、下一页两个按钮还有页数按钮，Datatables默认是这个
            // 每页20条
            pageLength: 15,
            lengthMenu: [15],
            lengthChange:false, // 是否允许用户显示，在下拉列表自定义选择分页大小(10, 25, 50 and 100),需要分页支持
            order: [2, 'desc'],
            initComplete: function() { // 初始化完成后执行一次

            },
            drawCallback:function() { // 每次重绘时执行一次，包含初始化
                currFlag = true;
                currItemList = null;
                //if(checkboxOrRadio) modalDataTable.find('[data-handle="all"]').iCheck('uncheck');
                refreshCheck();
            }
        });


        modalTable.on('order.dt search.dt', function() {
            modalTable.column(1, {
                search: 'applied',
                order: 'applied'
            }).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // 展示模式窗体
        if(isModal) {
            $modal.modal({
                keyboard: true
            });
        }

        modalDataTable.on('click', 'tr', function(e) {
            $(this).toggleClass('selected');
        });

        // 搜索事件
        searchModalForm.on('submit', function(e){
            currFlag = true;
            searchParam = RocoUtils.parseQueryString(searchModalForm.serialize());
            modalTable.ajax.reload(null, true);
            return false;
        });

        // 确定事件
        returnchoose.on('click', function(e){

            var okList = currentChooseItem.find('[data-curr="item"]');
            console.log(okList);
            if(okList.length == 0) {
                toastr.warning('请致少选择一个数据');
                return false;
            }

            var returnList = [];
            var returnObjList = [];

            $(okList).each(function(idx, item) {
                var self = $(item);
                var proId = self.data('proid');
                var proName = self.data('proname');
                var proCode = self.data('procode');

                returnList.push(proId);
                returnObjList.push({id:proId,code:proCode,name:proName});
            });

            if(typeof callBack == 'function') callBack && callBack(returnList, returnObjList);
            if(isModal) $modal.modal('hide');
        });

        // 全选
        modalDataTable.on('ifChecked', '[data-handle="all"]', function(e) {
            var selectAll = modalDataTable.find('[name="chooseitem"]');
            selectAll.iCheck('check');

            selectAll.each(function(idx, item) {
                if(!$(item).hasClass('selected')) $(item).addClass('selected');
            });

            e.stopPropagation();
        });

        // 全不选
        modalDataTable.on('ifUnchecked', '[data-handle="all"]', function(e) {
            var selectAll = modalDataTable.find('[name="chooseitem"]');
            selectAll.iCheck('uncheck');

            selectAll.each(function(idx, item) {
                $(item).removeClass('selected');
            });

            e.stopPropagation();
        });

        // 选择列表中的元素
        modalDataTable.on('ifChecked', '[name="chooseitem"]', function(e) {
            var self = $(this);
            if(!self.hasClass('selected')) self.addClass('selected');
            // 如果单选
            if(!checkboxOrRadio) currentChooseItem.html('');
            currentChooseItem.append(buildCurrItem({id:self.data("proid"),name:self.data("proname"),code:self.data("procode")}));

            e.stopPropagation();
        });

        // 取消列表中的元素
        modalDataTable.on('ifUnchecked', '[name="chooseitem"]', function(e) {
            var self = $(this);

            self.removeClass('selected');

            currentChooseItem.find('[data-proid="' + self.data("proid") + '"]').remove();
            e.stopPropagation();
        });

        // 关闭当前元素
        currentChooseItem.on('click', '[data-handle="closecurritem"]', function(e) {
            var self = $(this);
            var pNode = self.parent();
            var proId = pNode.data("proid");

            // 如果当前列表中存在这个元素顶，则去掉选中的状态
            modalDataTable.find('[data-proid="' + proId + '"]').iCheck('uncheck');

            pNode.remove();

            e.stopPropagation();
        });

        // 刷新 iCheck
        var refreshCheck = function() {
            modalDataTable.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });
        };
    }
})(jQuery)