(function($) {
    $.fn.layDateTwoChoose = function(option) {
        var _opiton = {
            one:null, // 第一个按钮的时间选择selector
            two:null, // 第二个按钮的时间选择selector
            oneText:'自定义时间', // 第一个按钮对应的文本
            twoText:'自定义时间', // 第二个按钮对应的文本
            callback:null, // 回调函数，参数有两个，第一次的时间和第二次的时间
            format: 'YYYY-MM-DD', //日期格式
            istime: false, //是否开启时间选择
            isclear: true, //是否显示清空
            issure: true, //是否显示确认
            min: '1900-01-01', //最小日期
            max: '2099-12-31', //最大日期
            start: '2014-6-15'    //开始日期
        };

        $.extend(_opiton, option);

        //如果没有传入第一个日期显示框，则提示错误
        if(!_opiton.one) {
            toastr.warning('请传入用于显示日期的双标签的选择器所用的字符串!');
            return false;
        }

        var self = this;

        var oneText = self.text();
        var twoText = _opiton.two ? $(_opiton.two).text() : oneText;

        // 所选择的两个日期
        var oneDate = null,twoDate = null;

        // 如果没有选择日期就消失了日期选择框
        $(document).one("click", function (e) {
            // 如果第一个日期没有选择
            if(!oneDate) {
                self.html(_opiton.oneText);
                _opiton.two && $(_opiton.two).html(_opiton.twoText);
            }
            // 分两个标签显示的处理
            else if(!twoDate) {
                _opiton.two ? $(_opiton.two).html(_opiton.twoText) : self.html(oneDate);;
            }

            _opiton.callback && _opiton.callback(oneDate, twoDate);

            e.stopPropagation();
        });

        // 显示第二次日期选择框
        var twoChoose = function(dateOne) {
            laydate({
                elem: _opiton.two ? _opiton.two : _opiton.one,
                min:dateOne,
                istoday:false,
                format: _opiton.format, //日期格式
                istime: _opiton.istime, //是否开启时间选择
                isclear: _opiton.isclear, //是否显示清空
                issure: _opiton.issure, //是否显示确认
                max: _opiton.max, //最大日期
                choose:function(dateTwo) {
                    $(document).off('click');
                    // 如果只有一个显示标签
                    if(!_opiton.two) {
                        self.html(dateOne + "至" + dateTwo);
                    }
                    _opiton.callback && _opiton.callback(dateOne, dateTwo);
                }
            });
        }

        // 显示日期选择框
        laydate({
            elem: _opiton.one, //目标元素。由于laydate.js封装了一个轻量级的选择器引擎，因此elem还允许你传入class、tag但必须按照这种方式 '#id .class'
            min:_opiton.min,
            istoday:false,
            format: _opiton.format, //日期格式
            istime: _opiton.istime, //是否开启时间选择
            isclear: _opiton.isclear, //是否显示清空
            issure: _opiton.issure, //是否显示确认
            min: _opiton.min, //最小日期
            max: _opiton.max, //最大日期
            choose:function(dateOne) {
                oneDate = dateOne;
                twoChoose(dateOne);
            }
        });
    };
})(jQuery)