;
(function($) {
    $.fn.chooseClassfy = function(checkboxOrRadio, isModal, callBack) {
        //   var template = Hogan.compile($('#hoganTmpl').html());
         var template = templates.modal;

        var searchParam = null;

        // 重置模式窗体内html
        var htmlStr = template.render({
            unifyclassfy: true
        });

        var $modal = this;

        // 生成模块部分
        if(isModal) {
            $modal.html(htmlStr);
        }
        else {
            $modal.html($(htmlStr).find('[data-handle="ismodal"]').html());
        }

        // 确定按钮
        var returnchoose = $modal.find('[data-handle="returnchoose"]');
        var searchKeyword = $modal.find('[data-handle="searchKeyword"]');

        var dataHandleTestsecond = $modal.find('[data-handle="testsecond"]');
        var dataHandleOutsecond = $modal.find('[data-handle="outsecond"]');
        dataHandleTestsecond.on('click', function(e) {
            dataHandleOutsecond.toggleClass("disNout");
        });


        // 表格
        var classfyTree = $modal.find('[data-handle="unifyclassfytree"]');

        $.ajax({
            url:ctx + "/api/catalog/tree",
            success:function(res) {
                if(res.code == "1") {
                    var treeInit = {
                        'core': {
                            'data': res.data
                        },
                        "types": {
                            "default": {
                                "icon": "glyphicon glyphicon-stop"
                            }
                        },
                        "plugins": ["types", "wholerow", "search"]
                    };

                    if (checkboxOrRadio) {
                        $.extend(treeInit, {
                            "checkbox": {
                                "keep_selected_style": true,
                                "cascade": false,
                                "whole_node": false
                            },
                            "plugins": ["checkbox", "types", "wholerow", "search"]
                        });
                    };
                    classfyTree.jstree(treeInit);
                }
            }
        });

        var to = false;
        searchKeyword.keyup(function() {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function() {
                var v = searchKeyword.val();
                classfyTree.jstree(true).search(v);
            }, 250);
        });

        // 展示模式窗体
        if(isModal) {
            $modal.modal({
                keyboard: true
            });
        }

        // 确定事件
        returnchoose.on('click', function(e){
            var nodeList = classfyTree.jstree("get_selected");
            if(nodeList.length == 0) {
                toastr.warning('请致少选择一个数据');
                return false;
            }
            var idList = [], objList = [];
            $.each(nodeList, function(idx, item) {
                var n = classfyTree.jstree("get_node", item);
                idList.push(item);
                objList.push({id:item,text:n.text});
            });

            if(isModal) $modal.modal('hide');

            if(typeof callBack == 'function') callBack && callBack(idList, objList);

            e.stopPropagation();
        });
    }
})(jQuery)