(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('operation', 'mergeorder');

        var template = Hogan.compile($('#hoganTmpl').html());
        var orderDataTable = $("#orderDataTable");
        // search实现部分
        var searchForm = $('#searchForm');


        // 初始化列表
        var dataTable = $('#orderDataTable').DataTable({
            columns: [{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	orderable: false,
	            	width: '3%'
				}, {
                    data: 'wareHouse.name',
                    title: '仓库名称',
                    width: '8%',
                    orderable: false
                }, {
                    data: 'express.name',
                    title: '快递公司',
                    width: '8%',
                    orderable: false
                }, {
                    data: 'wareHouse.contact',
                    title: '收货人',
                    orderable: false,
                    width: '8%'
                }, {
                    data: '',
                    title: '收货人地址',
                    width: '25%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        var address = "";
                        address += full.delivery.province+" ";
                        address += full.delivery.city+" ";
                        address += full.delivery.county+" ";
                        address += full.delivery.addrDetail;
                        return substring(address,25);
                    }
                },{
                    data: 'distriCodes',
                    title: '配送单号',
                    orderable: false,
                    width: '8%',
                    render: function(data, type, full, meta) {
                    	return splitString(data,",");
                    }
                },{
                    data: 'orderCodes',
                    title: '子订单号',
                    orderable: false,
                    width: '8%',
                    render: function(data, type, full, meta) {
                    	return splitString(data,",");
                    }
                }, {
                    data: 'skuNames',
                    title: '商品名称',
                    width: '20%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	var prodName = splitString(data,"##",15);
                    	return "<div data-toggle='popover' data-flag=false data-skuid='"+full.orderItem.sku.id+"' >"+prodName+"</div>";
                    }
                }, {
                    data: 'distriIds',
                    title: '操作',
                    width: '10%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	return template.render({
                            button: {
                                id: data,
                                express: full.express.name,
                                wareHouse : full.wareHouse.name
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/distributeOrder/mergeList',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), RocoUtils.parseQueryString(searchForm.serialize()));
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#orderDataTable_length').hide();
            }
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

       
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 模式窗体
        var orderModal = $('#orderModal');


        // 绑定事件
        var bindEvent = function() {
        	// 合单按键点击
            dataTable.on('click', '[data-handle="split-order"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/distributeOrder/mergeUI' ,
                    type: 'GET',
                    data: {
                    	distriOrderIdList : id
                    },
                    dataType: 'json',
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(orderModal, res.data);
                        }
                    }
                });
                event.stopPropagation();
            });
            
            dataTable.on('mouseover','[data-toggle="popover"]',function(){
            	var id = $(this).data('skuid');
            	var _this = $(this);
            	if(_this.data('flag')) {
            		return false;
            	}
            	$.ajax({
                    url: ctx + '/api/sku/'+id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                        	_this.data('flag', true);
                        	var data = res.data;
                        	var mess = {
                        		"商品编码":data.code,
                        		"商品名称":data.name,
                        		"供应商":data.product.supplier.name,
                        		"商品分类":data.product.catalogs[0].name,
                        		"商品库存":data.stock+data.virtualStock-data.occupiedStock,
                        		"商品状态信息": data.status == 'ENABLED' ? "启用" : "停用"
                        			
                        	}
                        	var content = jsonToString(mess);
                        	_this.popover({trigger:'hover',title:'商品信息',content:content,placement:'top',html:true})
                        };
                    }
                });
            })
            
            dataTable.on('mouseout','[data-toggle="popover"]',function(){
            	$(this).popover("hide");
            })
            
        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal,data) {
        	// 重置模式窗体内html
            $modal.html(template.render({
            	modal : true,
            	data : data,
            	delivery : function() {
            		return data ? data[0].orderItem.order.delivery : '';
            	},
            	mergeData : function(){
            		return data ? data[0] : '';
            	},
            	ids : function(){
            		var value = "";
            		if(data){
            			$(data).each(function(index,_this){
            				value += this.id;
            				if(index != data.length-1)
            					value += ","
            			})
            		}
            		return value;
            	}
            }));
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            //拆单
            $("#mergeOrder").on('click', function (event) {
            	var ids = $("#ids").val();
            	var mergeCode = $("#mergeCode").val();
            	$.ajax({
                    url: ctx + '/api/distributeOrder/merge',
                    type: 'GET',
                    data: {
                    	mergeCode : mergeCode,
                    	distriOrderIdList : ids
                    },
                    dataType: 'json',
                    success: function(res) {
                        if (res.code == "1") {
                        	$modal.modal('hide');
                        	search();
                        }
                    }
                });
            });
        };
        
        var init = function(){
        	bindEvent();
        	$.ajax({
                url: ctx + '/api/express/all',
                type: 'get',
                dataType: 'json',
                success: function(res) {
                    if (res.code == "1") {
                      var express =  $("#express");
                      $(res.data).each(function(){
                    	  express.append("<option value="+this.id+">"+this.name+"</option>");
                      })
                    }
                }
            });
        }
        init();
        
        //查询
        var search = function(){
        	searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        }
        
        var splitString = function(str,flag,num){
        	if(!str){
        		return "";
        	}
        	var data = str.split(flag);
        	var value = "";
        	for(var i=0;i<data.length;i++){
        		var temp = data[i];
        		if(num)
        			temp = substring(temp,num);
        		value += temp;
        		if(i != data.length-1){
        			value += "</br>"
        		}
        	}
        	return 	value;
        }
        
        var jsonToString = function(json){
        	if(!json || json.length == 0)
        		return ""
        	var str = "";
        	$.each(json, function(i) {
        		str += i+" : "+json[i]+"</br>"
        	});
        	return str;
        }
        
        var substring = function(str,index){
        	if(!str)
        		return "";
        	
        	if(str.length > index){
        		return str.substring(0, index)+"...";
        	}
        	return str;
        }
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);