(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('operation', 'order');

        var template = Hogan.compile($('#hoganTmpl').html());
        var suppliersDataTable = $("#orderDataTable");
        var tempIndex = 1;
        
        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;


        // 初始化列表
        var dataTable = $('#orderDataTable').DataTable({

            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }, {
                orderable: false,
                targets: '_all'
            }],

            columns: [{
            		data : "id",
            		visible:false
            	},{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	width: '3%'
				},{
                    data: 'orderCode',
                    title: '订单号',
                    width: '10%',
                    render: function(data, type, full, meta) {
                        return "<a href='javaScript:void(0)' data-handle='ordercode'  data-id='"+full.id+"'>"+data+"</a>"
                    }
                }, {
                    data: 'productName',
                    title: '商品名称',
                    width: '15%',
                    render: function (data, type, full, meta) {
                        // 防止广告语过长,中途截断
                    	var prodName = data;
                    	if(data){
                    		if(data.length > 15){
                    			prodName = data.substr(0, 15)
                    		}
                    	}else{
                    		prodName = "";
                    	}
                    	return prodName;
                    }
                }, {
                    data: 'quantity',
                    title: '数量',
                    width: '5%'
                }, {
                    data: 'cent',
                    title: '积分单价',
                    className:'td_cent',
                    width: '7%'
                }, {
                    data: 'price',
                    title: '现金单价',
                    className:'td_cent',
                    width: '7%'
                }, {
                    data: 'status',
                    title: '状态',
                    width: '8%',
                    render: function(data, type, full, meta) {
                    	return getStatus(data);
                    }
                }, {
                    data: 'admStatus',
                    title: '内部状态',
                    width: '8%',
                    render: function(data, type, full, meta) {
                    	return getAdmStatus(data);
                    }
                }, {
                    data: 'user.username',
                    title: '会员名',
                    width: '10%'
                }, {
                    data: 'createTime',
                    title: '下单时间',
                    width: '12%'
                }, {
                    data: 'id',
                    title: '操作',
                    width: '15%',
                    className:'td_center',
                    render: function(data, type, full, meta) {
                        return template.render({
                        	PAID : showBtn(full,"PAID"),
                        	DEALED : showBtn(full,"DEALED"),
                        	SENDING : showBtn(full,"RECEIVING")
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url : ctx + '/api/order',
                type : 'GET',
                data : function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#orderDataTable_length').hide();
            }
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 模式窗体
        var orderModal = $('#orderModal');


        // 绑定事件
        var bindEvent = function() {
        	
        	dataTable.on('mouseover','[data-toggle="popover"]',function(){
            	var id = $(this).data('skuid');
            	var _this = $(this);
            	if(_this.data('flag')) {
            		return false;
            	}
            	$.ajax({
                    url: ctx + '/api/sku/'+id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                        	_this.data('flag', true);
                        	var data = res.data;
                        	var mess = {
                        		"商品编码":data.code,
                        		"商品名称":data.name,
                        		"供应商":data.product.supplier.name,
                        		"商品分类":data.product.catalogs[0].name,
                        		"商品库存":data.stock+data.virtualStock-data.occupiedStock,
                        		"商品状态信息": data.status == 'ENABLED' ? "启用" : "停用"
                        			
                        	}
                        	var content = jsonToString(mess);
                        	_this.popover({trigger:'hover',title:'商品信息',content:content,placement:'top',html:true})
                        };
                    }
                });
            })
            
            dataTable.on('mouseout','[data-toggle="popover"]',function(){
            	$(this).popover("hide");
            })
        	
            
            //订单分组点击（实物订单、虚拟订单）
            $("div#buttons").on('click','[data-group]',function(event){
            	var groupValue = $(this).data("group");
            	$(this).parent().find("button").each(function(){
            		$(this).removeClass("btn-primary");
            		$(this).addClass("btn-white");
	        	})
            	$(this).removeClass("btn-white");
            	$(this).addClass(" btn-primary ");
	        	$("input[type=hidden][name='group']").val(groupValue);
	        	refreshTable();
            });
        	
        	
        	//导出订单
        	$("#exportBtn").on('click',function(event){
        		location.href = ctx + '/api/order/export?'+searchForm.serialize();
        		event.stopPropagation();
        	})
        	
        	//点击订单编号查看详情
        	dataTable.on("click","[data-handle='ordercode']",function(event){
        		var id = $(this).data('id');
        		$.ajax({
                    url: ctx + '/api/order/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    success: function(res) {
                        if (res.code == 1) {
                        	bindModalEvent(orderModal,res.data,null,true,'');
                        }
                    }
                });
        		event.stopPropagation();
        	})
        	
        	
        	//取消
        	dataTable.on("click","[data-handle='cancel']",function(event){
        		var id = $(this).data('id');
        		handlerOrCancel(id,true);
        		event.stopPropagation();
        	})
        	
        	//处理
        	dataTable.on("click","[data-handle='handle']",function(event){
        		var id = $(this).data('id');
        		handlerOrCancel(id,false);
        		event.stopPropagation();
        	})
        	
        	//确认收获
        	dataTable.on("click","[data-handle='confirm-receipt']",function(event){
        		var id = $(this).data('id');
        		$.ajax({
                    url: ctx + '/api/order/updateState/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    data : {
                    	finalState : 'FINISH',
                    	admStatus : 'FINISH'
                    },
                    success: function(res) {
                        if (res.code == 1) {
                       	 	toastr.success(res.message);
                       	 	refreshTable();
                        }
                    }
                });
        		event.stopPropagation();
        	})
        	
        	//重新发货
        	dataTable.on("click","[data-handle='delivergoods-again']",function(event){
        		var id = $(this).data('id');
        		 $.ajax({
                     url: ctx + '/api/order/repeatSend/' + id ,
                     type: 'GET',
                     dataType: 'json',
                     success: function(res) {
                         if (res.code == 1) {
                        	 toastr.success(res.message);
                         }
                     }
                 });
        		event.stopPropagation();
        	})

        	//修改物流信息
        	dataTable.on("click","[data-handle='edit-logistics']",function(event){
        		 var id = $(this).data('id');
                 var type = $(this).data('type');
                 $.ajax({
                     url: ctx + '/api/order/' + id ,
                     type: 'GET',
                     dataType: 'json',
                     success: function(res) {
                         if (res.code == 1) {
                         	bindModalEvent(orderModal,res.data,type,false,'/api/order/modifyExpress');
                         }
                     }
                 });
                 event.stopPropagation();
        	})

            //发货按钮点击
            dataTable.on('click', '[data-handle="deliver-goods"]', function(event) {
                var id = $(this).data('id');
                var type = $(this).data('type');
                $.ajax({
                    url: ctx + '/api/order/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    success: function(res) {
                        if (res.code == 1) {
                        	bindModalEvent(orderModal,res.data,type,false,'/api/order/send');
                        }
                    }
                });
                
                event.stopPropagation();
            });

        };
        
        var bindImportModalEvent = function($modal){
        	// 重置模式窗体内html
            $modal.html(template.render({
            	ImportModal : true,
            }));
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            //下载模板
            $("#downLoadModal").on('click', function (event) {
            	window.location.href = ctx + '/api/order/download?_=' + new Date().getTime();
            });

            //导入
            $("#importModal1").on('click', function (event) {

                $.excelImpTip({
                    path:$('#filePath').val(),
                    formData:$modal.find('form').serialize(),
                    formUrl:'/api/order/import',
                    callback:function(res) {
                        if (res.code == "1") {
                            $modal.modal('hide');
                        }
                    }
                });
            });
        }

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, type, isShow,urlPath) {
        	tempIndex = 1;
        	var itemStatus = $("#orderItemStatus").val();
            // 重置模式窗体内html
            $modal.html(template.render({
            	OrderSend : true,
            	common : type == 'common' ? true : false,
            	visual : type == 'visual' ? true : false,
            	orderTotal : orderTotal(data.orderItem.order.cent,data.orderItem.price),
            	orderType : getOrderType(data.orderItem.orderType),
            	isShow : isShow,
            	payType : getPayType(data.orderItem.order.paymentType),
            	orderStatus : getStatus(data.orderItem.status),
            	admStatus : getAdmStatus(data.orderItem.admStatus),
            	index : function(){
            		return tempIndex ++;
            	},
            	data : data || {}
            }));
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            if(type && type == 'common'){
            	$.ajax({
					url: ctx + '/api/express/all' ,
					type: 'GET',
					dataType: 'json',
					success: function(res) {
						if (res.code == 1) {
							var selected =  $('#selectExpress').val();
							var express = $('#express_id');
							var temp = "";
							$(res.data).each(function(){
								var temp = "";
								if(this.id == selected){
									temp = "<option selected value='"+this.id+"'>"+this.name+"</option>"
								}else{
									temp = "<option value='"+this.id+"'>"+this.name+"</option>"
								}
								$(express).append(temp);
							})
						}
					}
				});
            }
            
          //  if(itemStatus && itemStatus == 'RECEIVING'){
            	var code = $("#orderItemexpressCode").val();
            	var No = $("#orderItemTransportNo").val();
            	$.ajax({
					url: ctx + '/api/kuaidi' ,
					type: 'GET',
					data:{
						com : code,
						orderNo : No
					},
					dataType: 'json',
					success: function(res) {
						if (res.status == 0 || res.status == 1 || res.status == 2	) {
							$("#expressInfo").empty();
							$("#expressInfo").append(res.message);
						}
					}
				});
          //  }
            
            var $form = $modal.find('form');
            
            if(urlPath == ''){
            	$("#submitOrder").hide();
            }

            // 表单验证
            $form.validate({
                rules: {},
                submitHandler: function(form) {
                	$.ajax({
    					url: ctx + urlPath ,
    					type: 'POST',
    					data : $modal.find('form').serialize(),
    					dataType: 'json',
    					traditional: true,
                        cache: false,
    					success: function(res) {
    						if (res.code == 1) {
    							toastr.success('操作成功！');
    							$modal.modal('hide');
    							refreshTable();
    						}
    					}
    				});
                }
            });

        };
        
        // 加载搜索时间空间,只输入一个参数表示加载输入参数的时间空间,输入两个参数表示加载开始日期和结束日期的时间空间 参数为JQuery选择器的值 如 '#startDate'
        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,
                format: 'YYYY-MM-DD',//时间格式
                min: '1900-01-01', //设定最小日期
                max: '2099-06-16', //最大日期
                isclear: true, //是否显示清空按钮
                istime: false,//是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
                    endDate.start = datas //将结束日的初始值设定为开始日
                }
            };

            var endDate = {
                elem: end,
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
                }
            };

            laydate(startDate);
            laydate(endDate);
        }

        var init = function(){
        	setTimeout(initDateControl("#startDate","#endDate"), 1);
        	$.ajax({
                url: ctx + '/api/supplier/loginedSuppliers',
                type: 'get',
                dataType: 'json',
                success: function(res) {
                    if (res.code == "1") {
                      var supplier =  $("#supplierId");
                      $(res.data).each(function(){
                    	  supplier.append("<option value="+this.id+">"+this.name+"</option>");
                      })
                    }
                }
            });
        }
        init();
        bindEvent();

        // 禁用按钮
        var btnDisable = function() {
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#submitRole').removeAttr('disabled');
        };
        
        //刷新表格
        var refreshTable = function(){
        	searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        }
        
        
        //模板显示按钮
        var showBtn = function(_data,_status){
        	if(_data.status == _status){
        		return {
        			id : _data.id,
        			orderType : _data.orderType,
        			common : _data.orderType == "common" ? true : false,
        			visual : _data.orderType == "visual" ? true : false,
        			status : _status
        		}
        	}else{
        		return "";
        	}
        }
        
        //处理取消
        var handlerOrCancel = function(id,isCancel){
        	var urlPath = '';
        	if(isCancel){
        		urlPath = ctx + '/api/order/cancel/'+id;
        	}else{
        		urlPath = ctx + '/api/order/deal/'+id;
        	}
        	$.ajax({
                url: urlPath,
                type: 'get',
                dataType: 'json',
                success: function(res) {
                    if (res.code == "1") {
                    	if(isCancel){
                    		toastr.success('订单已取消');
                    	}else{
                    		toastr.success('订单已处理');
                    	}
                    	refreshTable();
                    }
                }
            });
        	
        }
        
        var getIndex = function(){
        	return tempIndex++;
        }
        
        var getOrderStatus = function(_status){
        	
        }
        
        var getInvoiceType = function(_type){
        	if(_type == 'NONE'){
        		return "不开发票";
        	}else if(_type == 'PERSONAL'){
        		return "个人";
        	}else if(_type == 'COMPANY'){
        		return "单位";
        	}
        }
        
        var getPayType = function(_type){
        	if(_type == 'CASH'){
        		return "全现金";
        	}else if(_type == 'CENT'){
        		return "全积分";
        	}else if(_type == 'CASH_AND_CENT'){
        		return "现金+积分";
        	}
        }
        
        var getOrderType = function(_type){
        	if(_type == 'common'){
        		return "实物订单";
        	}else if(_type == 'visual'){
        		return "虚拟订单";
        	}
        }
        var jsonToString = function(json){
        	if(!json || json.length == 0)
        		return ""
        	var str = "";
        	$.each(json, function(i) {
        		str += i+" : "+json[i]+"</br>"
        	});
        	return str;
        }
        //订单合计
        var orderTotal = function(cent,price){
        	if(cent != 0 && price != 0){
        		return cent+"分 + "+price+"元";
        	}else if(price != 0){
        		return price+"元";
        	}else if(cent != 0){
        		return cent+"分";
        	}else{
        		return "";
        	}
        }
      //订单状态
        var getStatus = function(_status){
        	if(_status == 'PAID'){
        		return "支付成功";
        	}else if(_status == 'NOT_PAID'){
        		return "待支付";
        	}else if(_status == 'RECEIVING'){
        		return "待收货";
        	}else if(_status == 'APPRAISING'){
        		return "待评价";
        	}else if(_status == 'FINISH'){
        		return "已完成";
        	}else if(_status == 'CANCELED'){
        		return "已取消";
        	}else if(_status == 'REFUND_ACCEPT'){
        		return "退货待受理";
        	}else if(_status == 'REFUNDING'){
        		return "退货中";
        	}else if(_status == 'REFUNDED'){
        		return "已退货";
        	}else {
        		return "";
        	}
        }
        
      //订单内部状态
        var getAdmStatus = function(_status){
        	if(_status == 'NOT_PAID'){
        		return "部分支付";
        	}else if(_status == 'PART_PAID'){
        		return "已处理";
        	}else if(_status == 'PAID'){
        		return "支付成功";
        	}else if(_status == 'EXCEPTION'){
        		return "异常";
        	}else if(_status == 'LOCKED'){
        		return "异常锁定";
        	}else if(_status == 'DISTRIBUTED'){
        		return "已生成配送单";
        	}else if(_status == 'DISTRIBUTION_MERGED'){
        		return "配送单已合并";
        	}else if(_status == 'DISTRIBUTION_WAIT_OUT'){
        		return "配送单待出库";
        	}else if(_status == 'DISTRIBUTION_OUTED'){
        		return "配送单已出库";
        	}else if(_status == 'DELIVERED'){
        		return "配送单配送中";
        	}else if(_status == 'FINISH'){
        		return "已完成";
        	}else if(_status == 'CANCELED'){
        		return "已取消";
        	}else if(_status == 'REFUND_ACCEPT'){
        		return "退货待受理";
        	}else if(_status == 'REFUND_INSTORE'){
        		return "退货已生成入库单";
        	}else if(_status == 'REFUND_LOGISTED'){
        		return "退货已输入物流单号";
        	}else if(_status == 'REFUND_RECEIVED'){
        		return "退货已确认收货";
        	}else if(_status == 'REFUNDED'){
        		return "已退货";
        	}else {
        		return "";
        	}
        }
        
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);