(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'outstock');

        var template = Hogan.compile($('#hoganTmpl').html());
        var tempIndex = 1;
        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;


        // 初始化列表
        var dataTable = $('#outstockDataTable').DataTable({

            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }, {
                orderable: false,
                targets: '_all'
            }],

            columns: [{
                data: "id"
            }, {
                className: 'td_center',
                width: '3%'
            }, {
                data: 'code',
                title: '出库单号',
                width: '10%'
            }, {
                data: 'warehouse.name',
                title: '仓库名称',
                width: '10%'
            }, {
                data: 'express.name',
                title: '快递公司',
                width: '10%'
            }, {
                data: 'sku.code',
                title: '商品编码',
                width: '10%',
                render: function (data, type, full, meta) {
	                return "<div data-toggle='popover' data-flag=false data-skuid='"+full.sku.id+"' >"+data+"</div>"
	            }
            }, {
                data: 'sku.name',
                title: '商品名称',
                width: '10%',
                render: function (data, type, full, meta) {
	                return "<div data-toggle='popover' data-flag=false data-skuid='"+full.sku.id+"' >"+data+"</div>"
	            }
            }, {
                data: 'quantity',
                title: '合并商品数量',
                width: '10%'
            }, {
                data: 'state',
                title: '状态',
                width: '10%',
                render: function (data) {
                    if (data == '0') {
                        return "未出库";
                    } else {
                        return "已出库"
                    }
                }
            }, {
                data: 'id',
                title: '操作',
                width: '10%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    if (full.state == '0') {
                        return template.render({
                            outstockBtn: {
                                id: data,
                                state: full.state
                            }
                        });
                    } else {
                        return ""
                    }
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/orderOutStore',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#outstockDataTable_length').hide();
            }
        });

        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 模式窗体
        var outstockModal = $('#outstockModal');

        // 绑定事件
        var bindEvent = function () {
        	
        	dataTable.on('mouseover','[data-toggle="popover"]',function(){
            	var id = $(this).data('skuid');
            	var _this = $(this);
            	if(_this.data('flag')) {
            		return false;
            	}
            	$.ajax({
                    url: ctx + '/api/sku/'+id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                        	_this.data('flag', true);
                        	var data = res.data;
                        	var mess = {
                        		"商品编码":data.code,
                        		"商品名称":data.name,
                        		"供应商":data.product.supplier.name,
                        		"商品分类":data.product.catalogs[0].name,
                        		"商品库存":data.stock+data.virtualStock-data.occupiedStock,
                        		"商品状态信息": data.status == 'ENABLED' ? "启用" : "停用"
                        			
                        	}
                        	var content = jsonToString(mess);
                        	_this.popover({trigger:'hover',title:'商品信息',content:content,placement:'top',html:true})
                        };
                    }
                });
            })
            
            dataTable.on('mouseout','[data-toggle="popover"]',function(){
            	$(this).popover("hide");
            })

            //全部
            $("#outstock-allBtn").on('click', function (event) {
                changeButtons(this, "", true);
            });

            //今天
            $("#outstock-todayBtn").on('click', function (event) {
                changeButtons(this, "TODAY", true);
            });

            //昨天
            $("#outstock-yesterdayBtn").on('click', function (event) {
                changeButtons(this, "YESTERDAY", true);
            });

            //近七日
            $("#outstock-nearly7daysBtn").on('click', function (event) {
                changeButtons(this, "NEARLY7DAYS", true);
            });

            //自定义时间段
            $("#outstock-customBtn").on('click', function (event) {
                changeButtons(this, "CUSTOM", false);
                $("#outstock-customBtn").layDateTwoChoose({
                    one: '#outstock-customBtn', callback: function (dateOne, dateTwo) {
                        $('#outstock-start-date').val(dateOne);
                        $('#outstock-end-date').val(dateTwo);
                        console.log($('#outstock-start-date').val() + ":" + $('#outstock-end-date').val());
                        refreshTable();
                    }
                });
            });

            //发货按钮点击
            dataTable.on('click', '[data-handle="outstock-handle"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/orderOutStore/modifyState/' + id,
                    type: 'POST',
                    data: {state: true},
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    }
                });
                event.stopPropagation();
            });

        };

        bindEvent();

        //刷新表格
        var refreshTable = function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        };
        
        var jsonToString = function(json){
        	if(!json || json.length == 0)
        		return ""
        	var str = "";
        	$.each(json, function(i) {
        		str += i+" : "+json[i]+"</br>"
        	});
        	return str;
        }

        //单选按钮
        var changeButtons = function (_this, type, refresh) {
            $("#buttons").find("button").each(function () {
                $(this).attr("class", "btn btn-white btn-xs active");
            });
            $(_this).attr("class", "btn btn-primary btn-xs active");
            if (_this.id == 'outstock-customBtn') {
                $('#outstock-date-type').val('');
            } else {
                $('#outstock-customBtn').text("自定义时间");
                $('#outstock-start-date').val('');
                $('#outstock-end-date').val('');
            }
            if (refresh) {
                $('#outstock-date-type').val(type);
                refreshTable();
            }
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);