(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'prodcomment');

        var template = Hogan.compile($('#hoganTmpl').html());
        var dataTable = $("#dataTable");
        // 模式窗体
        var orderModal = $('#orderModal');

        // 初始化列表
        var dataTable = $('#dataTable').DataTable({

            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                orderable: false,
                targets: '_all'
            }],

            columns: [{
                data: 'id',
                visible: false
            }, {
                data: 'index',
                title: '',
                defaultContent: '',
                className: 'td_center',
                width: '3%'
            }, {
                data: 'product.name',
                title: '商品名称',
                width: '8%',
                render: function (data, type, full, meta) {
                    return data;
                }
            }, {
                data: 'user.username',
                title: '会员名',
                width: '5%'
            }, {
                data: 'orderItem.orderCode',
                title: '订单编号',
                width: '8%',
                render: function (data, type, full, meta) {
                    return "<a href='javaScript:void(0)' data-handle='ordercode'  data-id='" + full.orderItem.id + "'>" + data + "</a>"
                }
            }, {
                data: 'level',
                title: '评论星级',
                width: '8%',
                orderable: false
            }, {
                data: 'content',
                title: '评论内容',
                width: '15%',
                render: function (data, type, full, meta) {
                    var content = substring(data, 10);
                    return "<div data-toggle='content' data-flag=false data-content='" + data + "' >" + content + "</div>";
                }
            }, {
                data: 'show',
                title: '显示状态',
                width: '8%',
                render: function (data, type, full, meta) {
                    if (data == 'HIDDEN') {
                        return "隐藏";
                    } else {
                        return "显示";
                    }
                }
            }, {
                data: 'createTime',
                title: '评论时间',
                width: '15%'
            }, {
                data: 'id',
                title: '操作',
                width: '10%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        editBtn: {
                            id: data,
                            content: function () {
                                return full.show == 'HIDDEN' ? '显示' : '隐藏';
                            },
                            show: function () {
                                return full.show == 'HIDDEN' ? 'DISPLAY' : 'HIDDEN';
                            },
                            isShowBtn: full.show == 'HIDDEN'
                        }
                    });
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/prodcomment',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#dataTable_length').hide();
            }
        });

        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 绑定事件
        var bindEvent = function () {
            dataTable.on('mouseover', '[data-toggle="popover"]', function (event) {
                var id = $(this).data('skuid');
                var _this = $(this);
                if (_this.data('flag')) {
                    return false;
                }
                $.ajax({
                    url: ctx + '/api/sku/' + id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                            _this.data('flag', true);
                            var data = res.data;
                            var mess = {
                                "商品编码": data.code,
                                "商品名称": data.name,
                                "供应商": data.product.supplier.name,
                                "商品分类": data.product.catalogs[0].name,
                                "商品库存": data.stock + data.virtualStock - data.occupiedStock,
                                "商品状态信息": data.status == 'ENABLED' ? "启用" : "停用"
                            }
                            var content = jsonToString(mess);
                            _this.popover({
                                trigger: 'hover',
                                title: '商品信息',
                                content: content,
                                placement: 'top',
                                html: true
                            })
                        }
                        ;
                    }
                });
            })

            dataTable.on('mouseout', '[data-toggle="popover"]', function () {
                $(this).popover("hide");
            })

            dataTable.on('mouseover', '[data-toggle="content"]', function (event) {
                var content = $(this).data('content');
                var _this = $(this);
                _this.popover({trigger: 'hover', title: '评论信息', content: content, placement: 'top'})
            })

            dataTable.on('mouseout', '[data-toggle="content"]', function () {
                $(this).popover("hide");
            })

            //点击订单编号查看详情
            dataTable.on("click", "[data-handle='ordercode']", function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/order/' + id,
                    type: 'GET',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(orderModal, res.data, null, true, '');
                        }
                    }
                });
                event.stopPropagation();
            })

            dataTable.on('click', '[data-handle="operation"]', function () {
                var id = $(this).data('id');
                var show = $(this).data('show');
                $.ajax({
                    url: ctx + '/api/prodcomment/update',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        show: show
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            refreshTable();
                        }
                        ;
                    }
                });
            })
        };


        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, type, isShow, urlPath) {
            tempIndex = 1;
            var itemStatus = $("#orderItemStatus").val();
            // 重置模式窗体内html
            $modal.html(template.render({
                orderDetail: true,
                common: type == 'common' ? true : false,
                visual: type == 'visual' ? true : false,
                orderTotal: orderTotal(data.orderItem.order.cent, data.orderItem.price),
                orderType: getOrderType(data.orderItem.orderType),
                isShow: isShow,
                payType: getPayType(data.orderItem.order.paymentType),
                orderStatus: getStatus(data.orderItem.status),
                admStatus: getAdmStatus(data.orderItem.admStatus),
                index: function () {
                    return tempIndex++;
                },
                data: data || {}
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
        }

        bindEvent();


        //刷新表格
        var refreshTable = function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        };

        var jsonToString = function (json) {
            if (!json || json.length == 0)
                return ""
            var str = "";
            $.each(json, function (i) {
                str += i + " : " + json[i] + "</br>"
            });
            return str;
        }

        var substring = function (str, index) {
            if (str.length > index) {
                return str.substring(0, index) + "...";
            }
            return str;
        }
        //订单合计
        var orderTotal = function (cent, price) {
            if (cent != 0 && price != 0) {
                return cent + "分 + " + price + "元";
            } else if (price != 0) {
                return price + "元";
            } else if (cent != 0) {
                return cent + "分";
            } else {
                return "";
            }
        }
        var getOrderType = function (_type) {
            if (_type == 'common') {
                return "实物订单";
            } else if (_type == 'visual') {
                return "虚拟订单";
            }
        }
        var getPayType = function (_type) {
            if (_type == 'CASH') {
                return "全现金";
            } else if (_type == 'CENT') {
                return "全积分";
            } else if (_type == 'CASH_AND_CENT') {
                return "现金+积分";
            }
        }
        //订单状态
        var getStatus = function (_status) {
            if (_status == 'PAID') {
                return "支付成功";
            } else if (_status == 'NOT_PAID') {
                return "待支付";
            } else if (_status == 'RECEIVING') {
                return "待收货";
            } else if (_status == 'FINISH') {
                return "已完成";
            } else if (_status == 'CANCELED') {
                return "已取消";
            } else if (_status == 'REFUND_ACCEPT') {
                return "退货待受理";
            } else if (_status == 'REFUNDING') {
                return "退货中";
            } else if (_status == 'REFUNDED') {
                return "已退货";
            } else {
                return "";
            }
        }
        //订单内部状态
        var getAdmStatus = function (_status) {
            if (_status == 'NOT_PAID') {
                return "部分支付";
            } else if (_status == 'PART_PAID') {
                return "已处理";
            } else if (_status == 'PAID') {
                return "支付成功";
            } else if (_status == 'EXCEPTION') {
                return "异常";
            } else if (_status == 'LOCKED') {
                return "异常锁定";
            } else if (_status == 'DISTRIBUTED') {
                return "已生成配送单";
            } else if (_status == 'DISTRIBUTION_MERGED') {
                return "配送单已合并";
            } else if (_status == 'DISTRIBUTION_WAIT_OUT') {
                return "配送单待出库";
            } else if (_status == 'DISTRIBUTION_OUTED') {
                return "配送单已出库";
            } else if (_status == 'DELIVERED') {
                return "配送单配送中";
            } else if (_status == 'FINISH') {
                return "已完成";
            } else if (_status == 'CANCELED') {
                return "已取消";
            } else if (_status == 'REFUND_ACCEPT') {
                return "退货待受理";
            } else if (_status == 'REFUND_INSTORE') {
                return "退货已生成入库单";
            } else if (_status == 'REFUND_LOGISTED') {
                return "退货已输入物流单号";
            } else if (_status == 'REFUND_RECEIVED') {
                return "退货已确认收货";
            } else if (_status == 'REFUNDED') {
                return "已退货";
            } else {
                return "";
            }
        }

    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);