(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('operation', 'prodstockapp');

        var template = Hogan.compile($('#hoganTmpl').html());
        var storeDataTable = $("#storeDataTable");
        var proList = null;
        
        // 初始化列表
        var dataTable = $('#storeDataTable').DataTable({
            columns: [{
		        	data: 'index',
		            title: '',
		            defaultContent:'',
		            className:'td_center',
		            orderable: false,
		            width: '3%'
				},{
            		data: 'id',
            		visible : false
            	},{
                    data: 'opertype',
                    title: '操作类型(表头排序用)',
                    defaultContent: '',
                    visible : false
                },{
                    data: 'apply_date',
                    title: '申请日期(表头排序用)',
                    defaultContent: '',
                    visible : false
                },{
                    data: 'applyCode',
                    title: '申请单号',
                    width: '15%',
                    render: function(data, type, full, meta) {
                    	return "<a data-handle='show-applyCode' data-id='"+full.id+"' href='javascript:void(0)'>"+data+"</a>"
                    },
                    orderable:false
                }, {
                    data: 'type',
                    title: '操作类型',
                    width: '10%',
                    render: function(data, type, full, meta) {
                    	return data == 'IN'? '入库' : '出库';
                    },
                    orderData: [1],
                    orderable: true
                }, {
                    data: 'warehouse',
                    title: '仓库种类',
                    width: '15%',
                    render: function(data, type, full, meta) {
                    	return data == 'VISUAL'? '虚拟库' : '良品库';
                    },
                    orderable: true
                }, {
                    data: 'applyer.name',
                    title: '申请人',
                    width: '15%',
                    orderable: false
                }, {
                    data: 'state',
                    title: '申请状态',
                    width: '15%',
                    render: function(data, type, full, meta) {
                        if(data == 'PASS'){
                        	return "通过";
                        }else if(data == 'WAIT_AUDIT'){
                        	return "待审批";
                        }else if(data == 'DRAFT'){
                        	return "草稿";
                        }else if(data == 'FAILED'){
                        	return "已拒绝";
                        }
                    },
                    orderable: true
                }, {
                    data: 'applyDate',
                    title: '申请提交时间',
                    width: '15%',
                    orderData: [2],
                    orderable: true,
                    render: function (data, type, full, meta) {
                        return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm:ss');
                    }
                }, {
                    data: 'id',
                    title: '操作',
                    width: '10%',
                    orderable: false,
                    className:'td_center',
                    render: function(data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                        	showBtn: {
                            	id: data,
                            	editBtn : function(){
                            		if(full.state == 'DRAFT' || full.state == 'WAIT_AUDIT'){
                            			return true;
                            		}else{
                            			return null;
                            		}
                            	},
                            	content : function() {
                                	if(full.state == 'DRAFT'){
                                		return '编辑';
                                	}else if(full.state == 'WAIT_AUDIT'){
                                		return '审批';
                                	}else{
                                		return null;
                                	}
                                },
                                status: function(){
                                	if(full.state == 'DRAFT'){
                                		return 'edit';
                                	}else if(full.state == 'WAIT_AUDIT'){
                                		return 'audit';
                                	}else{
                                		return null;
                                	}
                                },
                                type:full.type
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/prodstockapp',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            lengthChange:false
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 入库申请按钮
        var inStoreBtn = $('#inStoreBtn');
        // 出库申请按钮
        var outStoreBtn = $('#outStoreBtn');
        // 模式窗体
        var roleModal = $('#storeModal');


        // 绑定事件
        var bindEvent = function() {
            // 查看按键点击
            dataTable.on('click', '[data-handle="show-applyCode"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/prodstockapp/' + id ,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(roleModal, res.data, null, 'show');
                        }
                    }
                });
                event.stopPropagation();
            });

            // 编辑审批 按键点击
            dataTable.on('click', '[data-handle="role-operation"]', function(event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                var type = $(this).data('type');
                $.ajax({
                    url: ctx + '/api/prodstockapp/' + id ,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                        	setResult(res.data.prodStockApplyItems);
                            bindModalEvent(roleModal, res.data, type, status);
                        }
                    }
                });
                event.stopPropagation();
            });

            // 入库点击
            inStoreBtn.on('click', function(event) {
            	proList = null;
                bindModalEvent(roleModal, null, 'IN', 'modal');
                event.stopPropagation();
            });
            // 出库点击
            outStoreBtn.on('click', function(event) {
            	proList = null;
            	bindModalEvent(roleModal, null, 'OUT', 'modal');
            	event.stopPropagation();
            });
            
            //全部
            $("#allStoreBtn").on('click',function(event){
            	$("#state").val("");
            	$("#type").val("");
            	changeBtnColor(this);
            	search();
            })
            //草稿
            $("#draftStoreBtn").on('click',function(event){
            	$("#state").val("DRAFT");
            	$("#type").val("");
            	changeBtnColor(this);
            	search();
            })
            //入库待审批
            $("#inStoreAudit").on('click',function(event){
            	$("#state").val("WAIT_AUDIT");
            	$("#type").val("IN");
            	changeBtnColor(this);
            	search();
            })
            //出库待审批
            $("#outStoreAudit").on('click',function(event){
            	$("#state").val("WAIT_AUDIT");
            	$("#type").val("OUT");
            	changeBtnColor(this);
            	search();
            })
            //入库审批通过
            $("#inStorePass").on('click',function(event){
            	$("#state").val("PASS");
            	$("#type").val("IN");
            	changeBtnColor(this);
            	search();
            })
            //出库审批通过
            $("#outStorePass").on('click',function(event){
            	$("#state").val("PASS");
            	$("#type").val("OUT");
            	changeBtnColor(this);
            	search();
            })
            //拒绝
            $("#refuseStoreBtn").on('click',function(event){
            	$("#state").val("FAILED");
            	$("#type").val("");
            	changeBtnColor(this);
            	search();
            })
           
        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, type, checkModal) {
        	
        	var index = 1;
            var index2 = 1;
        	var storeSelected = storeSelect();
            // 重置模式窗体内html
            $modal.html(template.render({
                modal: checkModal == 'modal' ? true : false,
                edit : checkModal == 'edit' ? true : false,
                audit : checkModal == 'audit' ? true : false,
                show : checkModal == 'show' ? true : false,
                data: data || {},
                state: getstatus(data) || '',
                store: getStore(data),
            	IN : getIn(data),
            	OUT : getOut(data),
            	getIndex:function(){
            		return index++;
            	},
                getIndex2:function(){
                    return index2++;
                },
            	storeSelected : true
            }));
            
            

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            $modal.find('.slide-content').slideContent({
                invisibleClass: 'slide-page-invisible',
                slideToSelector:'[data-slidehandler="slide_to"]',
                slideBackSelector:'[data-slidehandler="slide_back"]',
                slideConfirmSelector:'[data-slidehandler="slide_confirm"]',
                beforeSlideTo:function($page){console.log(arguments,'beforeSlideTo');},
                afterSlideTo:function($page){
                    console.log(arguments,'afterSlideTo');
                    $page.chooseProduct(true, proList, false, function(idList,objList){
                        var proTable = $("#proTable");
                        proList = objList;
                        proTable.empty();
                        $(objList).each(function(idx, item) {
                        	var value = item;
                        	var table = "<table class='table table-bordered'>" +
	    						"<input type='hidden' data-id='id' name='prodStockApplyItems[].prod.id' value='"+value.id+"'>" +
	    						"<tbody>" +
	    							"<tr><td>商品编码："+value.code+" <span>关闭</span></td></tr>"+
	    							"<tr><td>商品名称："+value.name+" </td></tr>"+
	    							"<tr><td>数量:<input type='text' data-num='num' name='prodStockApplyItems[].quantity'></td></tr>"+
	    						"</tbody>"+	
	    					"</table>";
                        	proTable.append(table);
                        });
                    });
                },
                beforeSlideBack:function($page){console.log(arguments,'beforeSlideBack'); return true;},
                afterSlideBack:function($page){console.log(arguments,'afterSlideBack');},
                beforeSlideConfirm:function($page){console.log(arguments,'beforeSlideConfirm');
                return true;},
                afterSlideConfirm:function($page){console.log(arguments,'afterSlideConfirm');}
            });

            $("#saveDraft").on('click',function(event){
            	resetIndex();
                $.ajax({
                    url: ctx + '/api/prodstockapp/create/DRAFT',
                    type: 'POST',
                    data: [item.find('form[name="stockapply_base_info"]').serialize(),
                        '&',
                        item.find('form[name="stockapply_extra_info"]').serialize(),'&type='+type
                    ].join(''),
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                        	toastr.success('操作成功');
                            $modal.modal('hide');
                            dataTable.ajax.reload();
                        }
                    }
                });
            });
            var item = $("#modal-dialog");
            $("#sumbitAudit").on('click',function (event) {
            	resetIndex();
                $.ajax({
                    url: ctx + '/api/prodstockapp/create/WAIT_AUDIT',
                    type: 'POST',
                    data: [item.find('form[name="stockapply_base_info"]').serialize(),
                        '&',
                        item.find('form[name="stockapply_extra_info"]').serialize(),'&type='+type
                    ].join(''),
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                        	toastr.success('操作成功');
                            $modal.modal('hide');
                            dataTable.ajax.reload();
                        }
                    }
                });
            });
            //通过
        	$("#throughBtn").on('click',function (event) {
        		auditEvent($modal,"AGREE");
            });
            
            //拒绝
            $("#refuseBtn").on('click',function (event) {
            	auditEvent($modal,"DISAGREE");
            });
            //退回
            $("#returnBtn").on('click',function (event) {
            	auditEvent($modal,"RETURN");
            });
            
        };
        bindEvent();
        // 禁用按钮
        var btnDisable = function() {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
        
        //操作
        var getIn = function(data){
        	if(!data || data == null)
        		return '';
        	return data.type == 'IN' ? true : false
        }
        //操作
        var getOut = function(data){
        	if(!data || data == null)
        		return '';
        	return data.type == 'OUT' ? true : false
        }
        //获取仓库
        var getStore = function(data){
        	if(!data || data == null)
        		return '';
        	if(data.warehouse == 'VISUAL'){
        		return '虚拟库';
        	}else if(data.warehouse == 'GOOD'){
        		return '良品库';
        	}
        }
        
        var getstatus = function(data){
        	if(!data || data == null)
        		return '';
        	if(data.state == 'DRAFT'){
        		return '草稿';
        	}else if(data.state == 'WAIT_AUDIT'){
        		return '待审批';
        	}else if(data.state == 'PASS'){
        		return '通过';
        	}else if(data.state == 'FAILED'){
        		return '失败';
        	}else{
        		return '';
        	}
        }
        //仓库下拉框选中
        var storeSelect = function(data){
        	if(!data || data == null)
        		return 'null';
        	if(data == 'VISUAL'){
        		return 'VISUAL';
        	}else if(data == 'GOOD'){
        		return 'GOOD';
        	}else{
        		return '';
        	}
        		
        }
        //审批按钮触发事件
        var auditEvent = function($modal,result){
        	var id = $("#auditId").val();
        	$.ajax({
                url: ctx + '/api/prodstockapp/approve/'+id+'/'+result,
                type: 'GET',
                success: function (res) {
                    if (res.code == 1) {
                    	toastr.success('操作成功');
                        $modal.modal('hide');
                        dataTable.ajax.reload();
                    }
                }
            });
        }
        //查询
        var search = function(){
        	searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        }
        //改变按钮颜色
        var changeBtnColor = function(_this){
        	$("#buttons").find("button").each(function(){
        		$(this).attr("class","btn btn-white btn-xs active");
        	})
        	$(_this).attr("class","btn btn-primary btn-xs active");
        }
        //重置索引
        var resetIndex = function(){
        	var proTable = $("#proTable").find("table");
        	if(proTable.length > 0){
        		$(proTable).each(function(index,value){
        			$(value).find("input[data-id='id']").attr("name","prodStockApplyItems["+index+"].prod.id");
        			$(value).find("input[data-num='num']").attr("name","prodStockApplyItems["+index+"].quantity");
        		})
        	}
        }
        //设置结果集
        var setResult = function(data){
        	if(data.length == 0){
        		proList = null;
        		return ;
        	}
        	var arr = [];
        	$(data).each(function(index,value){
        		var str = "{id:"+value.prod.id+",code:'"+value.prod.code+"',name:'"+value.prod.name+"'}";
        		arr.push(str);
        	})
        	proList = eval("["+arr.join(",")+"]");
        }
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);