(function (window, document, $, Hogan, RocoUtils) {
    function ProductCategory() {
        this.template = null;
        this.$jstree = null;
        this.$createBtn = null;
        this.$editBtn = null;
        this.$refreshBtn = null;
        this.$deleteBtn = null;
        this.$modal = null;
        this.displayPositions = [
            {id: 'BOTH_VISIBLE', name: '全部显示'},
            {id: 'PC_VISIBLE', name: '仅PC端显示'},
            {id: 'APP_VISIBLE', name: '仅移动端显示'},
            {id: 'INVISIBLE', name: '全不显示'}
        ];
        this.init();
        this.renderTree();
        this.bindEvent();
    }

    // 初始化
    ProductCategory.prototype.init = function () {
        this.template = Hogan.compile($('#hoganTmpl').html());
        this.$jstree = $('#jstree');
        this.$createBtn = $('#createBtn');
        this.$editBtn = $('#editBtn');
        this.$refreshBtn = $('#refreshBtn');
        this.$deleteBtn = $('#deleteBtn');
        this.$modal = $('#modal');
    }

    // 渲染树
    ProductCategory.prototype.renderTree = function () {
        var self = this;
        //加载树
        $.ajax({
            url: ctx + '/api/catalog/tree',
            success: function (res) {
                if (res.code == '1') {
                    self.$jstree.jstree({
                        core: {
                            multiple: false,
                            // 不加此项无法动态删除节点
                            check_callback: true,
                            data: res.data
                        },
                        types: {
                            default: {
                                icon: 'glyphicon glyphicon-stop'
                            }
                        },
                        plugins: ['types', 'wholerow', 'changed']
                    });
                }
            }
        });
    };


    ProductCategory.prototype.bindEvent = function () {
        var self = this;
        // 消失前销毁富文本编辑器
        self.$modal.on('hide.bs.modal', function () {
        });


        //添加主分类
        self.$createBtn.on('click', function (e) {
            var ref = self.$jstree.jstree(true),
                sel = ref.get_selected(true);
            // 未选择分类创建一级分类
            if (!sel.length) {
                self.showModal(null, null, function (data) {
                    var ref = self.$jstree.jstree(true);
                    ref.create_node('#', data);
                });
                return false;
            }
            // 三级分类下禁止创建
            if (sel[0].a_attr['data-lev'] == 3) {
                toastr.warning("节点层级不能超过3层");
            } else {
                self.showModal(null, sel[0].id, function (data) {
                    ref.create_node(sel[0].id, data);
                });
            }
        });

        //编辑
        self.$editBtn.on('click', function (e) {
            var ref = self.$jstree.jstree(true),
                sel = ref.get_selected(true);
            if (!sel.length) {
                toastr.error("请选择节点");
            } else {
                var level = sel[0].a_attr['data-lev'];
                $.ajax({
                    url: ctx + "/api/catalog/" + sel[0].id + "/get",
                    data: {'level': level, model: 'edit'},
                    success: function (res) {
                        if (res.code == '1') {
                            var category = res.data;
                            self.showModal(category, sel[0].id, function (data) {
                                // 执行改名
                                ref.rename_node(sel, data.text);
                            });
                        } else {
                            toastr.warning("你没有编辑此项目的权限");
                        }
                    }
                });
            }
        });

        //刷新
        self.$refreshBtn.on('click', function (e) {
            location.reload();
        });

        // 删除
        self.$deleteBtn.on('click', function (e) {
            var ref = self.$jstree.jstree(true),
                sel = ref.get_selected();
            if (!sel.length) {
                toastr.error("请选择节点");
            } else {
                swal({
                    title: "你确定删除该分类吗?",
                    text: "警告:删除后不可恢复！",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "确定",
                    cancelButtonText: "取消",
                    closeOnConfirm: false
                }, function (isConfirm) {
                    if (isConfirm) {
                        $.ajax({
                            url: ctx + "/api/catalog/" + sel[0] + "/delete",
                        }).done(function (res) {
                            if (res.code == 1) {
                                swal("操作成功!", "", "success");
                                ref.delete_node(sel);
                            }
                        }).error(function () {
                            swal("操作失败！", "", "error");
                        });
                    }
                });
            }
        });
    }

    // 模式窗体
    ProductCategory.prototype.showModal = function (category, parentId, callback) {
        var self = this;
        self.$modal.html(self.template.render({
            modal: true,
            category: category || {id: 0},
            parentId: parentId || 0,
            displayPositions: self.displayPositions,
            selected: function () {
                if (category) {
                    return this.id === category.status ? 'selected' : '';
                }
                return '';
            }
        }));

        // 激活checkbox为ichecks
        self.$modal.find('.i-checks').iCheck({
            checkboxClass: 'icheckbox_square-green',
            radioClass: 'iradio_square-green'
        });

        // 展示模式窗体
        self.$modal.modal({
            keyboard: true
        });

        // 表单验证
        self.$modal.find('form').validate({
            rules: {
                name: {
                    required: true,
                    maxlength: 40
                },
                code: {
                    required: true,
                    maxlength: 20
                },
                sortId: {
                    required: true,
                    maxlength: 10,
                    digits: true
                }
            },
            submitHandler: function (form) {
                $.ajax({
                    url: form.id.value != '0' ? (ctx + '/api/catalog/update') : (ctx + '/api/catalog/save'),
                    type: 'post',
                    dataType: 'json',
                    data: $(form).serialize(),
                    traditional: true,
                    cache: false,
                    beforeSend: function () {
                        self.btnDisable();
                    },
                    success: function (res) {
                        if (res.code == '1') {
                            toastr.success('操作成功');
                            self.$modal.modal('hide');
                            // 执行回调
                            callback.call(self, res.data);
                        }
                    },
                    complete: function () {
                        self.btnEnable();
                    }
                });
                return false;
            }
        });
    }


    ProductCategory.prototype.btnDisable = function () {
        $('#submitBtn').attr('disabled', 'disabled');
    };

    // 启用按钮
    ProductCategory.prototype.btnEnable = function () {
        $('#submitBtn').removeAttr('disabled');
    };

    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'classify');
        new ProductCategory();

    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);