(function(window, document, $, Hogan, RocoUtils) {
	$(function() {
		// 扩展Date的format方法
		Date.prototype.format = function(format) {
			var o = {
				"M+" : this.getMonth() + 1,
				"d+" : this.getDate(),
				"h+" : this.getHours(),
				"m+" : this.getMinutes(),
				"s+" : this.getSeconds(),
				"q+" : Math.floor((this.getMonth() + 3) / 3),
				"S" : this.getMilliseconds()
			}
			if (/(y+)/.test(format)) {
				format = format.replace(RegExp.$1, (this.getFullYear() + "")
						.substr(4 - RegExp.$1.length));
			}
			for ( var k in o) {
				if (new RegExp("(" + k + ")").test(format)) {
					format = format.replace(RegExp.$1,
							RegExp.$1.length == 1 ? o[k] : ("00" + o[k])
									.substr(("" + o[k]).length));
				}
			}
			return format;
		};
		// 高亮导航条
		RocoUtils.setSection('operation', 'products');
		var template = Hogan.compile($('#hoganTmpl').html());
		var modalclassfycheckbox = $("#modalclassfycheckbox");
		var classModal = $('#classModal');
		var skuTyps = {};
		var winHref = window.location.href;
		var skuId = 0;
		var isSkuInfo = false;
		var PRO_TYPE = "PRODUCT";
		if (winHref) {
			skuId = winHref.substring(winHref.indexOf("?") + 1);
			$("#productId").val(skuId);
		}
		if (skuId > 0) {
			$("#attrSelectBox").find('[data-handle="pro-create-attr"]').hide();
		}
		var mainId = 0;
		var initData = function() {
			// 编辑
			var skuInfo = {
				initPage : function() {
					if (skuId > 0) {
						$.ajax({
							url : ctx + '/api/product/' + skuId + '/detail',
								type : 'GET',
								dataType : 'json',
								cache : false,
								async : false,
								success : function(res) {
									if (res.code == 1) {
										console.log(res);
										var data = res.data;
										$("#name").val(data.name);
										if (data.supplier) {
											$("#supplier").val(data.supplier.id);
										}
										if (data.brand) {
											$("#brand").val(data.brand.id);
										}
										// 加载分类
										if (data.catalogs) {
											classArray = [];
											var classStr = "";
											for (var i = 0; i < data.catalogs.length; i++) {
												classArray[classArray.length] = data.catalogs[i].id;
												classStr += "," + data.catalogs[i].name;
											}
											if (classStr && classStr.length > 0) {
												$("#currChoseClass").html(classStr.substring(1));
											}
										}
										if (data.listTime) {
											var nowDate = new Date(data.listTime).format("yyyy-MM-dd");
											$("#listTime").val(nowDate);
										}
										if (data.delistTime) {
											var nowDate = new Date(data.delistTime).format("yyyy-MM-dd");
											$("#delistTime").val(nowDate);
										}
										$("#promotionWord").val(data.promotionWord);
										$("#visual").val("" + data.visual);
										if (data.visual) {
											if(data.putType=="MANUAL"){
												$("#put_type_hand").iCheck('check');
												$("#put_type_auto").iCheck('uncheck');
											}else if(data.putType=="AUTO"){
												$("#put_type_hand").iCheck('uncheck');
												$("#put_type_auto").iCheck('check');
											}else{
												$("#put_type_hand").iCheck('uncheck');
												$("#put_type_auto").iCheck('uncheck');
											}
											$("#putTypeTr").show();
										}else{
											$("#put_type_hand").iCheck('uncheck');
											$("#put_type_auto").iCheck('uncheck');
											$("#putTypeTr").hide();
										}
										if (data.showStatus) {
											var showStatusArray = [];
											if (data.showStatus == "BOTH_VISIBLE") {
												showStatusArray[0] = "PC_VISIBLE";
												showStatusArray[1] = "WAP_VISIBLE";
											} else {
												showStatusArray[0] = data.showStatus;
											}
											$('#showStatusTd .i-checks').each(function(i, obj) {
												for (var j = 0; j < showStatusArray.length; j++) {
													if (showStatusArray[j] == $(obj).val()) {
														$(obj).iCheck("check");
													}
												}
											});
										}
										var productImages = data.productImages;
										var fileMain = [], fileAttach = [], fileSku = [];
										var attachIndex = 0;
										for (var i = 0; i < productImages.length; i++) {
											var item = productImages[i];
											var imgPath = item.imageUrl;
											var imgName = imgPath.substring(imgPath.lastIndexOf("/") + 1,imgPath.lastIndexOf("."));
											// 属性
											if (item.imageType == "SKU") {
												fileSku[fileSku.length] = {
													"name" : imgName,// 图片名称
													"id" : item.id,// 图片ID
													fullPath : imgPath,
													path : imgPath,
													type : 'image' // 图片
																	// image
																	// Excel
																	// excel
												}
											} else if (item.imageType == "ATTACH") {
												fileAttach[fileAttach.length] = {
													"name" : imgName,// 图片名称
													"id" : item.id,// 图片ID
													fullPath : imgPath,
													path : imgPath,
													type : 'image' // 图片
																	// image
																	// Excel
																	// excel
												}
												$("#file0_" + attachIndex).val(imgPath);
												attachIndex++;
											} else if (item.imageType == "MAIN") {
												fileMain[fileMain.length] = {
													"name" : imgName,// 图片名称
													"id" : item.id,// 图片ID
													fullPath : imgPath,
													path : imgPath,
													type : 'image' // 图片
																	// image
																	// Excel
																	// excel
												}
												mainId = item.id;
												$("#imgUrl").val(imgPath);
											}
										}
										if (fileMain && fileMain.length > 0) {
											// 上传空间
											UploadTools.createTo("fileImage", "img",PRO_TYPE, "imgUrl", 1,fileMain);
										}
										if (fileAttach&& fileAttach.length > 0) {
											UploadTools.createTo("file0Image", "img",PRO_TYPE, ":file0", 5,fileAttach);
										}
										if((data.displayInlist+"")=="true"){
											$("#displayInlist").iCheck("check");
										}
										if (data.description) {
											// 商品介绍
											if (data.description.introduction) {
												$('#detailDiv .summernote').code(data.description.introduction);
											}
											// 规格参数
											if (data.description.specification) {
												$('#paramDiv .summernote').code(data.description.specification);
											}
											// 包装清单
											if (data.description.packingList) {
												$('#listDiv .summernote').code(data.description.packingList);
											}
											// 售后保障
											if (data.description.afterSale) {
												$('#warrantyDiv .summernote').code(data.description.afterSale);
											}
										}
										if (data.skuMeta && data.skuMeta.attribute1Name) {
											if (data.skus) {
												$("#productDefaultAttr").html("");
												if (data.skuMeta.dictSkuMeta1) {
													var item = data.skuMeta.dictSkuMeta1;
													var propertyArray = item.propertys.split(",");
													for (var i = 0; i < propertyArray.length; i++) {
														var attr = propertyArray[i].replace(/\s/g,"");
														for (var j = 0; j < data.skus.length; j++) {
															var skuInfo = data.skus[j];
															if (skuInfo.attribute1 == attr) {
																attrEvent.putAttrs(item.id,attr);
																break;
															}
														}
													}
												}
												if (data.skuMeta.dictSkuMeta2) {
													var item = data.skuMeta.dictSkuMeta2;
													var propertyArray = item.propertys.split(",");
													for (var i = 0; i < propertyArray.length; i++) {
														var attr = propertyArray[i].replace(/\s/g,"");
														for (var j = 0; j < data.skus.length; j++) {
															var skuInfo = data.skus[j];
															if (skuInfo.attribute2 == attr) {
																attrEvent.putAttrs(item.id,attr);
																break;
															}
														}
													}
												}
												if (data.skuMeta.dictSkuMeta3) {
													var item = data.skuMeta.dictSkuMeta3;
													var propertyArray = item.propertys.split(",");
													for (var i = 0; i < propertyArray.length; i++) {
														var attr = propertyArray[i].replace(/\s/g,"");
														for (var j = 0; j < data.skus.length; j++) {
															var skuInfo = data.skus[j];
															if (skuInfo.attribute3 == attr) {
																attrEvent.putAttrs(item.id,attr);
																break;
															}
														}
													}
												}
												attrEvent.initAttrTable();
												// 填充数据
												var imgIds = $("#attrBox input[name='imgId']");
												var imgs = $("#attrBox input[name='img']");
												var skuIds = $("#attrBox input[name='skuId']");
												var priceObjArray = $("#attrBox input[name='price']");
												var skuCodeObjArray = $("#attrBox input[name='number']");
												var cashAmtObjArray = $("#attrBox input[name='cashAmt']");
												var mergeCentObjArray = $("#attrBox input[name='mergeCent']");
												var mergeCashAmtObjArray = $("#attrBox input[name='mergeCashAmt']");
												var statusArray = $('#attrTable .ck');
												var disArray = $('#attrTable .dis');
												for (var i = 0; i < data.skus.length; i++) {
													var skuInfo = data.skus[i];
													if (skuInfo.productImages&& skuInfo.productImages.length > 0) {
														imgIds.eq(i).val(skuInfo.productImages[0].id);
														imgs.eq(i).val(skuInfo.productImages[0].imageUrl);
														priceObjArray.eq(i).val(skuInfo.cent);
														skuCodeObjArray.eq(i).val(skuInfo.code);
														cashAmtObjArray.eq(i).val(skuInfo.cashAmt);
														mergeCentObjArray.eq(i).val(skuInfo.mergeCent);
														mergeCashAmtObjArray.eq(i).val(skuInfo.mergeCashAmt);
														skuIds.eq(i).val(skuInfo.id);
														if (skuInfo.status == "DISABLED") {
															if (!isSkuInfo) {
																isSkuInfo = true;
															}
															statusArray.eq(i).iCheck("check");
														}
														if ((skuInfo.displayInlist+"")=="true") {
															disArray.eq(i).iCheck("check");
														}
													}
												}
												$("#attrTable input[name='img']").each(function(i,o) {
													var url = o.value;
													if (url && url.length > 0) {
														$( "#img_" + o.id) .attr( "src", url);
														$( "#img_" + o.id) .show();
													}
												});
											}
										}else{
											if (data.skus) {
												var sku = data.skus[0];
												$("#price").val(sku.cent);
												$("#cashAmt").val(sku.cashAmt);
												$("#mergeCent").val(sku.mergeCent);
												$("#mergeCashAmt").val(sku.mergeCashAmt);
												$("#code").val(sku.code);
												$("#sku_one_id").val(sku.id);
												if(sku.status!="ENABLED"){
													$("#ck_status").iCheck("check");
												}
											}
										}
									}
								}
							});
						}
					}
				};
			// 初始化 编辑界面
			// $("#productId").val(1);
			// 从服务端获得所有排行类型
			var types = [ {
				"id" : "DRAFT",
				name : "草稿"
			}, {
				"id" : "READY_LIST",
				name : "待上架"
			}, {
				"id" : "AUDIT",
				name : "审批中"
			}, {
				"id" : "LIST",
				name : "已上架"
			}, {
				"id" : "DELIST",
				name : "已下架"
			}, {
				"id" : "REFUSE",
				name : "拒绝"
			}, {
				"id" : "DISCARD",
				name : "已作废"
			} ];
			var typeMap = {
				"DRAFT" : "草稿",
				"READY_LIST" : "待上架",
				"AUDIT" : "审批中",
				"LIST" : "已上架",
				"DELIST" : "已下架",
				"REFUSE" : "拒绝",
				"DISCARD" : "已作废"
			};
			// 获取所有供应商
			$.ajax({
				url : ctx + '/api/supplier/loginedSuppliers',
				type : 'GET',
				dataType : 'json',
				cache : false,
				success : function(res) {
					if (res.code == 1) {
						var content = template.render({
							suppliers : {
								data : res.data
							}
						});
						$("#supplier").html(content);
					}
				}
			});
			// 获取所有供应商
			$.ajax({
				url : ctx + '/api/brand/all',
				type : 'GET',
				dataType : 'json',
				cache : false,
				success : function(res) {
					if (res.code == 1) {
						var content = template.render({
							brands : {
								data : res.data
							}
						});
						$("#brand").html(content);
					}
				}
			});
			// 所有商品SKU类别
			$.ajax({
				url : ctx + '/api/dictskumeta/getAll',
				type : 'GET',
				dataType : 'json',
				cache : false,
				success : function(res) {
					if (res.code == 1) {
						for (var i = 0; i < res.data.length; i++) {
							skuTyps[res.data[i].id] = res.data[i];
						}
						var content = template.render({
							showProSkuAttr : {
								data : res.data
							}
						});
						$("#skuAttrs").html(content);
						skuInfo.initPage();
					}
				}
			});
		}
		// 初始化 加载控件
		var initControl = function() {
			// 复选框
			$('.i-checks').iCheck({
				checkboxClass : 'icheckbox_square-green',
				radioClass : 'iradio_square-green'
			});
			// 富文本
			$('.summernote').summernote({
				lang : 'zh-CN'
			});
			// 加载搜索时间空间,只输入一个参数表示加载输入参数的时间空间,输入两个参数表示加载开始日期和结束日期的时间空间
			// 参数为JQuery选择器的值
			var initDateControl = function(start, end) {
				var startDate = {
					elem : start,
					format : 'YYYY-MM-DD',// 时间格式
					min : '1900-01-01', // 设定最小日期
					max : '2099-06-16', // 最大日期
					isclear : true, // 是否显示清空按钮
					istime : false,// 是否显示时间
					istoday : true,
					festival : true,
					choose : function(datas) {
						endDate.min = datas; // 开始日选好后，重置结束日的最小日期
						endDate.start = datas // 将结束日的初始值设定为开始日
					}
				};
				var endDate = {
					elem : end,
					format : 'YYYY-MM-DD',
					min : '1900-01-01',
					max : '2099-06-16',
					isclear : true,
					istime : false,
					istoday : true,
					festival : true,
					choose : function(datas) {
						startDate.max = datas; // 结束日选好后，重置开始日的最大日期
					}
				};
				laydate(startDate);
				laydate(endDate);
			};
			// 时间控件
			setTimeout(function() {
				initDateControl('#listTime', '#delistTime');
			}, 1);
			// 上传空间
			UploadTools.createTo("fileImage", "img", PRO_TYPE, "imgUrl", 1);
			// 上传空间
			UploadTools.createTo("file0Image", "img", PRO_TYPE, ":file0", 5);
		}
		var attrHidden = true;
		var checkAttrs = {};
		var currId = null;
		var attrEvent = {
			putAttrs : function(id, attr) {
				if (checkAttrs.attrArray1) {
					// 如果和第一个 数组 匹配
					if (checkAttrs.attrArray1[0].id == id) {
						var isHave = false;
						for (var i = 0; i < checkAttrs.attrArray1.length; i++) {
							if (checkAttrs.attrArray1[i].attr1 == attr) {
								isHave = true;
								break;
							}
						}
						if (!isHave) {
							checkAttrs.attrArray1[checkAttrs.attrArray1.length] = {
								"id" : id,
								"attr1" : attr
							};
						}
					} else {
						if (checkAttrs.attrArray2) {
							if (checkAttrs.attrArray2[0].id == id) {
								var isHave = false;
								for (var i = 0; i < checkAttrs.attrArray2.length; i++) {
									if (checkAttrs.attrArray2[i].attr2 == attr) {
										isHave = true;
										break;
									}
								}
								if (!isHave) {
									checkAttrs.attrArray2[checkAttrs.attrArray2.length] = {
										"id" : id,
										"attr2" : attr
									};
								}
							} else {
								if (checkAttrs.attrArray3) {
									if (checkAttrs.attrArray3[0].id == id) {
										var isHave = false;
										for (var i = 0; i < checkAttrs.attrArray3.length; i++) {
											if (checkAttrs.attrArray3[i].attr3 == attr) {
												isHave = true;
												break;
											}
										}
										if (!isHave) {
											checkAttrs.attrArray3[checkAttrs.attrArray3.length] = {
												"id" : id,
												"attr3" : attr
											};
										}
									} else {
										alert("只能选择三种商品SKU属性");
									}
								} else {
									checkAttrs.attrArray3 = [];
									checkAttrs.attrArray3[0] = {
										"id" : id,
										"attr3" : attr
									};
								}
							}
						} else {
							checkAttrs.attrArray2 = [];
							checkAttrs.attrArray2[0] = {
								"id" : id,
								"attr2" : attr
							};
						}
					}
				} else {
					checkAttrs.attrArray1 = [];
					checkAttrs.attrArray1[0] = {
						"id" : id,
						"attr1" : attr
					};
				}
			},
			isCheckAttrs : function(id, attr) {
				if (checkAttrs.attrArray1 && checkAttrs.attrArray1[0].id == id) {
					for (var i = 0; i < checkAttrs.attrArray1.length; i++) {
						if (checkAttrs.attrArray1[i].attr1 == attr) {
							return true;
						}
					}
					return false;
				} else if (checkAttrs.attrArray2
						&& checkAttrs.attrArray2[0].id == id) {
					for (var i = 0; i < checkAttrs.attrArray2.length; i++) {
						if (checkAttrs.attrArray2[i].attr2 == attr) {
							return true;
						}
					}
					return false;
				} else if (checkAttrs.attrArray3
						&& checkAttrs.attrArray3[0].id == id) {
					for (var i = 0; i < checkAttrs.attrArray3.length; i++) {
						if (checkAttrs.attrArray3[i].attr3 == attr) {
							return true;
						}
					}
					return false;
				}
			},
			removeAttrs : function(id, attr) {
				if (checkAttrs.attrArray1 && checkAttrs.attrArray1[0].id == id) {
					for (var i = 0; i < checkAttrs.attrArray1.length; i++) {
						if (checkAttrs.attrArray1[i].attr1 == attr) {
							checkAttrs.attrArray1.splice(i, 1);
							break;
						}
					}
					if (checkAttrs.attrArray1.length == 0) {
						checkAttrs.attrArray1 = null;
						checkAttrs["attr1"] = null;
					}
				} else if (checkAttrs.attrArray2
						&& checkAttrs.attrArray2[0].id == id) {
					for (var i = 0; i < checkAttrs.attrArray2.length; i++) {
						if (checkAttrs.attrArray2[i].attr2 == attr) {
							checkAttrs.attrArray2.splice(i, 1);
							break;
						}
					}
					if (checkAttrs.attrArray2.length == 0) {
						checkAttrs.attrArray2 = null;
						checkAttrs["attr2"] = null;
						checkAttrs["haveAttrArray2"] = false;
					}
				} else if (checkAttrs.attrArray3
						&& checkAttrs.attrArray3[0].id == id) {
					for (var i = 0; i < checkAttrs.attrArray3.length; i++) {
						if (checkAttrs.attrArray3[i].attr3 == attr) {
							checkAttrs.attrArray3.splice(i, 1);
							break;
						}
					}
					if (checkAttrs.attrArray3.length == 0) {
						checkAttrs.attrArray3 = null;
						checkAttrs["attr3"] = null;
						checkAttrs["haveAttrArray3"] = false;
					}
				}
			},
			removeAttrsWithIndex : function(id, index) {
				if (index == 3) {
					if (checkAttrs["attrArray3"]
							&& checkAttrs["attrArray3"][0].id == id) {
						checkAttrs["attrArray3"] = null;
						checkAttrs["attr3"] = null;
						checkAttrs["haveAttrArray3"] = false;
					}
				} else if (index == 2) {
					if (checkAttrs["attrArray" + index]
							&& checkAttrs["attrArray" + index][0].id == id) {
						if (checkAttrs["attrArray3"]) {
							checkAttrs["attrArray" + index] = checkAttrs["attrArray3"];
							checkAttrs["attrArray3"] = null;
							checkAttrs["attr3"] = null;
							checkAttrs["haveAttrArray3"] = false;
						} else {
							checkAttrs["attrArray2"] = null;
							checkAttrs["attr2"] = null;
							checkAttrs["haveAttrArray2"] = false;
						}
					}
				} else if (index == 1) {
					if (checkAttrs["attrArray1"]
							&& checkAttrs["attrArray1"][0].id == id) {
						if (checkAttrs["attrArray2"]) {
							checkAttrs["attrArray1"] = checkAttrs["attrArray2"];
							if (checkAttrs["attrArray3"]) {
								checkAttrs["attrArray2"] = checkAttrs["attrArray3"];
								checkAttrs["attrArray3"] = null;
								checkAttrs["attr3"] = null;
								checkAttrs["haveAttrArray3"] = false;
							} else {
								checkAttrs["attrArray2"] = null;
								checkAttrs["attr2"] = null;
								checkAttrs["haveAttrArray2"] = false;
							}
						} else {
							checkAttrs["attrArray1"] = null;
							checkAttrs["attr1"] = null;
						}
					}
				}
			},
			swap : function(index, toIndex) {
				if (toIndex <= 0 || toIndex > 3
						|| !checkAttrs["attrArray" + toIndex]
						|| checkAttrs["attrArray" + toIndex].length <= 0) {
					return;
				}
				var tmp = checkAttrs["attrArray" + toIndex];
				var tmpArray = checkAttrs["attrArray" + index];
				if (tmpArray && tmpArray.length > 0) {
					for (var i = 0; i < tmpArray.length; i++) {
						tmpArray[i]["attr" + toIndex] = tmpArray[i]["attr"
								+ index];
						delete tmpArray[i]["attr" + index];
					}
				}
				checkAttrs["attrArray" + toIndex] = tmpArray;
				if (tmp && tmp.length > 0) {
					for (var i = 0; i < tmp.length; i++) {
						tmp[i]["attr" + index] = tmp[i]["attr" + toIndex];
						delete tmp[i]["attr" + toIndex];
					}
				}
				checkAttrs["attrArray" + index] = tmp;
			},
			initAttrTable : function() {
				var info = checkAttrs;
				info["genAttrs"] = true;
				info["isEdit"] = true;
				if (checkAttrs.attrArray1) {
					var item = skuTyps[checkAttrs.attrArray1[0].id];
					var pros = "";
					if (checkAttrs["attrArray1"]) {
						for (var i = 0; i < checkAttrs["attrArray1"].length; i++) {
							var attr = checkAttrs["attrArray1"][i].attr1;
							pros += "," + attr;
						}
						pros = pros.substring(1);
					}
					info["attr1"] = {
						"id" : item.id,
						"attr" : pros/* item.propertys */,
						"name" : item.name
					};
				}
				if (checkAttrs.attrArray2) {
					var item = skuTyps[checkAttrs.attrArray2[0].id];
					var pros = "";
					if (checkAttrs["attrArray2"]) {
						for (var i = 0; i < checkAttrs["attrArray2"].length; i++) {
							var attr = checkAttrs["attrArray2"][i].attr2;
							pros += "," + attr;
						}
						pros = pros.substring(1);
					}
					info["attr2"] = {
						"id" : item.id,
						"attr" : pros/* item.propertys */,
						"name" : item.name
					};
					info["haveAttrArray2"] = true;
				}
				if (checkAttrs.attrArray3) {
					var item = skuTyps[checkAttrs.attrArray3[0].id];
					var pros = "";
					if (checkAttrs["attrArray3"]) {
						for (var i = 0; i < checkAttrs["attrArray3"].length; i++) {
							var attr = checkAttrs["attrArray3"][i].attr3;
							pros += "," + attr;
						}
						pros = pros.substring(1);
					}
					info["attr3"] = {
						"id" : item.id,
						"attr" : pros/* item.propertys */,
						"name" : item.name
					};
					info["haveAttrArray3"] = true;
				}
				var content = template.render(info);
				$("#attrBox").html(content);
				$('.i-checks').iCheck({
					checkboxClass : 'icheckbox_square-green',
					radioClass : 'iradio_square-green'
				});
			}
		};
		var classArray = null;
		// 回调函数
		var callBackTest = function(idList, objList) {
			// console.log(objList);
			classArray = idList;
			var info = "";
			for (var i = 0; i < objList.length; i++) {
				var item = objList[i];
				info += "," + item.text;
			}
			if (info != "") {
				info = info.substring(1);
			}
			$("#currChoseClass").html(info);
		}
		// 初始化 加载事件
		var initEvent = function() {
			modalclassfycheckbox.on('click', function(event) {
				classModal.chooseClassfy(true, true, callBackTest);
			});
			$('#attrTable .i-checks').on('ifChecked', function(event) {
				var id = event.target.value;
			}).on('ifUnchecked', function(event) {
				var id = event.target.value;
			});
			$('#skuAttrInfos').on('ifChecked', function(event) {
				var id = event.target.value;
				var attr = $(event.target).data("attr")+"";
				attr = attr.replace(/\s/g, "");
				attrEvent.putAttrs(id, attr);
			}).on('ifUnchecked', function(event) {
				var id = event.target.value;
				var attr = $(event.target).data("attr")+"";
				attr = attr.replace(/\s/g, "");
				attrEvent.removeAttrs(id, attr);
			});
			$("#attrBox").on('click', '[data-handle="pro-attr-up"]',function(event) {
				var index = $(this).data("index");
				attrEvent.swap(index, (index - 1));
				attrEvent.initAttrTable();
			});
			$("#attrBox").on('click', '[data-handle="pro-attr-down"]',function(event) {
				var index = $(this).data("index");
				attrEvent.swap(index, (index + 1));
				attrEvent.initAttrTable();
			});
			$("#visual").on("change", function(event) {
				var val = event.target.value;
				if (val == "true") {
					$("#putTypeTr").show();
					$("#put_type_hand").iCheck('check');
					$("#put_type_auto").iCheck('uncheck');
				} else {
					$("#putTypeTr").hide();
					$("#put_type_hand").iCheck('uncheck');
					$("#put_type_auto").iCheck('uncheck');
				}
			});
			$("#attrBox").on('click', '[data-handle="pro-attr-del"]',function(event) {
				var index = $(this).data("index");
				if (!index) {
					return;
				}
				var id = $(this).data("id");
				attrEvent.removeAttrsWithIndex(id, index);
				attrEvent.initAttrTable();
			});
			$("#attrBox").on("click",'[data-handle="pro-add-img"]',function(event) {
				var imgConId = $(this).data("id");
				$("#checkImageModal").html(template.render({
					showImageUpload : true,
					id : imgConId
				}));
				$("#checkImageModal").modal({
					keyboard : true
				});
				UploadTools.createTo("tmpImage", "img", PRO_TYPE,
						imgConId, 1);
				$("#save_img_" + imgConId).unbind("click").bind("click",function() {
					$("#img_" + imgConId).hide();
					$("#checkImageModal").modal('hide');
					$("#img_" + imgConId).attr("src",$("#" + imgConId).val());
					$("#img_" + imgConId).show();
				});
			});
			var initAttrCheckBox = function(attr) {
				var attrArray = attr.propertys.split(",");
				var attrObjArray = [];
				for (var i = 0; i < attrArray.length; i++) {
					attrObjArray[i] = {
						"id" : attr.id
					};
					// attrObjArray[i]["attr"+(i+1)] = attrArray[i];
					attrObjArray[i]["attr"] = attrArray[i];
				}
				var content = template.render({
					currAttrs : {
						data : attrObjArray
					}
				});
				$("#skuAttrInfos").html(content);
				$('#skuAttrInfos .i-checks').iCheck({
					checkboxClass : 'icheckbox_square-green',
					radioClass : 'iradio_square-green'
				});
				$('#skuAttrInfos .i-checks').each(function() {
					var obj = $(this);
					var isCheck = attrEvent.isCheckAttrs(obj.val(), obj.data("attr").replace(/\s/g, ""));
					if (isCheck) {
						obj.iCheck('check');
					}
				});
			}
			var attrBtnBox = $("#attr-btn-box");
			$("#skuAttrs").on('change', function(event) {
				if (skuId > 0 && isSkuInfo) {
					return;
				}
				var attr = $(this).val();
				if (attr != "") {
					initAttrCheckBox(skuTyps[attr]);
				}
			});
			$("#productDefaultAttr").html(template.render({
				showDefaultAttr : true
			}));
			attrBtnBox.on('click', '[data-handle="pro-add-attr"]', function(event) {
				if (skuId > 0 && isSkuInfo) {
					return;
				}
				var text = $(this).html();
				if (attrHidden) {
					$("#attrSelectBox").show();
					var attr = $("#skuAttrs").val();
					if (attr != "") {
						initAttrCheckBox(skuTyps[attr]);
					}
					text = text.replace("添加", "隐藏");
					$(this).html(text);
					attrHidden = false;
					$("#autoAttr").show();
					$("#productDefaultAttr").html("");
				} else {
					text = text.replace("隐藏", "添加");
					$("#autoAttr").hide();
					$(this).html(text);
					$("#attrSelectBox").hide();
					attrHidden = true;
					if (checkAttrs.attrArray1) {
						$("#productDefaultAttr").html("");
					} else {
						$("#productDefaultAttr").html(template.render({
							showDefaultAttr : true
						}));
					}
				}
			});
			attrBtnBox.on('click', '[data-handle="pro-goto-attr"]', function(event) {
				window.location.href = ctx + "/product/skuTypes";
			});
			$("#attrSelectBox").on('click', '[data-handle="pro-create-attr"]',function(event) {
				if (skuId > 0 && isSkuInfo) {
					return;
				}
				attrEvent.initAttrTable();
			});
			$("#submitSku").on('click', function(event) {
				formManager.createProduct(true);
				return false;
			});
				
			$("#closeReturnBtn").on('click',function(){
				window.location.href = ctx + "/products";
			});
			
		}
		// 初始化 加载控件
		initControl();
		// 初始化 加载 数据
		initData();
		// 初始化 加载事件
		initEvent();
		$.fn.serializeObject = function() {
			var obj = {};
			var count = 0;
			$.each(this.serializeArray(), function(i, o) {
				var n = o.name, v = o.value;
				count++;
				obj[n] = obj[n] === undefined ? v : $.isArray(obj[n]) ? obj[n]
						.concat(v) : [ obj[n], v ];
			});
			// obj.nameCounts = count + "";//表单name个数
			return JSON.stringify(obj);
		};
		// 表单提交
		var formManager = {
			id : 0,
			timeStep : 60 * 1000,
			/*
			 * 定时 自动提交
			 */
			autoFormSubmit : function() {
				// ClearTimeout
				formManager.createProduct();
				setTimeout("formManager.autoFormSubmit()", formManager.timeStep);
			},
			reform : function(isNotAuto) {
				var $form = $("#proInfoForm");
				var formObj = eval('(' + $form.serializeObject() + ')');
				var fp = formObj["productImages[0].path"];
				if (fp && fp.length > 0) {
					formObj.productImages = [];
					formObj.productImages[formObj.productImages.length] = {};
					formObj.productImages[0].imageType = formObj["productImages[0].imageType"];
					formObj.productImages[0].path = fp;
					formObj.productImages[0].id = mainId;
				} else {
					if (isNotAuto) {
						toastr.error("必须上传商品主图");
						return false;
					}
				}
				delete formObj["productImages[0].imageType"];
				delete formObj["productImages[0].path"];
				var f0 = $("#file0_0").val();
				if (f0 && f0.length > 0) {
					var len = formObj.productImages.length;
					formObj.productImages[len] = {};
					formObj.productImages[len].path = f0;
					var fid = $("#file0_0").attr("fid");
					if (fid) {
						formObj.productImages[len].id = fid;
					}
				}
				var f1 = $("#file0_1").val();
				if (f1 && f1.length > 0) {
					var len = formObj.productImages.length;
					formObj.productImages[len] = {};
					formObj.productImages[len].path = f1;
					var fid = $("#file0_1").attr("fid");
					if (fid) {
						formObj.productImages[len].id = fid;
					}
				}
				var f2 = $("#file0_2").val();
				if (f2 && f2.length > 0) {
					var len = formObj.productImages.length;
					formObj.productImages[len] = {};
					formObj.productImages[len].path = f2;
					var fid = $("#file0_2").attr("fid");
					if (fid) {
						formObj.productImages[len].id = fid;
					}
				}
				var f3 = $("#file0_3").val();
				if (f3 && f3.length > 0) {
					var len = formObj.productImages.length;
					formObj.productImages[len] = {};
					formObj.productImages[len].path = f3;
					var fid = $("#file0_3").attr("fid");
					if (fid) {
						formObj.productImages[len].id = fid;
					}
				}
				var f4 = $("#file0_4").val();
				if (f4 && f4.length > 0) {
					var len = formObj.productImages.length;
					formObj.productImages[len] = {};
					formObj.productImages[len].path = f4;
					var fid = $("#file0_4").attr("fid");
					if (fid) {
						formObj.productImages[len].id = fid;
					}
				}
				if (formObj.productImages.length == 0) {
					delete formObj["productImages"];
				}
				delete formObj.file0;
				formObj.supplier = {};
				formObj.supplier.id = formObj["supplier.id"];
				delete formObj["supplier.id"];
				formObj.brand = {};
				formObj.brand.id = formObj["brand.id"];
				delete formObj["brand.id"];
				formObj.catalogs = {};
				formObj.catalogs.id = formObj["catalogs.id"];
				delete formObj["catalogs.id"];
				formObj.skus = formManager.initFormAttr();
				delete formObj["img"];
				delete formObj["number"];
				delete formObj["price"];
				delete formObj["catalogs"];
				delete formObj["cashAmt"];
				delete formObj["mergeCent"];
				delete formObj["mergeCashAmt"];
				var showStatusArray = formObj["showStatus"];
				var tmpStatus = null;
				if (showStatusArray) {
					if (showStatusArray.length == 2) {
						tmpStatus = "BOTH_VISIBLE";
					} else if (showStatusArray.length == 1) {
						tmpStatus = showStatusArray[0];
					}
				}
				delete formObj["showStatus"];
				if (tmpStatus != null) {
					formObj["showStatus"] = tmpStatus;
				}
				// console.log(formObj);
				if (classArray && classArray.length > 0) {
					formObj["catalogs"] = [];
					for (var i = 0; i < classArray.length; i++) {
						formObj["catalogs"][i] = {
							"id" : classArray[i]
						};
					}
				}
				// 商品介绍
				var introduction = $('#detailDiv .summernote').code().replace(/\s/g, "");
				// introduction = introduction.replace(/\"/g,"'");
				// 规格参数
				var specification = $('#paramDiv .summernote').code().replace(/\s/g, "");
				// specification = specification.replace(/\"/g,"'");
				// 包装清单
				var packingList = $('#listDiv .summernote').code().replace(/\s/g, "");
				// packingList = packingList.replace(/\"/g,"'");
				// 售后保障
				var afterSale = $('#warrantyDiv .summernote').code().replace(/\s/g, "");
				// afterSale = afterSale.replace(/\"/g,"'");
				formObj["description"] = {};
				formObj["description"]["introduction"] = introduction;
				formObj["description"]["specification"] = specification;
				formObj["description"]["packingList"] = packingList;
				formObj["description"]["afterSale"] = afterSale;
				// 检测是否启用
				$('#attrTable .ck').each(function(i, obj) {
					if ($(obj).is(':checked')) {
						formObj["skus"][i].status = "DISABLED";
					} else {
						formObj["skus"][i].status = "ENABLED";
					}
				});
				$('#attrTable .dis').each(function(i, obj) {
					if ($(obj).is(':checked')) {
						formObj["skus"][i].displayInlist = true;
					} else {
						formObj["skus"][i].displayInlist = false;
					}
				});
				formObj["skuMeta"] = {};
				var attribute1Name = null, attribute2Name = null, attribute3Name = null;
				if (checkAttrs.attrArray1 && checkAttrs.attrArray1.length > 0) {
					var item = skuTyps[checkAttrs.attrArray1[0].id];
					attribute1Name = item.name;
				}
				if (checkAttrs.attrArray2 && checkAttrs.attrArray2.length > 0) {
					var item = skuTyps[checkAttrs.attrArray2[0].id];
					attribute2Name = item.name;
				}
				if (checkAttrs.attrArray3 && checkAttrs.attrArray3.length > 0) {
					var item = skuTyps[checkAttrs.attrArray3[0].id];
					attribute3Name = item.name;
				}
				formObj["skuMeta"] = {
					"attribute1Name" : attribute1Name,
					"attribute2Name" : attribute2Name,
					"attribute3Name" : attribute3Name
				};
				delete formObj["status"];
				if($("#displayInlist").is(':checked')){
					formObj["displayInlist"] = true;
				}else{
					formObj["displayInlist"] = false;
				}
				return formObj;
			},
			/**
			 * 表单自动提交
			 */
			createProduct : function(isNotAuto) {
				try {
					var action = "";
					var sMsg = "";
					if (isNotAuto) {
						var id = $("#productId").val();
						if (id && id > 0) {
							action = ctx + '/api/product/' + id + '/update';
							sMsg = "更新";
						} else {
							action = ctx + '/api/product/create';
							sMsg = "上传";
						}
						var $form = $("#proInfoForm");
						// 表单验证
						var valid = $form.validate({
							// 验证规则
							rules : {
								name : {
									required : true,
									rangelength : [ 1, 20 ]
								}
							},
							/* 设置错误信息 */
							messages : {
								name : {
									required : "请填写商品名称",
									rangelength : "商品名称必须在1-20个字符之间"
								}
							}
						});
						if (!$form.valid()) {
							return;
						}
						if (valid.errorList && valid.errorList.length > 0) {
							return;
						}
					} else {
						if (formManager.id != 0) {
							action = ctx + '/api/product/' + formManager.id
									+ '/update/temp';
							sMsg = "更新";
						} else {
							action = ctx + '/api/product/create/temp';
							sMsg = "上传";
						}
					}

					var formData = formManager.reform(isNotAuto);
					if (!formData) {
						return;
					}
					$.ajax({
						url : action,
						type : 'post',
						dataType : 'json',
						cache : false,
						data : {
							"productJson" : JSON.stringify(formData)
						},
						success : function(res) {
							if (res.code == "1") {
								if (res.data) {
									formManager.id = res.data;
								}
								if (isNotAuto) {
									toastr.success("商品" + sMsg + "成功！");
								}
							}
						}
					});
				} catch (e) {
				}
			},
			initFormAttr : function() {
				var skus = [];
				var priceObjArray = $("#attrBox input[name='price']");
				var skuCodeObjArray = $("#attrBox input[name='number']");
				var cashAmtArray = $("#attrBox input[name='cashAmt']");
				var mergeCentArray = $("#attrBox input[name='mergeCent']");
				var mergeCashAmtArray = $("#attrBox input[name='mergeCashAmt']");
				var filePath = $("#attrBox input[name='img']");
				var imageIds = $("#attrBox input[name='imgId']");
				var skuIds = $("#attrBox input[name='skuId']");
				var index = 0;
				if (checkAttrs.attrArray1) {
					for (var i = 0; i < checkAttrs.attrArray1.length; i++) {
						var attr1 = checkAttrs.attrArray1[i].attr1;
						var attr2 = null;
						var attr3 = null;
						if (checkAttrs.attrArray2) {
							for (var j = 0; j < checkAttrs.attrArray2.length; j++) {
								attr2 = checkAttrs.attrArray2[j].attr2;
								if (checkAttrs.attrArray3) {
									for (var k = 0; k < checkAttrs.attrArray3.length; k++) {
										attr3 = checkAttrs.attrArray3[k].attr3;
										var imgPath = filePath.eq(index).val();
										var len = skus.length;
										if (imgPath && imgPath.length > 0) {
											skus[len] = {
												"attribute1" : attr1,
												"attribute2" : attr2,
												"attribute3" : attr3,
												"cent" : priceObjArray.eq(index).val(),
												productImages : [ {
													path : filePath.eq(index).val()
												} ],
												skuCode : skuCodeObjArray.eq(index).val(),
												"cashAmt":cashAmtArray.eq(index).val(),
												"mergeCent":mergeCentArray.eq(index).val(),
												"mergeCashAmt":mergeCashAmtArray.eq(index).val()
											};
										} else {
											skus[len] = {
												"attribute1" : attr1,
												"attribute2" : attr2,
												"attribute3" : attr3,
												"cent" : priceObjArray.eq(index).val(),
												skuCode : skuCodeObjArray.eq(index).val(),
												"cashAmt":cashAmtArray.eq(index).val(),
												"mergeCent":mergeCentArray.eq(index).val(),
												"mergeCashAmt":mergeCashAmtArray.eq(index).val()
											};
										}
										var id = imageIds.eq(index).val();
										if (id && id.length > 0) {
											skus[len].productImages[0].id = id;
										}
										var skuId = skuIds.eq(index).val();
										if (skuId && skuId.length > 0 && skuId > 0) {
											skus[len].id = skuId;
										}
										index++;
									}
								} else {
									attr3 = "";
									var imgPath = filePath.eq(index).val();
									var len = skus.length;
									if (imgPath && imgPath.length > 0) {
										skus[len] = {
											"attribute1" : attr1,
											"attribute2" : attr2,
											"attribute3" : attr3,
											"cent" : priceObjArray.eq(index).val(),
											productImages : [ {
												path : filePath.eq(index).val()
											} ],
											skuCode : skuCodeObjArray.eq(index).val(),
											"cashAmt":cashAmtArray.eq(index).val(),
											"mergeCent":mergeCentArray.eq(index).val(),
											"mergeCashAmt":mergeCashAmtArray.eq(index).val()
										};
									} else {
										skus[len] = {
											"attribute1" : attr1,
											"attribute2" : attr2,
											"attribute3" : attr3,
											"cent" : priceObjArray.eq(index).val(),
											skuCode : skuCodeObjArray.eq(index).val(),
											"cashAmt":cashAmtArray.eq(index).val(),
											"mergeCent":mergeCentArray.eq(index).val(),
											"mergeCashAmt":mergeCashAmtArray.eq(index).val()
										};
									}
									var id = imageIds.eq(index).val();
									if (id && id.length > 0) {
										skus[len].productImages[0].id = id;
									}
									var skuId = skuIds.eq(index).val();
									if (skuId && skuId.length > 0 && skuId > 0) {
										skus[len].id = skuId;
									}
									index++;
								}
							}
						} else {
							attr2 = "";
							attr3 = "";
							var len = skus.length;
							var imgPath = filePath.eq(index).val();
							if (imgPath && imgPath.length > 0) {
								skus[len] = {
									"attribute1" : attr1,
									"attribute2" : attr2,
									"attribute3" : attr3,
									"cent" : priceObjArray.eq(index).val(),
									productImages : [ {
										path : filePath.eq(index).val()
									} ],
									skuCode : skuCodeObjArray.eq(index).val(),
									"cashAmt":cashAmtArray.eq(index).val(),
									"mergeCent":mergeCentArray.eq(index).val(),
									"mergeCashAmt":mergeCashAmtArray.eq(index).val()
								};
							} else {
								skus[len] = {
									"attribute1" : attr1,
									"attribute2" : attr2,
									"attribute3" : attr3,
									"cent" : priceObjArray.eq(index).val(),
									skuCode : skuCodeObjArray.eq(index).val(),
									"cashAmt":cashAmtArray.eq(index).val(),
									"mergeCent":mergeCentArray.eq(index).val(),
									"mergeCashAmt":mergeCashAmtArray.eq(index).val()
								};
							}
							var id = imageIds.eq(index).val();
							if (id && id.length > 0) {
								skus[len].productImages[0].id = id;
							}
							var skuId = skuIds.eq(index).val();
							if (skuId && skuId.length > 0 && skuId > 0) {
								skus[len].id = skuId;
							}
							index++;
						}
					}
				} else {
					var status = "ENABLED";
					if ($("#ck_status").is(':checked')) {
						status = "DISABLED";
					}
					var dis = "false";
					if ($("#displayInlist").is(':checked')) {
						dis = "true";
					}
					skus[skus.length] = {
						"attribute1" : "",
						"attribute2" : "",
						"attribute3" : "",
						"cent" : $("#price").val(),
						"cashAmt" : $("#cashAmt").val(),
						"mergeCent":$("#mergeCent").val(),
						"mergeCashAmt":$("#mergeCashAmt").val(),
						"id":$("#sku_one_id").val(),
						skuCode : $("#code").val(),
						"status" : status,
						"displayInlist":dis
					};
				}
				return skus;
			}
		};
		window.formManager = formManager;
		// 定时执行提交任务
		setTimeout("formManager.autoFormSubmit()", formManager.timeStep);
	});
})(window, document, this.jQuery, Hogan, this.RocoUtils);