(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        // 扩展Date的format方法
        Date.prototype.format = function (format) {
            var o = {
                "M+": this.getMonth() + 1,
                "d+": this.getDate(),
                "h+": this.getHours(),
                "m+": this.getMinutes(),
                "s+": this.getSeconds(),
                "q+": Math.floor((this.getMonth() + 3) / 3),
                "S": this.getMilliseconds()
            }
            if (/(y+)/.test(format)) {
                format = format.replace(RegExp.$1, (this.getFullYear() + "")
                    .substr(4 - RegExp.$1.length));
            }
            for (var k in o) {
                if (new RegExp("(" + k + ")").test(format)) {
                    format = format.replace(RegExp.$1,
                        RegExp.$1.length == 1 ? o[k] : ("00" + o[k])
                            .substr(("" + o[k]).length));
                }
            }
            return format;
        };
        // 高亮导航条
        RocoUtils.setSection('operation', 'products');

        var template = Hogan.compile($('#hoganTmpl').html());
        var productDataTable = $("#productDataTable");
        // 从服务端获得所有排行类型
        var types = [{
            "id": "DRAFT",
            name: "草稿"
        }, {
            "id": "READY_LIST",
            name: "待上架"
        }, {
            "id": "AUDIT",
            name: "审批中"
        }, {
            "id": "LIST",
            name: "已上架"
        }, {
            "id": "DELIST",
            name: "已下架"
        }, {
            "id": "REFUSE",
            name: "拒绝"
        }, {
            "id": "DISCARD",
            name: "已作废"
        }];
        var typeMap = {
            "DRAFT": "草稿",
            "READY_LIST": "待上架",
            "AUDIT": "审批中",
            "LIST": "已上架",
            "DELIST": "已下架",
            "REFUSE": "拒绝",
            "DISCARD": "已作废"
        };
        var typeContent = template.render({
            types: {
                data: types
            }
        });
        $("#types").html(typeContent);
        // 商品分类 类型ID
        var classify = null;
        // 获取所有分类
        $.ajax({
            url: ctx + '/api/catalog/tree',
            type: 'GET',
            dataType: 'json',
            cache: false,
            success: function (res) {
                if (res.code == 1) {
                    classify = res.data;
                    var content = template.render({
                        classifys: {
                            data: res.data
                        }
                    });
                    $("#searchTypeId").html(content);
                }
            }
        });
        // 获取所有供应商
        var suppliers = null;
        $.ajax({
            url: ctx + '/api/supplier/loginedSuppliers',
            type: 'GET',
            dataType: 'json',
            cache: false,
            success: function (res) {
                if (res.code == 1) {
                    suppliers = res.data;
                    var content = template.render({
                        suppliers: {
                            data: res.data
                        }
                    });
                    $("#searchSuppliers").html(content);
                }
            }
        });
        // 获取所有供应商
        var brands = null;
        $.ajax({
            url: ctx + '/api/brand/all',
            type: 'GET',
            dataType: 'json',
            cache: false,
            success: function (res) {
                if (res.code == 1) {
                    brands = res.data;
                    var content = template.render({
                        brands: {
                            data: res.data
                        }
                    });
                }
            }
        });
        // 加载搜索时间空间,只输入一个参数表示加载输入参数的时间空间,输入两个参数表示加载开始日期和结束日期的时间空间 参数为JQuery选择器的值
        // 如 '#startDate'
        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,
                format: 'YYYY-MM-DD',// 时间格式
                min: '1900-01-01', // 设定最小日期
                max: '2099-06-16', // 最大日期
                isclear: true, // 是否显示清空按钮
                istime: false,// 是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; // 开始日选好后，重置结束日的最小日期
                    endDate.start = datas // 将结束日的初始值设定为开始日
                }
            };
            var endDate = {
                elem: end,
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; // 结束日选好后，重置开始日的最大日期
                }
            };
            laydate(startDate);
            laydate(endDate);
        };
        // 初始化列表
        var dataTable = $('#productDataTable').DataTable({
            columns: [{
                data: 'code',
                title: 'sku编码',
                width: '8%',
                render: function (data, type, full, meta) {
                    return full.code;
                }
            }, {
                data: 'name',
                title: '商品名称',
                width: '30%',
            }, {
                data: 'attributes',
                title: 'SKU',
                width: '8%',
            }, {
                data: 'cent',
                title: '积分',
                width: '4%'
            }, {
                data: 'cashAmt',
                title: '现金',
                width: '4%'
            }, {
                data: 'availableStockQuantity',
                title: '可售库存',
                width: '8%'
            }, {
                data: 'c2',
                title: '状态',
                width: '6%',
                render: function (data, type, full, meta) {
                    var ret = typeMap[full.product.status];
                    if (!ret) {
                        ret = "";
                    }
                    return ret;
                }
            }, {
                data: 'c1',// skuId productId
                title: '操作',
                width: '22%',
                className: 'td_center',
                render: function (data, type, full, meta) {
                    // full.canDos 这是个 操作数组
                    var editJson = {
                        editBtn: {}
                    };
                    if (full.canDos) {
                        for (var i = 0; i < full.canDos.length; i++) {
                            editJson.editBtn[full.canDos[i]] = true;
                        }
                    }
                    editJson.editBtn.id = full.id;
                    editJson.editBtn.proId = full.product.id;
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render(editJson);
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/sku',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: false,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            lengthChange: false, // 是否允许显示分页数
            // order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条 粘贴过来的，没用
                // $('#productDataTable_length').hide();
            }
        });
        // search实现部分
        var searchForm = $('#searchForm'), searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });
        // 添加按钮
        var createBtn = $('#createBtn');
        // 生成静态Js文件按钮
        var generateJsBtn = $('#generateProductJs');
        var skuDetail = $("#skuDetailModal");
        // 模式窗体
        var skuModal = $('#skuModal');
        var searchType = $("#types");

        // 模式窗体绑定事件
        var bindSkuDetailEvent = function ($modal, data) {
            $modal.html(template
                .render({
                    skuDetail: true,
                    sku: data.skus[0],
                    supplier: data.supplier,
                    listTime: new Date(data.listTime)
                        .format("yyyy-MM-dd hh:mm:ss"),
                    delistTime: new Date(data.delistTime)
                        .format("yyyy-MM-dd hh:mm:ss"),
                    catalogs: data.catalogs,
                    productImages: data.productImages[0],
                    description: data.description,
                    promotionWord: data.promotionWord,
                    supportDiscount: data.supportDiscount,
                    visual: data.visual,
                    showStatus: data.showStatus == "PC_VISIBLE" ? "PC可见"
                        : "移动端可见",
                    status: typeMap[data.status]
                }));
            var DetailDataTable = $("#DetailDataTable").DataTable(
                {
                    columns: [
                        {
                            data: "id",
                            visible: false
                        },
                        {
                            data: 'index',
                            title: '',
                            width: '3%',
                            defaultContent: "",
                            orderable: false
                        },
                        {
                            data: 'attribute1',
                            title: '属性1',
                            width: '10%',
                            defaultContent: "",
                            orderable: false
                        },
                        {
                            data: 'attribute2',
                            title: '属性2',
                            width: '10%',
                            defaultContent: "",
                            orderable: false
                        },
                        {
                            data: 'attribute3',
                            title: '属性3',
                            width: '10%',
                            defaultContent: "",
                            orderable: false
                        },
                        {
                            data: 'code',
                            title: 'sku编码',
                            width: '10%',
                            defaultContent: "",
                            orderable: false
                        },
                        {
                            data: 'status',
                            title: '状态',
                            width: '10%',
                            defaultContent: "",
                            orderable: false,
                            render: function (data, type, full, meta) {
                                return full.status == "ENABLED" ? "启用"
                                    : "禁用";
                            }
                        },
                        {
                            data: 'cent',
                            title: '积分',
                            width: '10%',
                            defaultContent: "0",
                            orderable: false
                        },
                        {
                            data: 'cashAmt',
                            title: '现金',
                            width: '10%',
                            defaultContent: "0.0",
                            orderable: false
                        },
                        {
                            data: 'previewImagePath',
                            title: '图片',
                            width: '10%',
                            defaultContent: "",
                            orderable: false,
                            render: function (data, type, full, meta) {
                                return '<img src="'
                                    + full.previewImagePath
                                    + '" width="50" />';
                            }
                        }],
                    processing: true,
                    serverSide: false,
                    "data": data.skus,
                    paging: false,
                    ordering: true,
                    info: true,
                    searching: false,
                    lengthChange: false, // 是否允许显示分页数
                    initComplete: function () {
                    }
                });
            DetailDataTable.off('order.dt search.dt').on('order.dt search.dt',
                function () {
                    DetailDataTable.column(1, {
                        search: 'applied',
                        order: 'applied'
                    }).nodes().each(function (cell, i) {
                        cell.innerHTML = i + 1;
                    });
                }).draw();
            var historyDataTable = $("#historyDataTable").DataTable({
                columns: [{
                    data: "id",
                    visible: false
                }, {
                    data: 'index',
                    title: '',
                    width: '3%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'cent',
                    title: '积分',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'cashAmt',
                    title: '现金',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'user.name',
                    title: '修改人',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'time',
                    title: '修改时间',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }],
                processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/product/' + data.id + '/price-history',
                    type: 'GET',
                    data: function (d) {
                        return $.extend(RocoUtils.buildParam(d), null);
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'desc'],
                lengthChange: false, // 是否允许显示分页数
                initComplete: function () {
                }
            });
            historyDataTable.off('order.dt search.dt').on('order.dt search.dt',
                function () {
                    historyDataTable.column(1, {
                        search: 'applied',
                        order: 'applied'
                    }).nodes().each(function (cell, i) {
                        cell.innerHTML = i + 1;
                    });
                }).draw();
            var opDataTable = $("#opDataTable").DataTable({
                columns: [{
                    data: "id",
                    visible: false
                }, {
                    data: 'index',
                    title: '',
                    width: '3%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'action.label',
                    title: '操作',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'user.name',
                    title: '操作人',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'actionTime',
                    title: '时间',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }],
                processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/product/' + data.id + '/admin-log',
                    type: 'GET',
                    data: function (d) {
                        return $.extend(RocoUtils.buildParam(d), null);
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'desc'],
                lengthChange: false, // 是否允许显示分页数
                initComplete: function () {
                }
            });
            opDataTable.off('order.dt search.dt').on('order.dt search.dt',
                function () {
                    opDataTable.column(1, {
                        search: 'applied',
                        order: 'applied'
                    }).nodes().each(function (cell, i) {
                        cell.innerHTML = i + 1;
                    });
                }).draw();

            //入库记录table  入库单号、仓库名称、入库数量、操作人、类型（采购入库/退货）、入库时间
            var inStoreTable = $("#inStoreTable").DataTable({
                columns: [{
                    data: "id",
                    visible: false
                }, {
                    data: 'index',
                    title: '',
                    width: '3%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'code',
                    title: '入库单号',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'sku.name',
                    title: '商品名称',
                    width: '50%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'warehouse.name',
                    title: '仓库名称',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'quantity',
                    title: '数量',
                    width: '5%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'operator.username',
                    title: '操作人',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'inType',
                    title: '类型',
                    width: '10%',
                    defaultContent: "",
                    orderable: false,
                    render: function (data, type, full, meta) {
                        if (data == 'PURCHASE') {
                            return "采购入库";
                        } else if (data == 'REFUND') {
                            return "退货入库";
                        } else {
                            return "";
                        }
                    }
                }, {
                    data: 'receiveDateTime',
                    title: '入库时间',
                    width: '15%',
                    defaultContent: "",
                    orderable: false,
                    render: function (data, type, full, meta) {
                        return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm:ss');
                    }
                }],
                processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/product/' + data.id + '/instoreRecord',
                    type: 'GET',
                    data: function (d) {
                        return $.extend(RocoUtils.buildParam(d), null);
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'desc'],
                lengthChange: false, // 是否允许显示分页数
                initComplete: function () {
                }
            });
            inStoreTable.off('order.dt search.dt').on('order.dt search.dt',
                function () {
                    inStoreTable.column(1, {
                        search: 'applied',
                        order: 'applied'
                    }).nodes().each(function (cell, i) {
                        cell.innerHTML = i + 1;
                    });
                }).draw();

            //chu库记录table  出库单号、仓库名称、快递公司、合并商品数量、出库时间
            var outStoreTable = $("#outStoreTable").DataTable({
                columns: [{
                    data: "id",
                    visible: false
                }, {
                    data: 'index',
                    title: '',
                    width: '3%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'code',
                    title: '出库单号',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'sku.name',
                    title: '商品名称',
                    width: '35%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'warehouse.name',
                    title: '仓库名称',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'express.name',
                    title: '快递公司',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'quantity',
                    title: '数量',
                    width: '5%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'operator.username',
                    title: '操作人',
                    width: '10%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'operateDatetime',
                    title: '出库时间',
                    width: '15%',
                    defaultContent: "",
                    orderable: false,
                    render: function (data, type, full, meta) {
                        return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm:ss');
                    }
                }],
                processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/product/' + data.id + '/outstoreRecord',
                    type: 'GET',
                    data: function (d) {
                        return $.extend(RocoUtils.buildParam(d), null);
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 20,
                lengthMenu: [20],
                order: [0, 'desc'],
                lengthChange: false, // 是否允许显示分页数
                initComplete: function () {
                }
            });
            outStoreTable.off('order.dt search.dt').on('order.dt search.dt',
                function () {
                    outStoreTable.column(1, {
                        search: 'applied',
                        order: 'applied'
                    }).nodes().each(function (cell, i) {
                        cell.innerHTML = i + 1;
                    });
                }).draw();

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
        };
        var showSkuDetail = function (skuId) {
            $.ajax({
                url: ctx + "/api/product/" + skuId + "/detail",
                type: 'GET',
                dataType: 'json',
                traditional: true,
                cache: false,
                beforeSend: function () {
                    btnDisable();
                },
                success: function (res) {
                    if (res.code == "1") {
                        bindSkuDetailEvent(skuDetail, res.data);
                        console.log(res.data);
                    }
                },
                complete: function () {
                    btnEnable();
                }
            });
        };

        var staticSku = function (skuId) {
            $.ajax({
                url: ctx + "/api/generatejs/skuDetail/" + skuId,
                type: 'GET',
                dataType: 'json',
                traditional: true,
                cache: false,
                beforeSend: function () {
                    btnDisable();
                },
                success: function (res) {
                    if (res.code == "1") {
                        toastr.success('生成静态页成功');
                    }
                },
                complete: function () {
                    btnEnable();
                }
            });
        };

        // 绑定事件
        var bindEvent = function () {
            // 创建按键点击
            createBtn.on('click', function (event) {
                window.location.href = ctx + "/product/detail";
                // bindModalEvent(skuModal, null);
                // event.stopPropagation();
            });
            // 编辑
            dataTable.on('click', '[data-handle="sku-edit"]', function (event) {
                window.location.href = ctx + "/product/detail?"
                    + $(this).data('id');
            });
            // 作废
            dataTable.on('click', '[data-handle="sku-discard"]',
                function (event) {
                    modifySkuStatus($(this).data('id') + "/discard", "作废");
                });
            // 提交审批
            dataTable.on('click', '[data-handle="sku-submitAudit"]', function (event) {
                modifySkuStatus($(this).data('id') + "/submit-audit", "提交审批");
            });
            // 审批拒绝
            dataTable.on('click', '[data-handle="sku-auditRefuse"]', function (event) {
                modifySkuStatus($(this).data('id') + "/audit-refuse", "审批拒绝");
            });
            // 审批通过
            dataTable.on('click', '[data-handle="sku-auditOk"]',
                function (event) {
                    modifySkuStatus($(this).data('id') + "/audit-ok",
                        "审批通过");
                });
            // 下架
            dataTable.on('click', '[data-handle="sku-deList"]',
                function (event) {
                    modifySkuStatus($(this).data('id') + "/de-list", "下架");
                });
            // 上架
            dataTable.on('click', '[data-handle="sku-list"]', function (event) {
                modifySkuStatus($(this).data('id') + "/list", "上架");
            });
            // 预览
            dataTable.on('click', '[data-handle="sku-view"]', function (event) {
                window.open("http://localhost:14081/product/" + $(this).data('id'));
            });
            // 详情
            dataTable.on('click', '[data-handle="sku-detail"]',
                function (event) {
                    var skuId = $(this).data('id');
                    showSkuDetail(skuId);
                });
            dataTable.on('click', '[data-handle="sku-static"]',
                function (event) {
                    var skuId = $(this).data('id');
                    staticSku(skuId);
                }
            );

            // 类型查询
            $("#types").on(
                'click',
                '[data-handle="product-status"]',
                function (event) {
                    $("#types button").removeClass("active");
                    $(this).addClass("active");
                    searchParam = RocoUtils.parseQueryString(searchForm
                        .serialize());
                    var typeId = $(this).data('id');
                    if (typeId && (typeId > 0 || typeId != "")) {
                        searchParam["status"] = typeId;
                    }
                    dataTable.ajax.reload(null, true);
                    return false;
                });

            generateJsBtn.on('click', function (event) {
                $.ajax({
                    url: ctx + '/api/generatejs/list/allProd',
                    type: 'get',
                    dataType: 'json',
                    data: {},
                    cache: false,
                    beforeSend: function () {
                        btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('商品JS文件生成成功');
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });

            });

        };
        var modifySkuStatus = function (url, msg) {
            $.ajax({
                url: ctx + '/api/product/' + url,
                type: 'post',
                dataType: 'json',
                traditional: true,
                cache: false,
                beforeSend: function () {
                    btnDisable();
                },
                success: function (res) {
                    if (res.code == "1") {
                        toastr.success(msg + '成功');
                        // 刷新列表
                        dataTable.ajax.reload();
                    }
                },
                complete: function () {
                    btnEnable();
                }
            });
        };
        var attr_handle = {
            attr1Array: [],
            attr2Array: [],
            attr3Array: [],
            attr1Index: 0,
            attr2Index: 0,
            attr3Index: 0,
            allSku: [],
            bindEvent: function () {
                $("#attr1Div").off("click").on('click',
                    '[data-handle="attr-add1"]', function (event) {
                        var id = $(this).data('id');
                        attr_handle.createAttr(id);
                    });
                $("#attr2Div").off("click").on('click',
                    '[data-handle="attr-add2"]', function (event) {
                        var id = $(this).data('id');
                        attr_handle.createAttr(id);
                    });
                $("#attr3Div").off("click").on('click',
                    '[data-handle="attr-add3"]', function (event) {
                        var id = $(this).data('id');
                        attr_handle.createAttr(id);
                    });
                $("#attrGenerate").off("click").on('click',
                    '[data-handle="attr-generate"]', function (event) {
                        attr_handle.generateSku();
                    });
            },
            createAttr: function (id) {
                var val = $("#value" + id).val();
                var att = $("#attr" + id).val();
                if (att == "") {
                    return;
                }
                if (val == "") {
                    return;
                }
                var attrArray = attr_handle["attr" + id + "Array"];
                for (var i = 0; i < attrArray.length; i++) {
                    if (attrArray[i].val == val) {
                        return;
                    }
                }
                var tmpIndex = attr_handle["attr" + id + "Index"];
                var content = template.render({
                    createAttribute: {
                        val: val,
                        "id": id,
                        "index": tmpIndex
                    }
                });
                var attrJson = {
                    "id": id,
                    "attr": att,
                    "val": val
                };
                attrArray.push(attrJson);
                $("#attr" + id + "Div").find("ul").append(content);
                attr_handle.closeAttr(id, tmpIndex, attrJson);
                attr_handle["attr" + id + "Index"] = parseInt(tmpIndex) + 1;
            },
            closeAttr: function (id, index, attrJson) {
                $("#close_" + id + "_" + index).unbind("click").bind(
                    'click',
                    function (event) {
                        $(this).parent().remove();
                        var attrArray = attr_handle["attr" + id + "Array"];
                        for (var i = 0; i < attrArray.length; i++) {
                            if (attrArray[i].attr == attrJson.attr
                                && attrArray[i].val == attrJson.val) {
                                attrArray.splice(i, 1);
                                break;
                            }
                        }
                    });
            },
            generateSku: function () {
                var index = 0;
                $("#generateBox").html("");
                for (var i = 0; i < attr_handle.attr1Array.length; i++) {
                    for (var j = 0; j < attr_handle.attr2Array.length; j++) {
                        for (var k = 0; k < attr_handle.attr3Array.length; k++) {
                            var hl = attr_handle.generateSkuHtml(index,
                                attr_handle.attr1Array[i],
                                attr_handle.attr2Array[j],
                                attr_handle.attr3Array[k]);
                            $("#generateBox").append(hl);
                            index++;
                        }
                    }
                }
                // 激活checkbox为ichecks
                $("#generateBox").find('.i-checks').iCheck({
                    checkboxClass: 'icheckbox_square-green',
                    radioClass: 'iradio_square-green',
                });
            },
            generateSkuHtml: function (index, attr1, attr2, attr3) {
                return template.render({
                    createSku: {
                        "index": (parseInt(index) + 1),
                        "sku": {
                            "attr1": attr1,
                            "attr2": attr2,
                            "attr3": attr3
                        }
                    }
                });
            }
        }

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data) {
            $modal.html(template.render({
                modal: true,
                rank: (data == undefined ? {} : data),
                "suppliers": suppliers,
                "brands": brands,
                "classifys": classify,
                "product": data
            }));
            $modal.one('shown.bs.modal', function () {
                setTimeout(function () {
                    initDateControl('#listTime', '#delistTime');
                }, 1);
            });
            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });
            $modal.find('.summernote').summernote({
                lang: 'zh-CN'
            });
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            attr_handle.bindEvent();
            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                    displayOrder: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                        digits: true
                    },
                    skuId: {
                        required: true,
                        maxlength: 20,
                        minlength: 6,
                        digits: true
                    }
                },
                submitHandler: function (form) {
                    var formObj = {};
                    var formList = decodeURI($(form).serialize()).split('&');
                    $(formList).each(function (idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });

                    $.ajax({
                        url: ctx + '/api/rank/save',
                        type: 'post',
                        dataType: 'json',
                        data: formObj,
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                                //dataTable.dataTable().fnDraw(false);
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            // $('#deleteRank').attr('disabled', 'disabled');
            // $('#submitRank').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            // $('#deleteRank').removeAttr('disabled');
            // $('#submitRank').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);