(function(window, document, $, Hogan, RocoUtils) {
	$(function() {
		// 高亮导航条
		RocoUtils.setSection('data-dict', 'proSku');

		var template = Hogan.compile($('#hoganTmpl').html());
		var skuTypesDataTable = $("#skuTypesDataTable");

		// 初始化列表
		var dataTable = $('#skuTypesDataTable').DataTable({
			columns : [ {
				data : "id",
				visible : false
			}, {
				data : 'index',
				title : '',
				defaultContent : '',
				className : 'td_center',
				orderable : false,
				width : '3%'
			}, {
				data : 'name',
				title : '属性名称',
				width : '10%',
				orderable : true
			}, {
				data : 'propertys',
				title : '属性内容',
				width : '25%',
				orderable : false,
				render : function(data, type, full, meta) {
					return decodeURIComponent(full.propertys);
				}
			}, {
				data : 'displayName',
				title : '显示名称',
				width : '25%',
				orderable : false
			}, {
				data : 'id',
				title : '操作',
				width : '37%',
				className : 'td_center',
				orderable : false,
				render : function(data, type, full, meta) {
					// 返回编辑按钮 包含事件名称和id值
					return template.render({
						editBtn : {
							id : full.id
						}
					});
				}
			} ],
			processing : true,
			serverSide : true,
			ajax : {
				url : ctx + '/api/dictskumeta',
				type : 'GET',
				data : function(d) {
					return $.extend(RocoUtils.buildParam(d), searchParam);
				}
			},
			paging : true,
			ordering : true,
			info : true,
			searching : false,
			// 每页20条
			pageLength : 20,
			lengthMenu : [ 20 ],
			lengthChange : false, // 是否允许显示分页数
			order : [ 0, 'desc' ],
			initComplete : function() {
				// 不显示每页多少条 粘贴过来的，没用
				// $('#rankTypeDataTable_length').hide();
			}
		});
		dataTable.on('order.dt search.dt', function() {
			dataTable.column(1, {
				search : 'applied',
				order : 'applied'
			}).nodes().each(function(cell, i) {
				cell.innerHTML = i + 1;
			});
		}).draw();
		// search实现部分
		var searchForm = $('#searchForm'), searchParam = null;
		// search表单提交
		searchForm.on('submit', function() {
			searchParam = RocoUtils.parseQueryString(searchForm.serialize());
			dataTable.ajax.reload(null, true);
			return false;
		});

		// 添加按钮
		var createBtn = $('#createBtn');
		// 模式窗体
		var skuTypesModal = $('#skuTypesModal');

		// 绑定事件
		var bindEvent = function() {
			// 编辑按键点击
			dataTable.on('click', '[data-handle="skuTypes-edit"]', function(
					event) {
				var id = $(this).data('id');
				$.ajax({
					url : ctx + '/api/dictskumeta/' + id + '/getInfo',
					type : 'POST',
					dataType : 'json',
					cache : false,
					success : function(res) {
						if (res.code == 1) {
							bindModalEvent(skuTypesModal, res.data);
						}
					}
				});
				event.stopPropagation();
			});

			// 锁定开启 按键点击
			skuTypesDataTable.on('click', '[data-handle="skuTypes-operation"]',
					function(event) {
						var id = $(this).data('id');
						var status = $(this).data('status');
						status = status == 'OPEN' ? 'LOCK' : 'OPEN';
						$.ajax({
							url : ctx + '/api/dictskumeta/' + id + '/switch',
							type : 'get',
							dataType : 'json',
							data : {
								status : status
							},
							cache : false,
							beforeSend : function() {
								btnDisable();
							},
							success : function(res) {
								if (res.code == 1) {
									toastr.success('操作成功');
									// roleModal.modal('hide');
									// 刷新列表
									dataTable.ajax.reload();
								}
							},
							complete : function() {
								btnEnable();
							}
						});
						event.stopPropagation();
					});

			// 编辑按键点击
			skuTypesDataTable.on('click', '[data-handle="skuTypes-delete"]',
					function(event) {
						var id = $(this).data('id');
						$.ajax({
							url : ctx + '/api/dictskumeta/delete/' + id,
							type : 'POST',
							dataType : 'json',
							cache : false,
							success : function(res) {
								if (res.code == 1) {
									// bindModalEvent(rankTypeModal, res.data);
									// rankTypeModal.modal('hide');
									// 刷新列表
									dataTable.ajax.reload();
								}
							}
						});
						event.stopPropagation();
					});

			// 创建按键点击
			createBtn.on('click', function(event) {
				// 重置模式窗体内html
				$.ajax({
					url : ctx + '/api/dictskumeta/0/getInfo',
					type : 'POST',
					dataType : 'json',
					cache : false,
					beforeSend : function() {
						btnDisable();
					},
					success : function(res) {
						if (res.code == 1) {
							bindModalEvent(skuTypesModal, res.data);
						}
					},
					complete : function() {
						btnEnable();
					}
				});
				event.stopPropagation();
			});

		};

		// 模式窗体绑定事件
		var bindModalEvent = function($modal, data) {
			var isShowAttrs = false;
			var attrVals = [];
			if (data && data.propertys != "" && data.propertys.length >= 1) {
				var attrs = decodeURIComponent(data.propertys).split(",");
				for (var i = 0; i < attrs.length; i++) {
					attrVals[i] = {};
					attrVals[i].attr = attrs[i];
				}
				isShowAttrs = true;
			}

			$modal.html(template.render({
				modal : true,
				skuTypes : (data == undefined ? {} : data)
			}));

			if (isShowAttrs) {
				$("#attrContent").html(template.render({
					showAttrs : true,
					attrs : attrVals
				}));
			}

			// 激活checkbox为ichecks
			$modal.find('.i-checks').iCheck({
				checkboxClass : 'icheckbox_square-green',
				radioClass : 'iradio_square-green',
			});

			// 展示模式窗体
			$modal.modal({
				keyboard : true
			});

			$modal.on('click', '[data-handle="attr-delete"]', function(event) {
				var id = $(this).data('id');
				var attrs = $("#propertys").val() + ",";
				attrs = decodeURIComponent(attrs).replace(id + ",", "");
				if (attrs.lastIndexOf(",") == attrs.length - 1) {
					attrs = attrs.substring(0, attrs.length - 1);
				}
				if (attrs.indexOf(",") == 0) {
					attrs = attrs.substring(1);
				}
				$("#propertys").val(attrs);
				initAttrBox(attrs);
			});
			$modal.on('click', '[data-handle="attr-add"]', function(event) {
				attrAdd();
			});

			var $form = $modal.find('form');

			// 表单验证
			$form.validate({
				rules : {
					name : {
						required : true,
						maxlength : 20
					}
				},
				submitHandler : function(form) {
					var formObj = {};
					attrAdd();
					var formList = decodeURIComponent(
						$(form).serialize()).split('&');
						$(formList).each(function(idx, item) {
						var keyValue = item.split('=');
						if (keyValue.length > 1) {
							formObj[keyValue[0]] = keyValue[1];
						}
					});
					$.ajax({
						url : form.id.value != "0" ? (ctx + '/api/dictskumeta/update')
							: (ctx + '/api/dictskumeta/create'),
						type : 'post',
						dataType : 'json',
						data : formObj,
						traditional : true,
						cache : false,
						beforeSend : function() {
							btnDisable();
						},
						success : function(res) {
							if (res.code == "1") {
								toastr.success('操作成功');
								$modal.modal('hide');
								// 刷新列表
								dataTable.ajax.reload();
							}
						},
						complete : function() {
							btnEnable();
						}
					});
				}
			});
		};
		var initAttrBox = function(attrs) {
			if (attrs && attrs.length > 0) {
				var attrs = decodeURIComponent(attrs).split(",");
				var attrVals = [];
				for (var i = 0; i < attrs.length; i++) {
					attrVals[i] = {};
					attrVals[i].attr = attrs[i];
				}
				$("#attrContent").html(template.render({
					showAttrs : true,
					attrs : attrVals
				}));
				$("#attrBox").show();
			} else {
				$("#attrContent").html("");
				$("#attrBox").hide();
			}
		};
		bindEvent();
		var attrAdd = function() {
			var attrs = $("#propertys").val();
			var attr = $("#attrInfo").val();
			var newAtts = "";
			if (attr.indexOf(",")>=0) {
				if (attr.indexOf(",,") == 0) {
					attr = attr.substring(2);
				}
				if (attr.indexOf(",") == 0) {
					attr = attr.substring(1);
				}
				if (attr.lastIndexOf(",") == attr.length - 1) {
					attr = attr.substring(0, (attr.length - 1));
				}
				var tmpAttrs = attr.split(",");
				for (var i = 0; i < tmpAttrs.length; i++) {
					if (("," + attrs + ",").indexOf("," + tmpAttrs[i] + ",") >= 0) {
						continue;
					}
					newAtts += "," + tmpAttrs[i];
				}
				if(newAtts.length>0){
					newAtts = newAtts.substring(1);
				}
			}else{
				if (("," + attrs + ",").indexOf("," + attr + ",") >= 0) {
					return;
				}
				newAtts = attr;
			}
			attrs = attrs + "," + newAtts;
			if (attrs.indexOf(",,") == 0) {
				attrs = attrs.substring(2);
			}
			if (attrs.indexOf(",") == 0) {
				attrs = attrs.substring(1);
			}
			if (attrs.lastIndexOf(",") == attrs.length - 1) {
				attrs = attrs.substring(0, (attrs.length - 1));
			}
			$("#propertys").val(attrs);
			initAttrBox(attrs);
		}
		// 禁用按钮
		var btnDisable = function() {
			$('#submitSkuTypes').attr('disabled', 'disabled');
		};

		// 启用按钮
		var btnEnable = function() {
			$('#submitSkuTypes').removeAttr('disabled');
		};
	});
})(window, document, this.jQuery, Hogan, this.RocoUtils);