(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('system-setting', 'rank');

        var template = Hogan.compile($('#hoganTmpl').html());
        var rankDataTable = $("#rankDataTable");
        // 从服务端获得所有排行类型
        var types = null;
        var typeMap= {};
        // 获取所有权限
        $.ajax({
            url: ctx + '/api/rankType/getAll',
            type: 'GET',
            dataType: 'json',
            data:{"status":"OPEN"},
            cache: false,
            success: function(res) {
                if (res.code == 1) {
                	types = res.data;
                	var content = template.render({
                		searchTypes: {
                            data:res.data
                        }
                    });
                	$("#types").html(content);
                	for(var i=0;i<types.length;i++){
                		typeMap[types[i].id+""] = types[i].name;
                	}
                }
            }
        });
        
        // 初始化列表
        var dataTable = $('#rankDataTable').DataTable({
            columns: [
	              {
	            	  data:"id",
	            	  visible:false
	              },
	              {
	              	data: 'index',
	                  title: '',
	                  width: '3%',
	                  defaultContent:"",
	                  orderable: false
	              } ,
                {
                	data: 'display_order',
                    title: '顺序',
                    defaultContent:"",
                    width: '10%',
                    orderable: true,
                    render: function(data, type, full, meta) {
                        return full.displayOrder;
                    }
                }     
                ,{
                    data: 'sku.name',
                    title: '商品名称',
                    defaultContent:"",
                    width: '57%',
                    orderable: false
                }
                , {
                    data: 'type.id',
                    title: '类型',
                    defaultContent:"",
                    width: '25%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	if(full.type){
                            var ret = typeMap[full.type.id+""];
                            return ret==null?"":ret;	
                    	}
                    	return "";
                    }
                }
                , {
                    data: 'id',
                    title: '操作',
                    width: '5%',
                    className:'td_center',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        return template.render({
                            editBtn: {
                                id: full.id,
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/rank',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d),searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            lengthChange:false, // 是否允许显示分页数
            initComplete: function() {
                // 不显示每页多少条 粘贴过来的，没用
                //$('#rankDataTable_length').hide();
            }
        });
        dataTable.on('order.dt search.dt', function () {
        	dataTable.column(1,{search:'applied', order:'applied'}).nodes().each( function (cell, i) {
    			cell.innerHTML = i+1;
    		} );
    	} ).draw();
        // search实现部分
        var searchForm = $('#searchForm'),
        	searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var rankModal = $('#rankModal');
        var searchType = $("#types");
        
        var generateJsBtn = $('#genenerateJsBtn');
        
        // 绑定事件
        var bindEvent = function() {
        	 // 编辑按键点击
        	dataTable.on('click', '[data-handle="rank-delete"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/rank/' + id+"/delete",
                    type: 'DELETE',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            //bindModalEvent(rankModal, res.data);
                            rankModal.modal('hide');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    }
                });
                event.stopPropagation();
            });
        	
        	 // 编辑按键点击
        	searchType.on('click', '[data-handle="rank-types"]', function(event) {
        		$('[data-target="group_btn"]').removeClass('active');
        		$(this).addClass('active');
        		var id = $(this).data('id');
        		$("#searchTypeId").val(id);
        		searchParam = RocoUtils.parseQueryString(searchForm.serialize());
                dataTable.ajax.reload(null, true);
            });
            
            // 创建按键点击
            createBtn.on('click', function(event) {
            	bindModalEvent(rankModal, null);
                event.stopPropagation();
            });
            
            generateJsBtn.on('click',function(event) {
            	$.ajax({
                    url:ctx + "/api/generatejs/setBlockProj",
                    success:function(res) {
                        if(res.code == "1") {
                        	toastr.success(res.message);
                        }
                    }
                });
            	
                $.ajax({
                    url:ctx + "/api/generatejs/list/hotExchange",
                    success:function(res) {
                    }
                });
            });

        };
        var proList = null;
        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data) {
            $modal.html(template.render({
                modal: true,
                rank:(data==undefined?{}:data),
                "types":types,
                isOpen:function(){
                	return this.status === 'OPEN';
                }
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            var $form = $modal.find('form');
            $modal.find('.slide-content').slideContent({
                invisibleClass: 'slide-page-invisible',
                slideToSelector:'[data-slidehandler="slide_to"]',
                slideBackSelector:'[data-slidehandler="slide_back"]',
                slideConfirmSelector:'[data-slidehandler="slide_confirm"]',
                beforeSlideTo:function($page){console.log(arguments,'beforeSlideTo');},
                afterSlideTo:function($page){
                    console.log(arguments,'afterSlideTo');
                    $page.chooseProduct(false, proList, false, function(idList,objList){
                    	proList = objList;
                        $(objList).each(function(idx, item) {
                        	$("#skuId").val(item.code);
                        	$("#skuName").val(item.name);
                        });
                    });
                },
                beforeSlideBack:function($page){console.log(arguments,'beforeSlideBack'); return true;},
                afterSlideBack:function($page){console.log(arguments,'afterSlideBack');},
                beforeSlideConfirm:function($page){console.log(arguments,'beforeSlideConfirm');
                return true;},
                afterSlideConfirm:function($page){console.log(arguments,'afterSlideConfirm');}
            });
            // 表单验证
            $form.validate({
                rules: {
                	displayOrder: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                        digits:true
                    },
                    skuId: {
		                required: true,
		                maxlength: 20,
		                minlength: 6,
                        digits:true
		            }
                },
                submitHandler: function(form) {
                    var formObj = {};
                    var formList = decodeURI($(form).serialize()).split('&');
                    $(formList).each(function(idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });

                    $.ajax({
                        url: ctx + '/api/rank/save',
                        type: 'post',
                        dataType: 'json',
                        data: formObj,
                        traditional: true,
                        cache: false,
                        beforeSend: function() {
                            btnDisable();
                        },
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function() {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function() {
            $('#deleteRank').attr('disabled', 'disabled');
            $('#submitRank').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#deleteRank').removeAttr('disabled');
            $('#submitRank').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);