(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('data-dict', 'rankType');

        var template = Hogan.compile($('#hoganTmpl').html());
        var rankTypeDataTable = $("#rankTypeDataTable");

        // 初始化列表
        var dataTable = $('#rankTypeDataTable').DataTable({
            columns: [
                {
                    data: "id",
                    visible: false
                }, {
                    data: 'index',
                    title: '',
                    defaultContent: '',
                    className: 'td_center',
                    orderable: false,
                    width: '3%'
                }, {
                    data: 'code',
	                title: '编号',
	                orderable: false,
	                width: '8%'
	            },{
                    data: 'name',
                    title: '名称',
                    width: '25%',
                    orderable: true
                }, {
                    data: 'status',
                    title: '状态',
                    width: '15%',
                    orderable: true,
                    render: function (data, type, full, meta) {
                        return 'OPEN' == data ? '启用' : '锁定';
                    }
                }, {
                    data: 'id',
                    title: '操作',
                    width: '30%',
                    className: 'td_center',
                    orderable: false,
                    render: function (data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                            editBtn: {
                                id: full.id,
                                content: function () {
                                    return full.status == 'OPEN' ? '锁定' : '开启';
                                },
                                status:  full.status,
                                isOpenBtn: full.status == 'LOCK'
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/rankType',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            lengthChange: false, // 是否允许显示分页数
            order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条 粘贴过来的，没用
                //$('#rankTypeDataTable_length').hide();
            }
        });
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();
        // search实现部分
        var searchForm = $('#searchForm'),
            searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var rankTypeModal = $('#rankTypeModal');


        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="rankType-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/rankType/' + id,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(rankTypeModal, res.data);
                        }
                    }
                });
                event.stopPropagation();
            });

            // 锁定开启 按键点击
            rankTypeDataTable.on('click', '[data-handle="rankType-operation"]', function (event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                status = status == 'OPEN' ? 'LOCK' : 'OPEN';
                $.ajax({
                    url: ctx + '/api/rankType/' + id + '/switch',
                    type: 'get',
                    dataType: 'json',
                    data: {
                        status: status
                    },
                    cache: false,
                    beforeSend: function () {
                        btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            //roleModal.modal('hide');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function (event) {
                // 重置模式窗体内html
                $.ajax({
                    url: ctx + '/api/rankType/0',
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    beforeSend: function () {
                        btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(rankTypeModal, res.data);
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data) {
            $modal.html(template.render({
                modal: true,
                rankType: (data == undefined ? {} : data)
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                    name: {
                        required: true,
                        maxlength: 20
                    }
                },
                submitHandler: function (form) {
                    var formObj = {};
                    var formList = decodeURI($(form).serialize()).split('&');
                    $(formList).each(function (idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });

                    $.ajax({
                        url: form.id.value != "0" ? (ctx + '/api/rankType/update') : (ctx + '/api/rankType/create'),
                        type: 'post',
                        dataType: 'json',
                        data: formObj,
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            $('#deleteRankType').attr('disabled', 'disabled');
            $('#submitRankType').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#deleteRankType').removeAttr('disabled');
            $('#submitRankType').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);