(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('system-manage', 'roles');

        var template = Hogan.compile($('#hoganTmpl').html());


        // 从服务端获得所有权限
        var allPermission = null;
        // 获取所有权限
        $.ajax({
            url: ctx + '/api/role/getAllPermission',
            type: 'GET',
            dataType: 'json',
            cache: false,
            success: function(res) {
                if (res.code == 1) {
                    allPermission = res.data;
                }
            }
        });

        var roleDataTable = $('#roleDataTable');

        // 初始化列表
        dataTable = roleDataTable.DataTable({
            columns: [
                {
                    data: 'index',
                    title: '',
                    defaultContent:'',
                    className:'td_center',
                    orderable: false,
                    width: '3%'
                },
                {
                    data: 'name',
                    title: '名称',
                    width: '15%'
                }, {
                    data: 'description',
                    title: '描述',
                    width: '60%',
                    orderable: true
                }
                // ,{
                //     data: 'permissions',
                //     title: '权限',
                //     width: '60%',
                //     orderable:false,
                //     render: function(data, type, full, meta) {
                //         var html = '';
                //         for (var i = 0, len = data.length; i < len; i++) {
                //             html += data[i] + '&nbsp;&nbsp;&nbsp;&nbsp;';
                //         }
                //         return html;
                //     }
                // }
                , {
                    data: 'id',
                    title: '操作',
                    width: '20%',
                    className:'td_center',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                            editBtn: {
                                id: data
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/role',
                type: 'GET',
                data: function(d) {
                    return RocoUtils.buildParam(d);
                }
            },
            paging: false,
            ordering: true,
            info: true,
            searching: false,
            order: [1, 'desc'],
            initComplete: function() {}
        });

        dataTable.on('order.dt search.dt', function() {
            dataTable.column(0, {
                search: 'applied',
                order: 'applied'
            }).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var roleModal = $('#roleModal');


        // 绑定事件
        var bindEvent = function() {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="role-edit"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/role/' + id + '/edit',
                    type: 'get',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(roleModal, res.data.role, res.data.allPermissions);
                        }
                    }
                });
                event.stopPropagation();
            });

            // 删除按键点击
            roleModal.on('click', '[data-handle="role-delete"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/role/' + id + '/delete',
                    type: 'get',
                    dataType: 'json',
                    cache: false,
                    beforeSend: function() {
                        btnDisable();
                    },
                    success: function(res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            roleModal.modal('hide');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    },
                    complete: function() {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });



            // 创建按键点击
            createBtn.on('click', function(event) {
                bindModalEvent(roleModal, null);
                event.stopPropagation();
            });

            roleDataTable.on('click', '[data-handle="list-del"]', function(e) {
                var self = $(this);
                roleModal.confirmModal({
                    obj:self.data('id'),
                    message:'确认删除该角色吗？',
                    ok:function(obj) {
                        $.ajax({
                            url: ctx + '/api/role/' + obj + '/delete',
                            type: 'get',
                            dataType: 'json',
                            cache: false,
                            beforeSend: function() {
                                btnDisable();
                            },
                            success: function(res) {
                                if (res.code == 1) {
                                    toastr.success('操作成功');
                                    // 刷新列表
                                    dataTable.ajax.reload();
                                }
                            },
                            complete: function() {
                                btnEnable();
                            }
                        });
                    }
                });
                e.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, role, rolePermissions) {

            // 选择的权限
            var selectedPermissions = {};

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                permissions: rolePermissions || allPermission,
                getPermissionName: function() {
                    return this.value[0].label;
                },
                pushPermission: function() {
                    selectedPermissions[this.name] = this.permission;
                },
                role: role
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green'
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');
            // 全选
            $form.on('ifChecked', '#selAllCb', function(event) {
                $form.find('[data-checkbox="sub"]').iCheck('check');
                event.stopPropagation();
            });

            // 全不选
            $form.on('ifUnchecked', '#selAllCb', function(event) {
                $form.find('[data-checkbox="sub"]').iCheck('uncheck');
                event.stopPropagation();
            });


            // 选择权限 放入权限对象中
            $form.on('ifChecked', '[data-checkbox="sub"]', function(event) {
                var dataSet = $(this).data();
                selectedPermissions[dataSet.rolename] = dataSet.rolevalue;
            });

            // 放弃权限 从权限对象删除
            $form.on('ifUnchecked', '[data-checkbox="sub"]', function(event) {
                var dataSet = $(this).data();
                selectedPermissions[dataSet.rolename] = null;
            });

            // 表单验证
            $form.validate({
                rules: {
                    name: {
                        required: true,
                        maxlength: 20
                    },
                    description: {
                        required: false,
                        maxlength: 25
                    }
                },
                submitHandler: function(form) {
                    var permissions = [];
                    for (var key in selectedPermissions) {
                        if (selectedPermissions[key]) {
                            permissions.push(selectedPermissions[key]);
                        }
                    }
                    if (permissions.length == 0) {
                        toastr.warning('请至少选择一项权限');
                        return false;
                    }

                    $.ajax({
                        url: role ? (ctx + '/api/role/' + role.id + '/update') : (ctx + '/api/role/create'),
                        type: 'post',
                        dataType: 'json',
                        data: {
                            id: $.trim(form.id.value),
                            name: $.trim(form.name.value),
                            description: $.trim(form.description.value),
                            permissions: permissions
                        },
                        traditional: true,
                        cache: false,
                        beforeSend: function() {
                            btnDisable();
                        },
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function() {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function() {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);