(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('system-setting', 'signin');

        var template = Hogan.compile($('#hoganTmpl').html());
        var signRecordDataTable = $("#signRecordDataTable");
        
        //积分规则 下拉框数据
        var centRuleDropList = null;

        // 初始化列表
        var dataTable = signRecordDataTable.DataTable({
            columns: [{
            	data: 'id', 
            	visible:false,
            	defaultContent:''
            },{
            	data: 'index',
            	title: '',
            	defaultContent:'',
            	orderable: false,
            	width: '3%'
			},{
                data: 'user.username',
                title: '会员名',
                width: '10%'
            }, {
                data: 'user.name',
                title: '会员姓名',
                width: '24%',
                orderable: false
            }, {
                data: 'continueSignDay',
                title: '连续签到天数',
                width: '6%',
                orderable: false,
                render: function (data) {
                	return "第" + data +"天";
                }
            },{
                data: 'earnCent',
	            title: '奖励积分',
	            width: '7%',
	            orderable: false
	        }, {
                data: 'signDateTime',
                title: '签到时间',
                width: '12%',
                render: function (data) {
                	return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm')
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/signRecord',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#signRecordDataTable_length').hide();
            }
        });
        
         //显示dataTable行号
         dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        var searchParam = null;
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });
        
        //设置签到规则btn
        var editSignRuleBtn = $('#editSignRule');
        // 模式窗体
        var popupWindow = $('#popupWin');

        // 绑定事件
        var bindEvent = function () {
         
            var editSignRuleAPI = ctx +"/api/signRule";
            // "设置签到规则" 点击
            editSignRuleBtn.on('click', function (event) {
            	$.get(editSignRuleAPI,function(data){
            		popup(data);
            	});
            });
        };
        
        
        function renderTrHTML(row,itemIdx,checkedRule){
            var selectedOptCent = 0;
        	var optList = "";
    		$.each(centRuleDropList,function(idx,centRule){
    			var selected = "";
    			if(checkedRule && checkedRule.id == centRule.id) {
    				selected = " selected ";
    				selectedOptCent = centRule.cent;
    			}
				var option = "<option value='"+centRule.id+"'"+selected+"  data-cent='"+centRule.cent+"'>"+centRule.name+"</option>";
				optList +=option;
			});
        
        	var initCentData = null;
        	if(checkedRule) {
        		initCentData = {showInitCent:true,cent:selectedOptCent};
        	}else {
        		initCentData = {showInitCent:false,cent:0};
        	}
        	
        
        	var trTemp = template.render({ruleTr: true, row:row,itemIdx:itemIdx,initCentData:initCentData});
			optList +="</select>";
			trTemp = trTemp.replace("</select>",optList);
			return trTemp;
        }
	
        /**
         * 弹出签名规则设置窗口
         * @param signRuleCfg 编辑签到规则 对象
         */
        var popup = function (signRuleCfg) {
        	var editRuleHtml = template.render({editSignRule: true, rule: signRuleCfg });
        	
        	if(signRuleCfg) {
        		
        		var trHTMLRows = "";
        		$.each(signRuleCfg.cfgItemList,function(idx,item){
        			var row = item.day;
        			var itemIdx = row-1;
        			var trHTML = renderTrHTML(row,itemIdx,item.rule);
        			trHTMLRows+=trHTML;
        		});
        		
        		trHTMLRows += " </tbody>";
        		editRuleHtml = editRuleHtml.replace("</tbody>",trHTMLRows);
        	}
        	
        	popupWindow.html(editRuleHtml);
            // 展示模式窗体
            popupWindow.modal({
                keyboard: true
            });
   
             //生成列表
            popupWindow.on('click','[id=generateListBtn]',function(event){
            	var day = parseInt($("input[name='dayCycle']").val());
            	var tbody = $("#tableListBody");
            	tbody.empty();
            	for(var i=1; i<=day; i++){
            		var trHtml = renderTrHTML(i,i-1);
        			tbody.append(trHtml);
            	}
            });	
            
            //select下拉框 选中事件
            popupWindow.on("change","select",function(event){
            	var span = $(this).parents("tr").find("span");
            	var cent = $(this).find("option:selected").data("cent");
            	if(cent>0){
            		span.text("送"+cent+"分");
            	}else {
            		span.text("");
            	}
            });
            

            var $form = popupWindow.find('form');

            // 表单验证
            $form.validate({
                submitHandler: function (form) {
                    $.ajax({
                        url:  ctx + "/api/signRule",
                        type: 'POST',
                        dataType: 'json',
                        data: $(form).serialize(),
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                popupWindow.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        }
                    });
                }
            });
        };
        

        
         function initDatepicker(){
                var initDateControl = function (start, end) {
		            var startDate = {
		                elem: start,
		                format: 'YYYY-MM-DD',//时间格式
		                min: '1900-01-01', //设定最小日期
		                max: '2099-06-16', //最大日期
		                isclear: true, //是否显示清空按钮
		                istime: false,//是否显示时间
		                istoday: true,
		                festival: true,
		                choose: function (datas) {
		                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
		                    endDate.start = datas //将结束日的初始值设定为开始日
		                }
		            };
	
		            var endDate = {
		                elem: end,
		                format: 'YYYY-MM-DD',
		                min: '1900-01-01',
		                max: '2099-06-16',
		                isclear: true,
		                istime: false,
		                istoday: true,
		                festival: true,
		                choose: function (datas) {
		                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
		                }
		            };
	               laydate(startDate);
	               laydate(endDate);
	            };
                
	         var startDateId = "#startDate";
	         var endDateId = "#endDate";
	         
	         setTimeout(initDateControl(startDateId,endDateId), 1);
         }
         
        
        /**
         * 初始化 积分规则 下拉框字典
         */
        function initCentRuleDropListData(){
        	var centRuleAPI = ctx +"/api/centrule/getAll";
        	$.get(centRuleAPI,{status:"OPEN", effective:true},function(resp){
        		if(resp.code == 1){
        			centRuleDropList = resp.data;
        		}
        	});
        }
         
        function init(){
        	initDatepicker();
        	initCentRuleDropListData();
        }
         
        init();
        bindEvent();
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);