 (function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'sku');

        var template = Hogan.compile($('#hoganTmpl').html());
        var skuDataTable = $("#skuDataTable");
        var suppliers, warehouses;
        // 初始化搜索栏中的供应商
        var init = function () {
            $.ajax({
                url: ctx + '/api/supplier',
                type: 'GET',
                dataType: 'json',
                asyn: false,
                success: function (res, status) {
                    suppliers = res.data;
                    $(suppliers).each(function () {
                        if (this.useable == true)
                            $("#sku_supplier").append("<option value='" + this.id + "'>" + this.name + "</option>");
                    });
                }
            });
            $.ajax({
                url: ctx + '/api/warehouse/all',
                type: 'GET',
                dataType: 'json',
                asyn: false,
                success: function (res, status) {
                    warehouses = res.data;
                }
            });

        }

        init()

        // 初始化列表
        var dataTable = $('#skuDataTable').DataTable({

            // 预设一些列的属性
            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0, 1, 2, 3, 4, 5, 6, 7, 8]
            }, {
                orderable: false,
                targets: '_all'
            }],

            columns: [{
                data: 'id'
            }, {
                data: '(stock+virtual_stock-occupied_stock)'
            }, {
                data: 'stock'
            }, {
                data: 'virtual_stock'
            }, {
                data: 'occupied_stock'
            }, {
                data: 'warning_stock'
            }, {
                data: '(stock+virtual_stock-occupied_stock-warning_stock)'
            }, {
                data: 'wh.code'
            }, {
                data: 'wh.name'
            }, {
                className: 'td_center',
                width: '3%'
            }, {
                data: 'wareHouse.name',
                title: '仓库名称',
                width: '8%',
                orderData: [8]
            }, {
                data: 'code',
                title: 'SKU编码',
                width: '7%',
                render: function (data, type, full, meta) {
                    return "<div data-toggle='popover' data-flag=false data-skuid='" + full.id + "' >" + data + "</div>"
                }
            }, {
                data: 'name',
                title: 'SKU名称',
                width: '24%'
            }, {
                data: 'availableStockQuantity',
                title: '可售库',
                width: '6%',
                orderable: false
            }, {
                data: 'stock',
                title: '真实库',
                width: '6%',
                orderable: false
            }, {
                data: 'virtualStock',
                title: '虚拟库',
                width: '6%',
                orderable: false
            }, {
                data: 'occupiedStock',
                title: '占有库',
                width: '6%',
                orderable: false
            }, {
                data: 'warningStock',
                title: '预警库',
                width: '6%',
                orderable: false
            }, {
                data: 'stockStatus',
                title: '状态',
                width: '7%',
                render: function (data, type, full, meta) {
                    return data == 'NORMAL' ? "<div style='text-align: center;color:#ffffff;background-color: #000000'>正常</div>" : "<div style='text-align: center;color:#ffffff;background-color: #FF0000'>预警</div>";
                },
                orderData: [6]
            }, {
                data: 'id',
                title: '操作',
                width: '31%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        editBtn: {
                            id: data
                        }
                    });
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/sku',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            lengthChange: false
        });

        // 首列显示序号,并且监听搜索排序事件,重新渲染序号
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(9, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 模式窗体
        var skuModal = $('#skuModal');
        // 模式窗体
        var inModal = $('#inModal');
        // 退货窗体
        var backModal = $("#backModel");

        var isIn = false, isVirtual = false;
        // 绑定事件
        var bindEvent = function () {
            // 设置预警数量按钮点击事件
            dataTable.on('click', '[data-handle="warningsku-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/sku/' + id,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            isIn = false;
                            isVirtual = false;
                            bindModalEvent(skuModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });
            // 设置预警数量按钮点击事件
            dataTable.on('click', '[data-handle="warningsku-in"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/sku/' + id,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            isIn = true;
                            isVirtual = false;
                            bindModalEvent(inModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });
            // 设置虚拟数量按钮点击事件
            dataTable.on('click', '[data-handle="warningsku-virtual"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/sku/' + id,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            isIn = false;
                            isVirtual = true;
                            bindModalEvent(skuModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });
            $("#backBtn").on("click", function (event) {
                var modalInfo = {
                    backlist: true
                };
                backModal.html(template.render(modalInfo));
                // 展示模式窗体
                backModal.modal({
                    keyboard: true
                });
                initBackDataTable();
            });

            /* 跑不通
            dataTable.on('mouseover', '[data-toggle="popover"]', function () {
                var id = $(this).data('skuid');
                var _this = $(this);
                if (_this.data('flag')) {
                    return false;
                }
                $.ajax({
                    url: ctx + '/api/sku/' + id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                            var data = res.data;
                            _this.data('flag', true);
                            var mess = {
                                "商品编码": data.code,
                                "商品名称": data.name,
                                "供应商": data.product.supplier.name,
                                "商品分类": data.product.catalogs[0].name,
                                "商品库存": data.stock + data.virtualStock - data.occupiedStock,
                                "商品状态信息": data.status == 'ENABLED' ? "启用" : "停用"

                            }
                            var content = jsonToString(mess);
                            _this.popover({
                                trigger: 'hover',
                                title: '商品信息',
                                content: content,
                                placement: 'top',
                                html: true
                            })
                        };
                    }
                });
            });

            dataTable.on('mouseout', '[data-toggle="popover"]', function () {
                $(this).popover("hide");
            })
            */
        };
        // 加载 退货确认收货列表
        var backDataTable = null;
        var initBackDataTable = function () {
            backDataTable = $("#backDataTable").DataTable({
                //预设一些列的属性
                columns: [{
                    data: "id",
                    visible: false
                }, {
                    data: 'index',
                    title: '序号',
                    width: '5%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'code',
                    title: '入库单号',
                    width: '11%',
                    defaultContent: "",
                    orderable: false
                }, {
                    data: 'sku.name',
                    title: '商品名称',
                    width: '30%',
                    orderable: false
                }, {
                    data: 'warehouse.name',
                    title: '仓库名称',
                    defaultContent: "",
                    width: '10%',
                    orderable: false
                }, {
                    data: 'quantity',
                    title: '入库量',
                    width: '8%',
                    orderable: false
                }, {
                    data: 'operator.username',
                    title: '入库人',
                    width: '10%',
                    orderable: false
                }, {
                    data: 'createTime',
                    title: '入库时间',
                    width: '15%',
                    orderable: false,
                    render: function (data, type, full) {
                        return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm')
                    }
                }, {
                    data: 'id',
                    title: '操作',
                    width: '10%',
                    className: 'td_center',
                    orderable: false,
                    render: function (data) {
                        return template.render({
                            backEditBtn: {
                                id: data
                            }
                        });
                    }
                }]
                , processing: true,
                serverSide: true,
                ajax: {
                    url: ctx + '/api/instoreOrder',
                    type: 'GET',
                    data: {
                        "instoreType": 'REFUND',
                        "receiveState": 'UNFINISHED'
                    }
                },
                paging: true,
                ordering: true,
                info: true,
                searching: false,
                // 每页20条
                pageLength: 15,
                lengthMenu: [15],
                order: [0, 'desc'],
                lengthChange: false
            });
            $("#backModalDialog div.row").eq(0).css("display", "none");
            $("#backModalDialog div#backDataTable_wrapper").css("padding-bottom", "0px");

            backDataTable.on('order.dt search.dt', function () {
                backDataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
            }).draw();
            backDataTable.on("click", '[data-handle="sku-back"]', function (event) {
                if (window.confirm("是否确认收货")) {
                    var confirmBtn = $(this);
                    var id = confirmBtn.data('id');
                    var confirmReceiveUrl = ctx + '/api/instoreOrder/' + id + '/finish';
                    $.get(confirmReceiveUrl, function (res) {
                        if (res.code == 1) {
                            confirmBtn.parent().parent().remove();
                            toastr.success('确认收货成功');
                        }
                    });
                }
                event.stopPropagation();
            });
        }

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, rolePermissions) {
            var modalInfo = {};
            var action = "";
            if (isIn) {
                action = ctx + "/api/instoreOrder/purchase";
                modalInfo["isIn"] = true;
                modalInfo["warehouses"] = warehouses;
            } else {
                modalInfo["modal"] = true;
                modalInfo["isVirtual"] = isVirtual;
                action = ctx + "/api/sku/update";
            }
            modalInfo["sku"] = data || {};
            // 重置模式窗体内html
            $modal.html(template.render(modalInfo));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                    warningStock: {
                        required: true,
                        digits: true
                    }
                },
                submitHandler: function (form) {
                    console.info(form);
                    console.info($(form).serialize());

                    $.ajax({
                        url: action,
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize(),
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == 1) {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        var jsonToString = function (json) {
            if (!json || json.length == 0)
                return ""
            var str = "";
            $.each(json, function (i) {
                str += i + " : " + json[i] + "</br>"
            });
            return str;
        }

        // 禁用按钮
        var btnDisable = function () {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);