(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('operation', 'splitorder');

        var template = Hogan.compile($('#hoganTmpl').html());
        var orderDataTable = $("#orderDataTable");
        // search实现部分
        var searchForm = $('#searchForm');


        // 初始化列表
        var dataTable = $('#orderDataTable').DataTable({
            columns: [{
	            	data: 'index',
	            	title: '',
	            	defaultContent:'',
	            	className:'td_center',
	            	orderable: false,
	            	width: '3%'
				},{
					data : 'id',
					visible: false
				},{
                    data: 'code',
                    title: '配送单号',
                    orderable: false,
                    width: '8%'
                },{
                    data: 'orderItem.orderCode',
                    title: '子订单号',
                    orderable: false,
                    width: '8%',
                    render: function(data, type, full, meta) {
                    	return "<a href='javascript:void(0);' data-handle='order' data-id='"+full.orderItem.order.id+"'>"+data+"</a>";
                    }
                }, {
                    data: 'orderItem.productName',
                    title: '商品名称',
                    width: '20%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	var prodName = substring(data,15);
                    	return "<div data-toggle='popover' data-flag=false data-skuid='"+full.orderItem.sku.id+"' >"+prodName+"</div>";
                    }
                }, {
                    data: 'orderItem.wareHouse.name',
                    title: '仓库名称',
                    width: '8%',
                    orderable: false
                }, {
                    data: 'express.name',
                    title: '快递公司',
                    width: '8%',
                    orderable: false
                }, {
                    data: 'orderItem.order.delivery.recipient',
                    title: '收货人',
                    orderable: false,
                    width: '8%'
                }, {
                    data: 'orderItem.orderCode',
                    title: '收货人地址',
                    width: '25%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        var address = "";
                        address += full.orderItem.order.delivery.province+" ";
                        address += full.orderItem.order.delivery.city+" ";
                        address += full.orderItem.order.delivery.county+" ";
                        address += full.orderItem.order.delivery.addrDetail;
                        return substring(address,25);
                    }
                }, {
                    data: 'mergeCode',
                    title: '操作',
                    width: '10%',
                    orderable: false,
                    render: function(data, type, full, meta) {
                    	return template.render({
                            button: {
                                id: data
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/distributeOrder',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), RocoUtils.parseQueryString(searchForm.serialize()));
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#orderDataTable_length').hide();
            }
        });
        
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

       
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 模式窗体
        var orderModal = $('#orderModal');

     // 订单详细信息窗体
        var bindModalInfoEvent = function($modal, data) {
        	tempIndex = 1;
            // 重置模式窗体内html
            $modal.html(template.render({
            	OrderInfo: true,
                data : data ,
                index: function(){
                	return tempIndex++;
                }
            }));
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
        };

        // 绑定事件
        var bindEvent = function() {
        	
        	dataTable.on('click','[data-handle="order"]',function(event){
        		var id = $(this).data('id');
        		$.ajax({
                    url: ctx + '/api/order/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    success: function(res) {
                        if (res.code == 1) {
                        	bindModalInfoEvent(orderModal,res.data);
                        }
                    }
                });
        		event.stopPropagation();
        	})
        	
        	dataTable.on('mouseover','[data-toggle="popover"]',function(){
            	var id = $(this).data('skuid');
            	var _this = $(this);
            	if(_this.data('flag')) {
            		return false;
            	}
            	$.ajax({
                    url: ctx + '/api/sku/'+id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                        	_this.data('flag', true);
                        	var data = res.data;
                        	var mess = {
                        		"商品编码":data.code,
                        		"商品名称":data.name,
                        		"供应商":data.product.supplier.name,
                        		"商品分类":data.product.catalogs[0].name,
                        		"商品库存":data.stock+data.virtualStock-data.occupiedStock,
                        		"商品状态信息": data.status == 'ENABLED' ? "启用" : "停用"
                        			
                        	}
                        	var content = jsonToString(mess);
                        	_this.popover({trigger:'hover',title:'商品信息',content:content,placement:'top',html:true})
                        };
                    }
                });
            })
            
            dataTable.on('mouseout','[data-toggle="popover"]',function(){
            	$(this).popover("hide");
            })
        	
        	// 拆单按键点击
            dataTable.on('click', '[data-handle="split-order"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/distributeOrder/splitUI/' + id ,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(orderModal, res.data, null);
                        }
                    }
                });
                bindModalEvent(orderModal,null);
                event.stopPropagation();
            });
        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal,data) {
        	// 重置模式窗体内html
            $modal.html(template.render({
            	modal : true,
            	data : data,
            	splitData : function(){
            		return data ? data[0] : '';
            	},
            	delivery : function() {
            		return data ? data[0].orderItem.order.delivery : '';
            	},
            	ids : function(){
            		var value = "";
            		if(data){
            			$(data).each(function(index,_this){
            				value += this.id;
            				if(index != data.length-1)
            					value += ","
            			})
            		}
            		return value;
            	}
            }));
            
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            //拆单
            $("#splitOrder").on('click', function (event) {
            	var ids = $("#ids").val();
            	$.ajax({
                    url: ctx + '/api/distributeOrder/split',
                    type: 'GET',
                    data: {
                    	distriOrderIdList : ids
                    },
                    dataType: 'json',
                    success: function(res) {
                        if (res.code == "1") {
                        	$modal.modal('hide');
                        	search();
                        }
                    }
                });
            });
        };
        
        // 加载搜索时间空间,只输入一个参数表示加载输入参数的时间空间,输入两个参数表示加载开始日期和结束日期的时间空间 参数为JQuery选择器的值 如 '#startDate'
        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,
                format: 'YYYY-MM-DD',//时间格式
                min: '1900-01-01', //设定最小日期
                max: '2099-06-16', //最大日期
                isclear: true, //是否显示清空按钮
                istime: false,//是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
                    endDate.start = datas //将结束日的初始值设定为开始日
                }
            };

            var endDate = {
                elem: end,
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
                }
            };

            laydate(startDate);
            laydate(endDate);
        }

        var init = function(){
        	setTimeout(initDateControl("#startDate","#endDate"), 1);
        	bindEvent();
        	$.ajax({
                url: ctx + '/api/express/all',
                type: 'get',
                dataType: 'json',
                success: function(res) {
                    if (res.code == "1") {
                      var express =  $("#express");
                      $(res.data).each(function(){
                    	  express.append("<option value="+this.id+">"+this.name+"</option>");
                      })
                    }
                }
            });
        }
        init();
        
        //查询
        var search = function(){
        	searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        }
        
        var jsonToString = function(json){
        	if(!json || json.length == 0)
        		return ""
        	var str = "";
        	$.each(json, function(i) {
        		str += i+" : "+json[i]+"</br>"
        	});
        	return str;
        }
        
        var substring = function(str,index){
        	if(str.length > index){
        		return str.substring(0, index)+"...";
        	}
        	return str;
        }
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);