(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'suppliers');

        var template = Hogan.compile($('#hoganTmpl').html());
        var suppliersDataTable = $("#suppliersDataTable");


        // 初始化列表
        var dataTable = $('#suppliersDataTable').DataTable({

            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }, {
                orderable: false,
                targets: '_all'
            }],

            columns: [{
                data: 'id'
            }, {
                data: 'index',
                title: '',
                className: 'td_center',
                width: '3%'
            }, {
                data: 'code',
                title: '编码',
                width: '15%'
            }, {
                data: 'name',
                title: '中文名称',
                width: '15%'
            }, {
                data: 'shortName',
                title: '简称',
                width: '15%'
            }, {
                data: 'displayOrder',
                title: '排序值',
                width: '15%'
            }, {
                data: 'useable',
                title: '状态',
                width: '15%',
                render: function (data) {
                    return true == data ? '合作' : '终止';
                },
                orderable: true
            }, {
                data: 'id',
                title: '操作',
                width: '10%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        editBtn: {
                            id: data,
                            content: function () {
                                return full.useable == false ? '合作' : '终止';
                            },
                            useable: !full.useable
                        }
                    });
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/supplier',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            lengthChange: false // 是否允许显示分页数
        });

        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var suppliersModal = $('#suppliersModal');


        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="role-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/supplier/' + id + '/getInfo',
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(suppliersModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });

            // 使用终止
            suppliersDataTable.on('click', '[data-handle="role-operation"]', function (event) {

                var id = $(this).data('id');
                var useable = $(this).data('useable');

                $.ajax({
                    url: ctx + '/api/supplier/update',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        useable: useable
                    },
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function (event) {
                bindModalEvent(suppliersModal, null, null);
                event.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, rolePermissions) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                suppliers: data || {}
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');

            if ($("#suppliersid").val()) {
                $("#suppliersCode").attr("disabled", "disabled")
            }

            // 表单验证
            $form.validate({
                rules: {
                    code: {
                        required: true,
                        maxlength: 20
                    },
                    name: {
                        required: true,
                        maxlength: 50
                    },
                    displayOrder: {
                        required: true,
                        maxlength: 20
                    },
                    shortName: {
                        required: true,
                        maxlength: 25
                    }
                },
                submitHandler: function (form) {

                    var formObj = {};
                    var formList = decodeURI($(form).serialize()).split('&');
                    $(formList).each(function (idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });

                    /*if(!form.id.value){
                     formObj['useable'] = true;
                     }*/

                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/supplier/update') : (ctx + '/api/supplier/create'),
                        type: 'post',
                        dataType: 'json',
                        data: formObj,
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#submitRole').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);