$(function() {

    // 局部支持拖拽上传需添加此代码
    $(document).bind('drop dragover', function(e) {
        e.preventDefault();
    });

    // ajax 配置
    var ajaxOptions = {
        url: '/api/upload/image',
        type: 'POST',
        dataType: 'json',
        // 表单参数
        formData: {
            // 指定上传类型
            imageType: 'PRODUCT'
        }
    };

    // 文件配置
    var fileOptions = {
        multiple: false, //禁用多文件上传
        dropZone: '#rocoDndArea', //支持拖拽上传
        limitMultiFileUploadSize: 2048000, //单个文件最大上传容量，单位为byte
        limitMultiFileNumber: 5,
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i, //允许上传文件类型
        sequentialUploads: true,
        autoUpload: true, //不自动上传
    };
    // 事件配置
    var eventOptions = {
        // 添加事件
        add: function(e, data) {
            console.log(data.files[0]);
            if (uploader.uploadManage('check', data)) {
                // 有错误返回
                return false;
            } else {
                // 没错误提交
                uploader.uploadManage('add', data);
                // 自动上传
                fileOptions.autoUpload && data.submit();
            }
        },
        // 拖拽完成
        drop: function(e, data) {
            return !uploader.uploadManage('numberCheck', false, data);
        },
        // 提交开始
        submit: function(e, data) {
            window.console && console.log('submit');
        },
        // 传送开始
        send: function(e, data) {
            window.console && console.log('send');
        },
        start: function(e) {
            window.console && console.log('Uploads started');
        },
        stop: function(e) {
            window.console && console.log('Uploads finished');
        },
        change: function(e, data) {
            $.each(data.files, function(index, file) {
                window.console && console.log('Selected file: ' + file.name);
            });
        },
        // 上传完成
        done: function(e, data) {
            window.console && console.log('done');
            if (data.result.code == 1) {
                uploader.uploadManage('done', data);
            }else if(data.result.code == 0){
                uploader.uploadManage('retry',data);
            }
        },
        // 上传进度
        progress: function(e, data) {
            uploader.uploadManage('progress', data);
        },
        progressall: function(e, data) {
            window.console && console.log('progressall');
        },
        // 上传失败
        fail: function(e, data) {
            window.console && console.log('failed');
            uploader.uploadManage('retry',data);
        },
        always: function(e, data) {

        }
    };
    // 混合几个option
    var options = $.extend({}, ajaxOptions, fileOptions, eventOptions);
    // 开启上传空间
    $('#rocoFileUpload').fileupload(options);
    // 开启上传代理
    uploader = $('#uploader').uploadManage({
        limitMultiFileUploadSize: fileOptions.limitMultiFileUploadSize,
        limitMultiFileNumber: fileOptions.limitMultiFileNumber,
        acceptFileTypes: fileOptions.acceptFileTypes,
        autoUpload: fileOptions.autoUpload,
        view: '#rocoDndArea', //拖拽区域
        fileList: '#rocoFileList', //文件列表
        statusBar: '#rocoStatusBar', //全局状态条
        queueList: '#rocoQueueList', //总体范围
    });
});


$(function() {

    // 局部支持拖拽上传需添加此代码
    $(document).bind('drop dragover', function(e) {
        e.preventDefault();
    });

    // ajax 配置
    var ajaxOptions = {
        url: '/api/upload/image',
        type: 'POST',
        dataType: 'json',
        // 表单参数
        formData: {
            // 指定上传类型
            imageType: 'PRODUCT'
        }
    };

    // 文件配置
    var fileOptions = {
        multiple: false, //禁用多文件上传
        dropZone: '#rocoDndArea2', //支持拖拽上传
        limitMultiFileUploadSize: 2048000, //单个文件最大上传容量，单位为byte
        limitMultiFileNumber: 5,
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i, //允许上传文件类型
        sequentialUploads: true,
        autoUpload: true, //不自动上传
    };
    // 事件配置
    var eventOptions = {
        // 添加事件
        add: function(e, data) {
            if (uploader2.uploadManage('check', data)) {
                // 有错误返回
                return false;
            } else {
                // 没错误提交
                uploader2.uploadManage('add', data);
                // 自动上传
                fileOptions.autoUpload && data.submit();
            }
        },
        // 拖拽完成
        drop: function(e, data) {
            return !uploader2.uploadManage('numberCheck', false, data);
        },
        // 提交开始
        submit: function(e, data) {
            window.console && console.log('submit');
        },
        // 传送开始
        send: function(e, data) {
            window.console && console.log('send');
        },
        start: function(e) {
            window.console && console.log('Uploads started');
        },
        stop: function(e) {
            window.console && console.log('Uploads finished');
        },
        change: function(e, data) {
            $.each(data.files, function(index, file) {
                window.console && console.log('Selected file: ' + file.name);
            });
        },
        // 上传完成
        done: function(e, data) {
            window.console && console.log('done');
            if (data.result.code == 1) {
                uploader2.uploadManage('done', data);
            }else if(data.result.code == 0){
                uploader2.uploadManage('retry',data);
            }
        },
        // 上传进度
        progress: function(e, data) {
            uploader2.uploadManage('progress', data);
        },
        progressall: function(e, data) {
            window.console && console.log('progressall');
            // var progress = parseInt(data.loaded / data.total * 100, 10);
        },
        // 上传失败
        fail: function(e, data) {
            window.console && console.log('failed');
            uploader2.uploadManage('retry',data);
        },
        always: function(e, data) {

        }
    };
    // 混合几个option
    var options = $.extend({}, ajaxOptions, fileOptions, eventOptions);
    // 开启上传空间
    $('#rocoFileUpload2').fileupload(options);
    // 开启上传代理
    uploader2 = $('#uploader2').uploadManage({
        limitMultiFileUploadSize: fileOptions.limitMultiFileUploadSize,
        limitMultiFileNumber: fileOptions.limitMultiFileNumber,
        acceptFileTypes: fileOptions.acceptFileTypes,
        autoUpload: fileOptions.autoUpload,
        view: '#rocoDndArea2', //拖拽区域
            fileList: '#rocoFileList2', //文件列表
            statusBar: '#rocoStatusBar2', //全局状态条
            queueList: '#rocoQueueList2', //总体范围
    });
});