(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('system-manage', 'admins');

        var template = Hogan.compile($('#hoganTmpl').html());
        var roleDataTable = $("#roleDataTable");

        // 从服务端获得所有权限
        var allPermission = null;
        // 获取所有权限
        $.ajax({
            url: ctx + '/api/role/getAllPermission',
            type: 'GET',
            dataType: 'json',
            cache: false,
            success: function(res) {
                if (res.code == 1) {
                    allPermission = res.data;
                }
            }
        });

        // 初始化列表
        var dataTable = $('#roleDataTable').DataTable({
            columns: [
                {
                    data: 'index',
                    title: '',
                    defaultContent:'',
                    className:'td_center',
                    orderable: false,
                    width: '3%'
                },
                {
                    data: 'username',
                    title: '用户名',
                    width: '15%'
                }, {
                    data: 'name',
                    title: '姓名',
                    width: '15%',
                    orderable: true
                }, {
                    data: 'status',
                    title: '状态',
                    width: '15%',
                    render: function(data, type, full, meta) {
                        return 'OPEN' == data ? '启用' : '锁定';
                    },
                    orderable: true
                }
                , {
                    data: 'id',
                    title: '操作',
                    width: '10%',
                    className:'td_center',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                            editBtn: {
                                id: data,
                                open: full.status == 'LOCK',
                                lock: full.status == 'OPEN'
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/adminUser',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function() {
                // 不显示每页多少条
                $('#roleDataTable_length').hide();
            }
        });

        dataTable.on('order.dt search.dt', function() {
            dataTable.column(0, {
                search: 'applied',
                order: 'applied'
            }).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var roleModal = $('#roleModal');


        // 绑定事件
        var bindEvent = function() {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="role-edit"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/adminUser/' + id,
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(roleModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });

            // 锁定开启 按键点击
            roleDataTable.on('click', '[data-handle="role-operation"]', function(event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                $.ajax({
                    url: ctx + '/api/adminUser/' + id + '/switch',
                    type: 'get',
                    dataType: 'json',
                    data: {
                        status: status
                    },
                    cache: false,
                    beforeSend: function() {
                        btnDisable();
                    },
                    success: function(res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            //roleModal.modal('hide');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    },
                    complete: function() {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function(event) {
                $.ajax({
                    url: ctx + '/api/adminUser/0',
                    dataType: 'json',
                    cache: false,
                    beforeSend: function() {
                        btnDisable();
                    },
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(roleModal, res.data, null);
                        }
                    },
                    complete: function() {
                        btnEnable();
                    }
                });

                event.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data, rolePermissions) {

            // 选择的权限
            var selectedPermissions = {};

            var userRole = !!data.admin ? data.admin.roles : [];
            var userSuppliers = !!data.admin ? data.admin.suppliers : [];

            var rolesIndex = 0;
            var suppIndex = 0;

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                admin: data.admin || {},
                roles: data.roles,
                allSuppliers: data.allSuppliers,
                allPermissions: data.allPermissions,
                getPermissionName: function() {
                    return this.value[0].label
                },
                hasRoleChecked: function() {
                    var isCheck = false;
                    var self = this;
                    $(userRole).each(function(idx, item) {
                        if (item.id == self.id) {
                            isCheck = true;
                            return false;
                        }
                    });
                    return isCheck;
                },
                hasrSuppChecked: function() {
                    var isCheck = false;
                    var self = this;
                    $(userSuppliers).each(function(idx, item) {
                        if (item.id == self.id) {
                            isCheck = true;
                            return false;
                        }
                    });
                    return isCheck;
                },
                rolesIndex: function() {
                    return rolesIndex++;
                },
                suppIndex: function() {
                    return suppIndex++;
                }
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
                ifChanged:function (){
                	alert($(this).data("id"));
                }
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                    name: {
                        required: true,
                        maxlength: 20
                    },
                    description: {
                        required: false,
                        maxlength: 25
                    }
                },
                submitHandler: function(form) {
                    if (form.password.value != form.plainPassword.value) {
                        toastr.warning('两次密码输入不一致');
                        return false;
                    }
                    var formObj = {};
                    var formList = decodeURI($(form).serialize()).split('&');
                    $(formList).each(function(idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });

                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/adminUser/' + form.id.value + '/update') : (ctx + '/api/adminUser/create'),
                        type: 'post',
                        dataType: 'json',
                        data: formObj,
                        traditional: true,
                        cache: false,
                        beforeSend: function() {
                            btnDisable();
                        },
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function() {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();
        // 禁用按钮
        var btnDisable = function() {
            $('#deleteRole').attr('disabled', 'disabled');
            $('#submitRole').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#deleteRole').removeAttr('disabled');
            $('#submitRole').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);