(function(window, document, $, Hogan, RocoUtils) {
    $(function() {
        //高亮导航条
        RocoUtils.setSection('operation', 'userlevel');

        var template = Hogan.compile($('#hoganTmpl').html());
        
        // 初始化列表
        var dataTable = $('#userlevelDataTable').DataTable({
            columns: [
                      {
                    	  data:"id",
                    	  visible:false
                      },
                      {
                    	  data: 'index',
                    		title: '',
                    		defaultContent:'',
                    		className:'td_center',
                    		orderable: false,
                    		width: '3%'
                      } ,
                {
                	data: 'level',
                    title: '等级名称',
                    width: '20%',
                    orderable: true
                }     
                ,{
                    data: 'cent',
                    title: '成长值',
                    width: '10%',
                    orderable: false,
                    width: '6%',
                    className:'td_cent',
                }
                , {
                    data: 'discount',
                    title: '折扣',
                    width: '10%',
                    orderable: false,
                    width: '6%',
                    className:'td_cent',
                    render : function (data, type, full, meta){
                    	return "￥"+RocoUtils.formatNumber(data,true);
                    }
                }
                , {
                    data: 'fullImagePath',
                    title: '图标',
                    width: '10%',
                    orderable: false,
                    className:'list-thumb',
                    render: function(data, type, full, meta) {
                    	return "<img src='"+full.fullImagePath+"' />" ;
                    }
                }
                , {
                    data: 'id',
                    title: '操作',
                    width: '5%',
                    className:'td_center',
                    orderable: false,
                    render: function(data, type, full, meta) {
                        // 返回编辑按钮 包含事件名称和id值
                        return template.render({
                            editBtn: {
                                id: full.id,
                            }
                        });
                    }
                }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/userlevel',
                type: 'GET',
                data: function(d) {
                    return $.extend(RocoUtils.buildParam(d),searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            lengthChange:false, // 是否允许显示分页数
            order: [0, 'DESC'],
            initComplete: function() {
                // 不显示每页多少条 粘贴过来的，没用
                //$('#userlevelDataTable_length').hide();
            }
        });
        dataTable.on('order.dt search.dt', function () {
        	dataTable.column(1, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
    			cell.innerHTML = i+1;
    		} );
    	} ).draw();
        // search实现部分
        var searchForm = $('#searchForm'),
        	searchParam = null;
        // search表单提交
        searchForm.on('submit', function() {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });
        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var userlevelModal = $('#userlevelModal');
        // 绑定事件
        var bindEvent = function() {
        	// 编辑按键点击
            dataTable.on('click', '[data-handle="userlevel-edit"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/userlevel/' + id,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            bindModalEvent(userlevelModal, res.data);
                            if(res.data){
                            	var files = null;
                        		var imgPath = res.data.fullImagePath; 
                        		if(imgPath){
                        			if(files==null){
                        				files = [];
                        			}
                        			var imgName = imgPath.substring(imgPath.lastIndexOf("/")+1,imgPath.lastIndexOf("."));
                        			files[files.length] = {
                                		"name": imgName,//图片名称
                                		fullPath:imgPath,
                                        path:imgPath,
                                        type: 'image'   //图片 image Excel  excel
                                	};
                                }
                            	UploadTools.createTo("fileImage", "img", "USER_LEVEL", "imgUrl",1,files);
                            }
                        }
                    }
                });
                event.stopPropagation();
            });
        	 // 编辑按键点击
        	dataTable.on('click', '[data-handle="userlevel-delete"]', function(event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/userlevel/' + id+"/delete",
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function(res) {
                        if (res.code == 1) {
                            //bindModalEvent(rankModal, res.data);
                        	userlevelModal.modal('hide');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    }
                });
                event.stopPropagation();
            });
            // 创建按键点击
            createBtn.on('click', function(event) {
            	bindModalEvent(userlevelModal, null);
            	UploadTools.createTo("fileImage", "img", "USER_LEVEL", "imgUrl",1);
                event.stopPropagation();
            });
        };

        // 模式窗体绑定事件
        var bindModalEvent = function($modal, data) {
        	
            $modal.html(template.render({
                modal: true,
                Level:(data==undefined?{}:data),
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                	level: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                    },
                    cent: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                    },
                    discount: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                    }
                },
                submitHandler: function(form) {
                    var formObj = {};
                    var formList = decodeURIComponent($(form).serialize()).split('&');
                    $(formList).each(function(idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });
                    var action = null;
                    if(data && data.id){
                    	action = ctx + '/api/userlevel/update'
                    }else{
                    	action = ctx + '/api/userlevel/create';
                    }
                    $.ajax({
                        url: action,
                        type: 'POST',
                        dataType: 'json',
                        data: formObj,
                        traditional: true,
                        cache: false,
                        beforeSend: function() {
                            btnDisable();
                        },
                        success: function(res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function() {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function() {
            $('#submitRank').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function() {
            $('#submitRank').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);