/**
 * 极简上传控件二次封装。支持多組件自動封裝 不喜勿噴。
 */
var UploadTools = {
	// options : {},
	controls : {},
	bandInput : {},
	controlCount : 0,
	fileOptions:{},
	ajaxOptions:{},
	eventOptions:{},
	/**
	 * 加载执行
	 */
	onLoad : function() {
		// 局部支持拖拽上传需添加此代码
		$(document).unbind('drop dragover').bind('drop dragover', function(e) {
			e.preventDefault();
		});
	},
	/**
	 * 
	 * @param box
	 *            控件加载容器
	 * @param bandInput
	 *            绑定的文本控件
	 */
	createTo : function(box, fileType, businessType, bandInput,limitMultiFileNumber,files) {
		this.controlCount++;
		var mime = [];
		if (fileType && fileType == "xls") {
			mime[0] = "application/vnd.ms-excel";
			mime[1] = "导入的Excel文件";
		} else {
			mime[0] = "image/*";
			mime[1] = "上传图片";
		}
		var uploaderId = "uploader" + this.controlCount;
		var domainId = "domain" + this.controlCount;
		var fileListId = "fileList" + this.controlCount;
		var dropAreaId = "dropArea" + this.controlCount;
		var fileUploadId = "fileUpload" + this.controlCount;
		var statusBarId = "statusBar" + this.controlCount;
		var data = {
			"uploader" : uploaderId,
			"domain" : domainId,
			"fileList" : fileListId,
			"dropArea" : dropAreaId,
			"fileUpload" : fileUploadId,
			"mimeType" : mime[0],
			"mimeName" : mime[1]
		};
		$("#" + box).html(this.template().render(data));
		var uploader = $('#' + uploaderId);
		var ajaxOptions = this.ajaxOptions(businessType);
		this.ajaxOptions[uploaderId]=ajaxOptions;
		var fileOptions = this.fileOptions(dropAreaId, fileType, true ,limitMultiFileNumber);
		this.fileOptions[uploaderId]=fileOptions;
		var eventOptions = this.eventOptions(uploader, uploaderId);
		this.eventOptions[uploaderId]=eventOptions;
		var tmpOptions = $.extend({}, ajaxOptions, fileOptions, eventOptions);
		// this.options[uploaderId] = options;
		$('#' + fileUploadId).fileupload(tmpOptions);
		// 开启上传代理
		uploader.uploadManage({
			limitMultiFileUploadSize : fileOptions.limitMultiFileUploadSize,
			limitMultiFileNumber : fileOptions.limitMultiFileNumber,
			acceptFileTypes : fileOptions.acceptFileTypes,
			autoUpload : fileOptions.autoUpload,
			view : '#' + dropAreaId, // 拖拽区域
			fileList : '#' + fileListId, // 文件列表
			statusBar : '#' + statusBarId, // 全局状态条
			queueList : '#' + domainId, // 总体范围
		});
		this.controls[uploaderId] = uploader;
		if (bandInput) {
			this.bandInput[uploaderId] = bandInput;
		}
		this.onLoad();
	},
	/**
	 * ajax 配置
	 * 
	 * type:上传类型，服务端需要
	 */
	ajaxOptions : function(type) {
		return {
			url : '/api/upload',
			type : 'POST',
			dataType : 'json',
			// 表单参数
			formData : {
				// 指定上传类型
				imageType : type
			}
		}
	},
	/**
	 * 文件 配置
	 * 
	 * acceptFile : 文件类型 xls|img
	 * 
	 * dropZone : 支持拖拽上传
	 */
	fileOptions : function(dropZone, acceptFile, autoUpload,limitMultiFileNumber) {
		if (acceptFile && acceptFile == 'xls') {
			acceptFile = /(\.|\/)(vnd.openxmlformats-officedocument.spreadsheetml.sheet|vnd.ms-excel|msexcel|x-msexcel|x-ms-excel|x-excel|x-dos_ms_excel|xls|x-xls)$/i;
		} else {// 默认是图片上传
			acceptFile = /(\.|\/)(gif|jpe?g|png)$/i;
		}
		dropZone = '#' + dropZone;
		if (!autoUpload) {
			autoUpload = true;
		}
		return {
			multiple : false, // 禁用多文件上传
			"dropZone" : dropZone, // 支持拖拽上传
			limitMultiFileUploadSize : 2048000, // 单个文件最大上传容量，单位为byte
			limitMultiFileNumber : !limitMultiFileNumber?limitMultiFileNumber:5,
			acceptFileTypes : acceptFile, // 允许上传文件类型
			sequentialUploads : true,
			"autoUpload" : autoUpload, // 不自动上传
		}
	},
	/**
	 * 事件配置
	 * 
	 * @param uploader
	 *            自定义 上传控件
	 * @param callBacks
	 *            自定义回调函数 暂时 禁用
	 */
	eventOptions : function(uploader, uploaderId, callBacks) {
		return {
			// 添加事件
			add : function(e, data) {
				if (uploader.uploadManage('check', data)) {
					// 有错误返回
					return false;
				} else {
					// 没错误提交
					uploader.uploadManage('add', data);
					// 自动上传
					UploadTools.fileOptions[uploaderId].autoUpload && data.submit();
				}
			},
			// 拖拽完成
			drop : function(e, data) {
				return !uploader.uploadManage('numberCheck', false, data);
			},
			// 提交开始
			submit : function(e, data) {
				window.console && console.log('submit');
			},
			// 传送开始
			send : function(e, data) {
				window.console && console.log('send');
			},
			start : function(e) {
				window.console && console.log('Uploads started');
			},
			stop : function(e) {
				window.console && console.log('Uploads finished');
			},
			change : function(e, data) {
				$.each(data.files, function(index, file) {
					window.console && console.log('Selected file: ' + file.name);
				});
			},
			// 上传完成
			done : function(e, data) {
				window.console && console.log('done');
				if (data.result.code == 1) {
					uploader.uploadManage('done', data);
				} else if (data.result.code == 0) {
					uploader.uploadManage('retry', data);
				}
				$("#bandInput").val(data.path);
			},
			// 上传进度
			progress : function(e, data) {
				uploader.uploadManage('progress', data);
			},
			progressall : function(e, data) {
				window.console && console.log('progressall');
			},
			// 上传失败
			fail : function(e, data) {
				window.console && console.log('failed');
				uploader.uploadManage('retry', data);
			},
			always : function(e, data) {

			}
		}
	},
	/**
	 * 控件模板生成
	 * 
	 * @param uploader
	 *            控件BOX uploader
	 * @param domain
	 *            控件作用域范围 总体范围
	 * @param fileList
	 *            文件列表
	 * @param dropArea
	 *            拖拽区域
	 * @param fileUpload
	 *            填充加载 上传控件 参数配置和事件
	 * @returns {String}
	 */
	template : function() {
		var content = '';
		content += '<div id="{{uploader}}" class="uploader">';
		content += '	<div class="clearfix">';
		content += '		<div id="{{domain}}" class="filelist-container fl">';
		content += '			<div id="{{fileList}}" class="filelist">';
		content += '				<div id="{{dropArea}}" class="queueList placeholder fl">';
		content += '					<div class="webuploader-container">';
		content += '						<input id="{{fileUpload}}" type="file" name="file" class="webuploader-element-invisible" accept="{{mimeType}}">';
		content += '							<div class="webuploader-pick">{{mimeName}}</div>';
		content += '					</div>';
		content += '					<p>支持拖拽</p>';
		content += '				</div>';
		content += '			</div>';
		content += '		</div>';
		content += '	</div>';
		content += '</div>';
		return Hogan.compile(content);
	}
};