(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        // 高亮导航条
        RocoUtils.setSection('operation', 'users');
        var template = Hogan.compile($('#hoganTmpl').html());
        // 初始化列表
        var dataTable = $('#userlevelDataTable').DataTable({
            columns: [{
                data: "id",
                visible: false
            }, {
                data: 'index',
                title: '',
                defaultContent: '',
                className: 'td_center',
                orderable: false,
                width: '3%'
            }, {
                data: 'username',
                title: '用户名',
                width: '15%',
                orderable: false
            }, {
                data: 'name',
                title: '姓名',
                defaultContent: '',
                width: '10%',
                orderable: false
            }, {
                data: 'mobilePhone',
                title: '手机号',
                defaultContent: '',
                width: '10%',
                orderable: false
            }, {
                data: 'idCard',
                title: '身份证号',
                defaultContent: '',
                width: '10%',
                orderable: false
            }, {
                data: 'status',
                title: '状态',
                width: '10%',
                orderable: false,
                render: function (data, type, full, meta) {
                    return full.status == "OPEN" ? "开启" : "锁定";
                }
            }, {
                data: 'registerDate',
                title: '注册时间',
                width: '15%',
                orderable: false,
                render: function (data, type, full, meta) {
                    return RocoUtils.formatDate(new Date(full.registerDate), 'yyyy-MM-dd hh:mm');
                }
            }, {
                data: 'id',
                title: '操作',
                width: '5%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    return template.render({
                        editBtn: {
                            id: data,
                            status: full.status,
                            ok: full.status == "OPEN" ? true : false
                        }
                    });
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/user',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            lengthChange: false, // 是否允许显示分页数
            order: [0, 'DESC'],
            initComplete: function () {
                // 不显示每页多少条 粘贴过来的，没用
                // $('#userlevelDataTable_length').hide();
            }
        });
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {
                search: 'applied',
                order: 'applied'
            }).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();
        // search实现部分
        var searchForm = $('#searchForm'), searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });
        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var userlevelModal = $('#userlevelModal');
        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="admin-operation"]', function (event) {
                var id = $(this).data('id');
                var status = $(this).data('status');
                status = status == 'OPEN' ? 'LOCK' : 'OPEN';
                $.ajax({
                    url: ctx + '/api/user/' + id + '/switch',
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    data: {"status": status},
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            // 刷新列表
                            dataTable.ajax.reload();
                        }
                    }
                });
                event.stopPropagation();
            });
        };
        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data) {
            $modal.html(template.render({
                modal: true,
                Level: (data == undefined ? {} : data),
            }));
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            var $form = $modal.find('form');
            // 表单验证
            $form.validate({
                rules: {
                    level: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                    },
                    cent: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                    },
                    discount: {
                        required: true,
                        maxlength: 8,
                        minlength: 1,
                    }
                },
                submitHandler: function (form) {
                    var formObj = {};
                    var formList = decodeURIComponent($(form).serialize())
                        .split('&');
                    $(formList).each(function (idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });
                    var action = null;
                    if (data && data.id) {
                        action = ctx + '/api/userlevel/update'
                    } else {
                        action = ctx + '/api/userlevel/create';
                    }
                    $.ajax({
                        url: action,
                        type: 'POST',
                        dataType: 'json',
                        data: formObj,
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success('操作成功');
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };


        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,
                format: 'YYYY-MM-DD',//时间格式
                min: '1900-01-01', //设定最小日期
                max: '2099-06-16', //最大日期
                isclear: true, //是否显示清空按钮
                istime: false,//是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
                    endDate.start = datas //将结束日的初始值设定为开始日
                }
            };

            var endDate = {
                elem: end,
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
                }
            };

            laydate(startDate);
            laydate(endDate);
        }

        //完成初始化函数
        var init = function () {
            setTimeout(initDateControl("#startDate", "#endDate"), 1);
        }

        init();
        bindEvent();
        // 禁用按钮
        var btnDisable = function () {
            $('#submitRank').attr('disabled', 'disabled');
        };
        // 启用按钮
        var btnEnable = function () {
            $('#submitRank').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);