(function(window, document, $, Hogan, RocoUtils) {
	$(function() {
		// 高亮导航条
		RocoUtils.setSection('operation', 'users');
		var template = Hogan.compile($('#hoganTmpl').html());
		var uid = window.location.href;
		if (uid) {
			uid = uid.substring(uid.indexOf("?") + 1);
			$.ajax({
				url : ctx + '/api/user/' + uid,
				type : 'GET',
				dataType : 'json',
				cache : false,
				success : function(res) {
					if (res.code == 1) {
						$("#userName").val(res.data.username);
						$("#mobilePhone").val(res.data.mobilePhone);
						$("#growth").val(res.data.growth);
						$("#userLevel").val(res.data.userLevel.level);
						$("#registerDate").val(res.data.registerDate == undefined ? "":    RocoUtils.formatDate(new Date(res.data.registerDate),"yyyy-MM-dd hh:mm:ss"));
						$("#statusLabel").val(res.data.status == "OPEN" ? "启用" : "停用");
						$("#gender").val(res.data.gender == "male" ? "男" : "女");
						$("#birthday").val(res.data.birthday == undefined ? "" :  RocoUtils.formatDate(new Date(res.data.birthday),"yyyy-MM-dd"));
						$("#remainCents").val(res.data.remainCents);
						$("#email").val(res.data.email);
					}
				}
			});
		}
		var tableArray = {
			address : [ "addressDataTable", {} ],
			paymentRecord : [ "paymentRecordDataTable", {} ],
			useRecord : [ "useRecordDataTable", {} ],
			loginHistory : [ "loginHistoryDataTable", {} ]
		};
		var paymentRecordDataTable =null;
		var table = {
			createDataTable : function(dataTableArray, tableColumns, action, isPage) {
				// 初始化列表
				dataTableArray[1] = $('#' + dataTableArray[0]).DataTable({"columns" : tableColumns,
					processing : true,
					serverSide : true,
					ajax : {
						url : ctx + action,
						type : 'GET',
						data : function(d) {
							return $.extend(RocoUtils.buildParam(d), null);
						}
					},
					paging : isPage == undefined ? true : isPage,
					ordering : true,
					info : isPage == undefined ? true : isPage,
					searching : false,
					// 每页20条
					pageLength : 20,
					lengthMenu : [ 20 ],
					lengthChange : false, // 是否允许显示分页数
					order : [ 0, 'DESC' ],
					initComplete : function() {
					}
				});
				
				if(dataTableArray[0]=="paymentRecordDataTable"){
					paymentRecordDataTable = dataTableArray[1];
				}
				
				dataTableArray[1].on('order.dt search.dt', function() {
					dataTableArray[1].column(1, {
						search : 'applied',
						order : 'applied'
					}).nodes().each(function(cell, i) {
						cell.innerHTML = i + 1;
					});
				}).draw();
			},
			
			init : function() {
				this.createDataTable(tableArray.address, [{
					data : "defaultAddr",
					visible : false
				}, {
					data : 'address',
					title : '收货地址',
					width : '50%',
					orderable : false,
					render:function(data, type, full, meta){
						var addrInfo = "";
						$.each(full.proviceCityList,function(idx,item){
							addrInfo +=item.name+"、";
						});
						addrInfo +=full.address;
						return addrInfo;
					}
				}, {
					data : 'recipient',
					title : '收货人',
					width : '10%',
					defaultContent: '',
					orderable : false
				}, {
					data : 'postcode',
					title : '邮编',
					defaultContent: '',
					orderable : false,
					width : '10%'
				}, {
					data : 'mobile',
					title : '手机号',
					defaultContent: '',
					width : '10%',
					orderable : false
				}, {
					data : 'recipientPhone',
					title : '固定电话',
					defaultContent: '',
					width : '10%',
					orderable : false
				}, {
					data : 'defaultAddr',
					title : '是否默认',
					width : '7%',
					orderable : false,
					render : function(data, type, full, meta) {
						return data ? "是" : "否";
					}
				} ], 
				"/api/user/address/" + uid, false);
				
				
				this.createDataTable(tableArray.paymentRecord, [ {
					data : "id",
					visible : false
				}, {
					data : 'index',
					title : '',
					defaultContent : '',
					className : 'td_center',
					orderable : false,
					width : '3%'
				}, {
					data : 'code',
					title : '积分编码',
					width : "15%",
					orderable : false
				}, {
					data : 'cent',
					title : '积分值',
					width : "10%",
					orderable : false
				}, {
					data : 'balance',
					title : '余额',
					width : "10%",
					orderable : false
				}, {
					data : 'statusLabel',
					title : '状态',
					width : "10%",
					orderable : false
				}, {
					data : 'expireDate',
					title : '有效截止日',
					width : "13%",
					orderable : false
				}, {
					data : 'centRule',
					title : '积分计划',
					width : "15%",
					orderable : false
				},{
					data : 'id',
					title : '操作',
					width : '5%',
					className : 'td_center',
					orderable : false,
					render : function(data, type, full, meta) {
						// 返回编辑按钮 包含事件名称和id值
						var info = {editBtn : {
							id: data,
							status:full.status
						}};
						if(full.status=="CANUSE" || full.status=="LOCK"){
							info.editBtn.show=true;
							info.editBtn.ok = full.status=="CANUSE"?true:false;
						}
						return template.render(info);
					}
				} ], "/api/user/centsget/" + uid);
				this.createDataTable(tableArray.useRecord, [ {
					data : "snNum",
					visible : false
				}, {
					data : 'index',
					title : '',
					defaultContent : '',
					className : 'td_center',
					orderable : false,
					width : '3%'
				}, {
					data : 'snNum',
					title : '交易流水号',
					width : "15%",
					orderable : false
				}, {
					data : 'consumeType',
					title : '消耗类型',
					width : "15%",
					orderable : false
				}, {
					data : 'consumeCent',
					title : '消耗积分',
					width : "15%",
					orderable : false
				}, {
					data : 'status',
					title : '消耗状态',
					width : "15%",
					orderable : false
				}, {
					data : 'dateline',
					title : '生成日期',
					width : "20%",
					orderable : false
				} ], "/api/user/centsconsume/" + uid);
				this.createDataTable(tableArray.loginHistory, [ {
					data : "ip",
					visible : false
				}, {
					data : 'index',
					title : '',
					defaultContent : '',
					className : 'td_center',
					orderable : false,
					width : '3%'
				}, {
					data : 'ip',
					title : '登录IP',
					width : "25%",
					orderable : false
				}, {
					data : 'loginTime',
					title : '登录日期',
					width : "75%",
					orderable : false
				} ], "/api/user/loginhistory/" + uid);
				// 编辑按键点击
				paymentRecordDataTable.on('click', '[data-handle="admin-operation"]', function(event) {
					var id = $(this).data('id');
					var status = $(this).data('status');
	                status = status == 'CANUSE' ? 'LOCK' : 'CANUSE';
					$.ajax({
						url : ctx + '/api/cents/'+id+'/switch',
						type : 'GET',
						dataType : 'json',
						cache : false,
						data:{"status":status},
						success : function(res) {
							if (res.code == 1) {
	                            toastr.success('操作成功');
	                            // 刷新列表
	                            paymentRecordDataTable.ajax.reload();
	                        }
						}
					});
					event.stopPropagation();
				});
			}
		};
		table.init();
	});
})(window, document, this.jQuery, Hogan, this.RocoUtils);