(function() {
    var RocoUtils = window.RocoUtils = {};

    //把querystring 转换为对象
    RocoUtils.parseQueryString = function(queryString) {
        var params = {};
        var parts = queryString && queryString.split('&') || window.location.search.substr(1).split('\x26');

        for (var i = 0; i < parts.length; i++) {
            var keyValuePair = parts[i].split('=');
            var key = decodeURIComponent(keyValuePair[0]);
            var value = keyValuePair[1] ?
                decodeURIComponent(keyValuePair[1].replace(/\+/g, ' ')) :
                keyValuePair[1];

            switch (typeof(params[key])) {
                case 'undefined':
                    params[key] = value;
                    break; //first
                case 'array':
                    params[key].push(value);
                    break; //third or more
                default:
                    params[key] = [params[key], value]; // second
            }
        }
        return params;
    };


    /*
     * 设置nav导航条高亮
     * param section string 一级菜单
     * param subSection string 二级菜单
     */
    RocoUtils.setSection = function(section, subSection) {
        var $item = $('#side-menu');
        $item_li = $item.find('[data-section="' + section + '"]');
        $item.find('li:only-child').removeClass('active');
        $item_li.addClass('active');
        if (subSection) {
            $item_li.find('ul').addClass('in');
            $item_li.find('ul->li').removeClass('active');
            $item_li.find('[data-subsection="' + subSection + '"]').addClass('active');
        }
    }

    /*
     * 将Datatable 插件提交的参数转换为简单object
     * param data obj datatable产生的参数
     * return object 返回特别定制的参数
     */
    RocoUtils.buildParam = function(data) {
        return {
            draw: data.draw,
            start: data.start,
            //paging 为false时length为-1
            length: data.length,
            // 只支持第一咧排序
            orderColumn: data.columns[data.order[0].column].data,
            orderSort: data.order[0].dir,
            // keyword默认为空，需自行添加
            keyword: ''
        };
    };

    /*
     * formatNumber(data,type)
     * 功能：金额按千位逗号分割
     * 参数：data，需要格式化的金额或积分.
     * 参数：type,判断格式化后的金额是否需要小数位(如果为true,末尾带两位小数).
     * 返回：返回格式化后的数值字符串.
     */
    RocoUtils.formatNumber = function (data, type) {
        if (/[^0-9\.]/.test(data))
            return "0";
        if (data == null || data == "")
            return "0";
        data = data.toString().replace(/^(\d*)$/, "$1.");
        data = (data + "00").replace(/(\d*\.\d\d)\d*/, "$1");
        data = data.replace(".", ",");
        var re = /(\d)(\d{3},)/;
        while (re.test(data))
            data = data.replace(re, "$1,$2");
        data = data.replace(/,(\d\d)$/, ".$1");
        if (type == 0) {// 不带小数位(默认是有小数位)
            var a = data.split(".");
            if (a[1] == "00") {
                data = a[0];
            }
        }
        return data;
    }

    /*
     * 格式化时间
     * now:事件对象
     * fmt:时间格式 yyyy-MM-dd HH:mm:ss
     */
    RocoUtils.formatDate = function (now, fmt) {
        // $.formatDate(new Date(),'yyyy-MM-dd hh:mm:ss');
        var o = {
            "M+": now.getMonth() + 1, //月份
            "d+": now.getDate(), //日
            "h+": now.getHours(), //小时
            "m+": now.getMinutes(), //分
            "s+": now.getSeconds(), //秒
            "q+": Math.floor((now.getMonth() + 3) / 3), //季度
            "S": now.getMilliseconds() //毫秒
        };
        if (/(y+)/.test(fmt))
            fmt = fmt.replace(RegExp.$1, (now.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt))
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    }

})();