(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'virtualproduct');

        var template = Hogan.compile($('#hoganTmpl').html());
        var cardDataTable = $("#cardDataTable");

        // 初始化列表
        var dataTable = cardDataTable.DataTable({
            columns: [{
                data: 'sku_code',
                visible: false,
                defaultContent: ''
            }, {
                data: 'index',
                title: '',
                defaultContent: '',
                className: 'td_center',
                orderable: false,
                width: '3%'
            }, {
                data: 'skuCode',
                title: 'sku编码',
                width: '10%',
                render: function (data, type, full, meta) {
                    return "<div data-toggle='popover' data-flag=false data-skuid='" + full.skuCode + "' >" + data + "</div>"
                },
                orderable: false
            }, {
                data: 'serialNo',
                title: '序列号',
                width: '15%',
                orderable: false
            }, {
                data: 'cardno',
                title: '卡号',
                width: '20%',
                orderable: false
            }, {
                data: 'passwd',
                title: '密码/兑换码',
                width: '10%',
                orderable: false
            }, {
                data: 'expired',
                title: '有效期',
                width: '8%',
                orderable: false,
                render: function (data, type, full, meta) {
                    return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd');
                }
            }, {
                data: 'status',
                title: '状态',
                width: '6%',
                render: function (data, type, full, meta) {
                    if (data == 'UNUSED') {
                        return "未使用";
                    } else if (data == 'USED') {
                        return "已使用";
                    } else if (data == 'EXPRIED') {
                        return "已过期";
                    } else if (data == 'CANCEL') {
                        return "已作废";
                    }
                },
                orderable: false
            }, {
                data: 'type',
                title: '类型',
                width: '5%',
                render: function (data, type, full, meta) {
                    if (data == "EXCHANGE_CODE") {
                        return "兑换码";
                    } else if (data == "CARD_PWD") {
                        return "卡密";
                    }
                },
                orderable: false
            }, {
                data: 'id',
                title: '操作',
                width: '10%',
                orderable: false,
                className: 'td_center',
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        editBtn: editBtn(full),
                        status: full.status
                    });
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/virtualprod',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#cardDataTable_length').hide();
            }
        });

        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var vpModal = $('#vpModal');
        var Export = $('#Export');
        var importBtn = $("#importBtn")


        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="role-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/virtualprod/' + id,
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(vpModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });

            importBtn.on('click', function (event) {
                importModalEvent(vpModal);
                UploadTools.createTo("fileImage", "xls", "VIRTUALCARD_IMPORT", "filePath", 1);
            });

            Export.on('click', function (event) {
                var str = $("#searchForm").serialize();
                location.href = ctx + '/api/virtualprod/export?' + str + '&_=' + new Date().getTime();
            });

            // 锁定开启 按键点击
            cardDataTable.on('click', '[data-handle="vp-operation"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/virtualprod/destroy/' + id,
                    type: 'get',
                    dataType: 'json',
                    cache: false,
                    beforeSend: function () {
                        //btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success("修改成功");
                            dataTable.ajax.reload();
                            console.log(dataTable);
                        } else {
                            toastr.error("修改失败");
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function (event) {
                bindModalEvent(vpModal, null, null);
                event.stopPropagation();
            });

            //使用情况查询
            $("div #buttons").on('click', '[data-useStatus]', function () {
                $(this).parent().children().each(function (item) {
                    $(this).removeClass("btn-primary");
                    $(this).addClass("btn-white");
                });
                $(this).removeClass("btn-white");
                $(this).addClass("btn-primary");
                var status = $(this).data("usestatus");
                $("#usedStatus").val(status);
                search();
            });
        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, rolePermissions) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                data: data || {},
                time: getTime(data)
            }));

            $modal.one('shown.bs.modal', function () {
                setTimeout(function () {
                    laydate({
                        elem: '#expired',
                        event: 'focus'
                    });
                }, 1);
            });

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            $("#type").on("change", function (e) {
                changeModel(this.value);
            })

            var code = $("#sku_code").val();

            if (code != "") {
                var value = $("#selectvalue").val();
                $("#type option").each(function () {
                    if (this.value == value) {
                        $(this).prop("selected", true);
                        changeModel(this.value);
                        $("#type").attr("disabled", true);
                    }
                });
            }

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                submitHandler: function (form) {

                    var formObj = {};
                    var formList = decodeURI($(form).serialize()).split('&');
                    $(formList).each(function (idx, item) {
                        var keyValue = item.split('=');
                        if (keyValue.length > 1) {
                            formObj[keyValue[0]] = keyValue[1];
                        }
                    });

                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/virtualprod/update') : (ctx + '/api/virtualprod/create'),
                        type: 'POST',
                        dataType: 'json',
                        data: $(form).serialize(),
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            }
                        }
                    });
                }
            });
        };

        var importModalEvent = function ($modal) {
            // 重置模式窗体内html
            $modal.html(template.render({
                import: true
            }));
            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            //下载模板
            $("#downLoadModal").on('click', function (event) {
                window.location.href = ctx + '/api/virtualprod/download?_=' + new Date().getTime();
            });

            //导入
            $("#importModal1").on('click', function (event) {

                console.log($('#filePath'));
                $.excelImpTip({
                    path: $('#filePath').val(),
                    formData: $modal.find('form').serialize(),
                    formUrl: '/api/virtualprod/import',
                    callback: function (res) {
                        if (res.code == "1") {
                            $modal.modal('hide');
                        }
                    }
                });
            });
        }


        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            $('#submitExpress').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#submitExpress').removeAttr('disabled');
        };

        var changeModel = function (value) {
            if (value == 'EXCHANGE_CODE') {
                $("#selectDiv").hide();
                $("#passwdlable").text("兑换码：");
                $("#passwd").attr("placeholder", "兑换码");
            } else if (value == 'CARD_PWD') {
                $("#selectDiv").show();
                $("#passwd").attr("placeholder", "密码");
                $("#passwdlable").text("密码：");
            } else {

            }
            ;
        }

        //查询
        var search = function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
        }

        var getTime = function (data) {
            if (data && data.expired) {
                return RocoUtils.formatDate(new Date(data.expired), 'yyyy-MM-dd')
            } else {
                return "";
            }
        }

        var jsonToString = function (json) {
            if (!json || json.length == 0)
                return ""
            var str = "";
            $.each(json, function (i) {
                str += i + " : " + json[i] + "</br>"
            });
            return str;
        }

        //操作
        var editBtn = function (data) {
            if (data == null || data == 'undefined')
                return null;
            if (data.status == "UNUSED") {
                var value = {
                    id: data.id
                };
                return value;
            } else {
                return '';
            }
        }
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);