(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('data-dict', 'warehouse');

        var template = Hogan.compile($('#hoganTmpl').html());
        var warehouseDataTable = $("#warehouseDataTable");

        // 初始化列表
        var dataTable = $('#warehouseDataTable').DataTable({

            // table的初始定义
            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }, {
                orderable: false,
                targets: [0, 1, 7]
            }],

            columns: [{
                data: 'id'
            }, {
                className: 'td_center',
                width: '3%'
            }, {
                data: 'code',
                title: '编码',
                width: '15%'
            }, {
                data: 'name',
                title: '名称',
                width: '15%',
            }, {
                data: 'contact',
                title: '联系人',
                width: '10%'
            }, {
                data: 'telephone',
                title: '电话',
                width: '15%'
            }, {
                data: 'state',
                title: '状态',
                width: '5%',
                render: function (data, type, full, meta) {
                    return 'OPEN' == data ? '启用' : '停用';
                },
                orderable: true
            }, {
                data: 'id',
                title: '操作',
                width: '10%',
                className: 'td_center',
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        editBtn: {
                            id: data,
                            content: function () {
                                return full.state == 'OPEN' ? '停用' : '启用';
                            },
                            state: full.state,
                            isOpenBtn:full.state == 'LOCK'
                        }
                    });
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/warehouse',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [1, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#warehouseDataTable_length').hide();
            }
        });

        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var warehouseModal = $('#warehouseModal');


        // 绑定事件
        var bindEvent = function () {
            // 编辑按键点击
            dataTable.on('click', '[data-handle="warehouse-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/warehouse/' + id + '/getInfo',
                    type: 'POST',
                    dataType: 'json',
                    cache: false,
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(warehouseModal, res.data, null);
                        }
                    }
                });
                event.stopPropagation();
            });

            // 锁定开启 按键点击
            dataTable.on('click', '[data-handle="warehouse-operation"]', function (event) {
                var id = $(this).data('id');
                var state = $(this).data('state');
                console.log(id+":"+state);
                state = state == 'OPEN' ? 'LOCK' : 'OPEN';
                $.ajax({
                    url: ctx + '/api/warehouse/update',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        id: id,
                        state: state
                    },
                    cache: false,
                    beforeSend: function () {
                        //btnDisable();
                    },
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success("状态修改成功");
                            // 刷新列表
                            dataTable.ajax.reload();
                            console.log(dataTable);
                        } else {
                            toastr.error("状态修改失败");
                        }
                    },
                    complete: function () {
                        btnEnable();
                    }
                });
                event.stopPropagation();
            });

            // 创建按键点击
            createBtn.on('click', function (event) {
                console.log(event)
                bindModalEvent(warehouseModal, null, null);
                event.stopPropagation();
            });

        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, rolePermissions) {

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                warehouse: data || {}
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                rules: {
                    code: {
                        required: true,
                        maxlength: 25
                    },
                    name: {
                        required: true,
                        maxlength: 30
                    },
                    contact: {
                        maxlength:30
                    },
                    telephone: {
                        digits:true,
                        maxlength: 13
                    }
                },
                submitHandler: function (form) {

                    var formObj = {};

                    $.ajax({
                        url: !!form.id.value ? (ctx + '/api/warehouse/update') : (ctx + '/api/warehouse/create'),
                        type: 'post',
                        dataType: 'json',
                        data: $(form).serialize(),
                        traditional: true,
                        cache: false,
                        beforeSend: function () {
                            btnDisable();
                        },
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                $modal.modal('hide');
                                // 刷新列表
                                dataTable.ajax.reload();
                            } else {
                                toastr.error(res.message);
                            }
                        },
                        complete: function () {
                            btnEnable();
                        }
                    });
                }
            });
        };

        bindEvent();

        // 禁用按钮
        var btnDisable = function () {
            $('#submitWarehouse').attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function () {
            $('#submitWarehouse').removeAttr('disabled');
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);