(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('weixin', 'menue');

        var template = Hogan.compile($('#hoganTmpl').html());
        var menutable = $("#menuetable");
        var menuModal = $('#menuModal');
        
        var init = function(){
        	menutable.empty();
        	$.ajax({
                url: ctx + '/api/wx/menu',
                type: 'get',
                success: function (res) {
                	var table = [];
                	$(res).each(function(index,_this){
                		table.push("<tr>")
                		table.push("<td>"+checkNull(_this.menuName)+"</td>");
                		table.push("<td>"+checkNull(_this.menuType)+"</td>");
                		table.push("<td>"+checkNull(_this.act)+"</td>");
                		table.push("<td>"+castBoolean(checkNull(_this.boundAccess))+"</td>");
                		table.push("<td>"+checkNull(_this.linkUrl)+"</td>");
                		table.push("<td data-handle='menu-seq' data-value='"+_this.seq+"' data-id='"+_this.id+"'>"+checkNull(_this.seq)+"</td>");
                		table.push("<td>");
                		table.push("<button data-handle='menu-del' data-id='"+_this.id+"' data-pid='"+_this.pid+"' class='btn btn-primary btn-xs' type='button'>删除</button>&nbsp;&nbsp;");
                		table.push("<button data-handle='menu-edit' data-id='"+_this.id+"' class='btn btn-primary btn-xs' type='button'>修改</button>&nbsp;&nbsp;");
                		table.push("<button data-handle='menu-add' data-id='"+_this.id+"' class='btn btn-primary btn-xs' type='button'>添加</button>");
                		table.push("</td>");
                		table.push("</tr>");
                		if(_this.childMenuList){
                			$(_this.childMenuList).each(function(index,this_){
                				table.push("<tr>");
                        		table.push("<td>&nbsp;├──"+checkNull(this_.menuName)+"</td>");
                        		table.push("<td>"+checkNull(this_.menuType)+"</td>");
                        		table.push("<td>"+checkNull(this_.act)+"</td>");
                        		table.push("<td>"+castBoolean(checkNull(this_.boundAccess))+"</td>");
                        		table.push("<td>"+checkNull(this_.linkUrl)+"</td>");
                        		table.push("<td data-handle='menu-seq' data-value='"+this_.seq+"' data-id='"+this_.id+"'>"+checkNull(this_.seq)+"</td>");
                        		table.push("<td>");
                        		table.push("<button data-handle='menu-del' data-id='"+this_.id+"' data-pid='"+this_.pid+"' class='btn btn-primary btn-xs' type='button'>删除</button>&nbsp;&nbsp;");
                        		table.push("<button data-handle='menu-edit' data-id='"+this_.id+"' class='btn btn-primary btn-xs' type='button'>修改</button>");
                        		table.push("</td>");
                        		table.push("</tr>");
                			})
                		}
                	});
                	menutable.append(table.join(""));
                }
            });
        }





        // 绑定事件
        var bindEvent = function () {
        	// 绑定删除
        	menutable.on('click', '[data-handle="menu-del"]', function (event) {
                var id = $(this).data('id');
                var pid = $(this).data('pid');
                var messgae = "是否删除该菜单？";
                if(pid == "0"){
                	messgae = "删除父菜单会导致子菜单也删除，是否继续删除？"
                }
                
                if(confirm(messgae)){
                	$.ajax({
                        url: ctx + '/api/wx/menu/rm/' + id,
                        type: 'get',
                        dataType: 'json',
                        success: function (res) {
                            if (res.code == 1) {
                                toastr.success('删除成功！');
                                // 刷新列表
                                menutable.html("");
                                init();
                            }
                        }
                    });
                }
                event.stopPropagation();
            });
        	
        	// 添加子菜单
        	menutable.on('click', '[data-handle="menu-add"]', function (event) {
        		var id = $(this).data('id');
        		bindModalEvent(menuModal,null,id);
        		event.stopPropagation();
        	});
        	
        	// 修改
        	menutable.on('click', '[data-handle="menu-edit"]', function (event) {
        		var id = $(this).data('id');
        		$.ajax({
                    url: ctx + '/api/wx/menu/' + id,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                    	bindModalEvent(menuModal,res,null);
                    }
                });
        		event.stopPropagation();
        	});
        	
        	// 序号改变
        	menutable.on('click', '[data-handle="menu-seq"]', function (event) {
        		var _this = $(this);
        		
        		if(_this.find('input[type="text"]').length > 0) 
        			return false;
        		
        		var id = _this.data('id');
        		var value = _this.data('value');
        		
        		var inputStr = "<input type='text' name='menuSeq_"+id+"' value='"+value+"' size='10'/>"
        		_this.empty();
        		_this.append(inputStr);
        		_this.off();
        		event.stopPropagation();
        	});
        	
        	//保存序号
        	$("#saveSeq").on("click",function(event){
        		var seqFrom = $("#seqFrom");
        		var data = seqFrom.serialize();
        		if(data == ""){
        			toastr.success('没有改动不需要保存！');
        			return;
        		}
        		
            	$.ajax({
                    url: ctx + '/api/wx/menu/updateSeqs',
                    type: 'post',
                    dataType: 'json',
                    data: seqFrom.serialize(),
                    success: function (res) {
                        if (res.code == 1) {
                            toastr.success('保存成功！');
                            init();
                        }
                    }
                });
                event.stopPropagation();
        	})
        	
        	//添加父机按钮
        	$("#createBtn").on("click",function(event){
        		bindModalEvent(menuModal,null,null);
        		event.stopPropagation();
        	})
        	
        	//生成微信按钮
        	$("#generateBtn").on("click",function(event){
        		if(confirm("是否生成微信按钮？")){
                	$.ajax({
                        url: ctx + '/api/wx/menu/generate',
                        type: 'get',
                        dataType: 'json',
                        success: function (res) {
                            if (res.code == 1) {
                                toastr.success('微信按钮已生成！');
                            }
                        }
                    });
                }
                event.stopPropagation();
        	})
        	
        	
        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, pid) {


            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                data : data || {},
                pid : pid || '0'
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });
            
            if(data){
            	//是否必须关注下拉框回显
            	$("#menu_boundAccess").val(""+data.boundAccess);
            	//根据按钮类型判断链接是否显示
            	$('#menu_menuType').val(data.menuType);
            	if(data.menuType != 'view'){
            		$("#menu_linkUrl").hide();
    			}else{
    				$("#menu_act").hide();
    			}
            }else{
            	$("#menu_linkUrl").hide();
            };
            //按钮类型绑定改变事件
            $("#menu_menuType").change(function(){
            	var value = $(this).val();
            	if(value != 'view'){
            		$("#menu_linkUrl").hide();
            		$("#menu_act").show();
            	}else{
            		$("#menu_linkUrl").show();
            		$("#menu_act").hide();
            	}
            });
            
            
            var $form = $modal.find('form');

            // 表单验证
            $form.validate({
                submitHandler: function (form) {

                    $.ajax({
                        url: ctx + '/api/wx/menu/',
                        type: 'POST',
                        dataType: 'json',
                        data: $(form).serialize(),
                        success: function (res) {
                            if (res.code == "1") {
                                toastr.success(res.message);
                                $modal.modal('hide');
                                init();
                            }
                        }
                    });
                }
            });
            
        };
        
        init();
        bindEvent();

        //非空输出
        var checkNull = function(data){
        	if(!data){
        		return "";
        	}
        	return data;
        }
        //true,false 转 汉字
        var castBoolean = function(date){
        	if(date){
        		return "是"
        	}else{
        		return "否"
        	}
        }
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);