(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('weixin', 'user');

        var template = Hogan.compile($('#hoganTmpl').html());
        var weixinUserDataTable = $("#weixinUserDataTable");

        // 加载搜索时间空间,只输入一个参数表示加载输入参数的时间空间,输入两个参数表示加载开始日期和结束日期的时间空间 参数为JQuery选择器的值 如 '#startDate'
        var initDateControl = function (start, end) {
            var startDate = {
                elem: start,    //需显示日期的元素选择器
                format: 'YYYY-MM-DD',//时间格式
                min: '1900-01-01', //设定最小日期
                max: '2099-06-16', //最大日期
                isclear: true, //是否显示清空按钮
                istime: false,//是否显示时间
                istoday: true,
                festival: true,
                choose: function (datas) {
                    endDate.min = datas; //开始日选好后，重置结束日的最小日期
                    endDate.start = datas //将结束日的初始值设定为开始日
                }
            };

            var endDate = {
                elem: end,
                format: 'YYYY-MM-DD',
                min: '1900-01-01',
                max: '2099-06-16',
                isclear: true,
                istime: false,
                istoday: true,
                festival: true,
                choose: function (datas) {
                    startDate.max = datas; //结束日选好后，重置开始日的最大日期
                }
            };

            laydate(startDate);
            laydate(endDate);
        }

        // 加载查询条件中的时间空间
        setTimeout(initDateControl('#subscribeStartDate', '#subscribeEndDate'),1000);
        

        // 所有归属类型
        var centConsumes = null;
        // 当前归属类型
        var centConsume = null;


        // 初始化列表
        var dataTable = $('#weixinUserDataTable').DataTable({

            // 预设一些列的属性
            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: [0]
            }, {
                orderable: false,
                targets: [0,1,2,3]
            }],

            columns: [{
                data: 'id'
            },{
                className: 'td_center',
                width: '3%'
            }, {
                data: 'nickName',
                title: '昵称',
                width: '8%',
                render: function (data, type, full, meta) {
                	return "<a href='javaScript:void(0)' data-handle='go' data-id='"+full.id+"'>"+data+"</a>"
                }
            }, {
                data: 'openId',
                title: 'openId',
                width: '15%'
            }, {
                data: 'sex',
                title: '性别',
                width: '10%',
                render: function (data, type, full, meta) {
                	if(data == 'male'){
                		return "男";
                	}else if(data == 'female'){
                		return "女";
                	}else{
                		return "未知";
                	}
                }
            
            }, {
                data: 'country',
                title: '国家',
                width: '8%'
            }, {
                data: 'province',
                title: '省份',
                width: '8%'
            }, {
                data: 'city',
                title: '城市',
                width: '8%',
                orderData: [1]
            }, {
                data: 'subscribeTime',
                title: '关注时间',
                width: '12%',
                orderData: [2],
                render: function (data, type, full, meta) {
                    return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd');
                }
            }, {
                data: 'bounded',
                title: '是否绑定',
                width: '12%',
                orderData: [3],
                render: function (data, type, full, meta) {
                    if(data == "true"){
                    	return "是";
                    }else{
                    	return "否";
                    }
                }
            },{
                data: 'id',
                title: '操作',
                width: '20%',
                className: 'td_center',
                orderable: false,
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        DRAFT : full.status == 'DRAFT' ? {id : data} : '',
                        WAITAUDIT : full.status == 'WAIT_AUDIT' ? {id : data} : '',
                        OPEN : full.status == 'OPEN' ? {id : data} : '',
                        LOCK : full.status == 'LOCK' ? {id : data} : '',
                    });
                }
            }
            ],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/wx/user',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            lengthChange: false,
            order: [0, 'desc'],
        });

        // 首列显示序号,并且监听搜索排序事件,重新渲染序号
        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');
        // 模式窗体
        var centRuleModal = $('#centRuleModal');


        // 绑定事件
        var bindEvent = function () {
            

        };

        // 模式窗体绑定事件
        var bindModalEvent = function ($modal, data, rolePermissions) {


            // 重置模式窗体内html
            $modal.html(template.render({
                modal: true,
                rule: data || {}
            }));

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });


           
        };

        bindEvent();

        
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);