(function (window, document, $, Hogan, RocoUtils) {
    $(function () {
        //高亮导航条
        RocoUtils.setSection('operation', 'workorder');

        var template = Hogan.compile($('#hoganTmpl').html());
        var express = null;
        // 全局的workorderid变量
        var globalWorkOrderId = null;
        //登录的管理员Id
        var loginAdminId = $("div.navbar-header").find("strong.font-bold").eq(0).attr("data-adminid")-0;
        
        $.ajax({
            url: ctx + '/api/express/all',
            type: "GET",
            dataType: "json",
            asyn: false,
            success: function (res, status) {
                if (res.code == 1) {
                    express = res.data;
                }
            }
        });

        // 初始化列表
        var dataTable = $('#workorderDataTable').DataTable({
            // 初始化column的一些属性
            columnDefs: [{
                defaultContent: '',
                targets: '_all'
            }, {
                visible: false,
                targets: 0
            }, {
                orderable: false,
                targets: '_all'
            }],

            columns: [{
                data: 'id'
            }, {
                className: 'td_center',
                width: '3%'
            }, {
                data: 'code',
                title: '工单号',
                width: '15%',
                render: function (data, type, full, meta) {
                    return "<a href='javaScript:void(0)' data-handle='show-workorder' data-id='" + full.id + "'>" + data + "</a>"
                }
            }, {
                data: 'order.orderCode',
                title: '订单编号',
                width: '15%'
            }, {
                data: 'order.user.username',
                title: '退货人会员名',
                width: '15%'
            }, {
                data: 'type',
                title: '工单类别',
                width: '7%',
                render: function (data) {
                    if ('CONSULT' == data) {
                        return '咨询';
                    } else if ('COMPLAINT' == data) {
                        return '投诉';
                    } else if ('REFUND' == data) {
                        return '退货';
                    } else {
                        return '';
                    }
                }
            }, {
                data: 'state',
                title: '结案否',
                width: '7%',
                render: function (data) {
                    return data ? "已结案" : "未结案";
                }
            }, {
                data: 'createTime',
                title: '创建时间',
                width: '12%',
                render: function (data) {
                    return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm');
                }
            }, {
                data: 'id',
                title: '操作',
                className: 'td_center',
                render: function (data, type, full, meta) {
                    // 返回编辑按钮 包含事件名称和id值
                    return template.render({
                        operateBtn: {
                            id: full.id,
                            editBtn: !full.state,
                            finishBtn: full.closeAllowed
                        }
                    });
                }
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: ctx + '/api/workorder',
                type: 'GET',
                data: function (d) {
                    return $.extend(RocoUtils.buildParam(d), searchParam);
                }
            },
            paging: true,
            ordering: true,
            info: true,
            searching: false,
            // 每页20条
            pageLength: 20,
            lengthMenu: [20],
            order: [0, 'desc'],
            initComplete: function () {
                // 不显示每页多少条
                $('#workorderDataTable_length').hide();
            }
        });

        dataTable.on('order.dt search.dt', function () {
            dataTable.column(1, {
                search: 'applied',
                order: 'applied'
            }).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();

        // search实现部分
        var searchForm = $('#searchForm');
        // search参数
        var searchParam = null;
        // search表单提交
        searchForm.on('submit', function () {
            searchParam = RocoUtils.parseQueryString(searchForm.serialize());
            dataTable.ajax.reload(null, true);
            return false;
        });

        // 添加按钮
        var createBtn = $('#createBtn');

        //工单模式窗体
        var workorderModal = $('#workorderModal');
        // 绑定事件
        var bindEvent = function () {
            // 添加按钮
            createBtn.on('click', function (event) {
                clearGlobalValue();
                bindModalEvent(workorderModal, null, 'CREATE');
                event.stopPropagation();
            });

            // 点击订单编号事件
            dataTable.on('click', '[data-handle="show-workorder"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/workorder/get/' + id,
                    dataType: 'json',
                    type: 'get',
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(workorderModal, res.data, 'DETAIL');
                            clearGlobalValue();
                        }
                    }
                });
                event.stopPropagation();
            });

            // 编辑按钮的事件
            dataTable.on('click', '[data-handle="workorder-edit"]', function (event) {
                var id = $(this).data('id');
                $.ajax({
                    url: ctx + '/api/workorder/get/' + id,
                    dataType: 'json',
                    type: 'get',
                    success: function (res) {
                        if (res.code == 1) {
                            bindModalEvent(workorderModal, res.data, 'EDIT');
                        }
                    }
                });
                event.stopPropagation();
            });

            // 点击列表中 结案按钮 事件
            dataTable.on('click', '[data-handle="close-operation"]', function (event) {
                var id = $(this).data('id');
                closeWorkOrder(id);
                event.stopPropagation();
            });
        };


        /**
         * 发送结案操作请求
         * @param modelWin 如果是从model弹窗点击的结案按钮，则表示模式窗体
         */
        function closeWorkOrder(workOrderId, modelWin) {
            var closeWorkOrderApi = ctx + "/api/workorder/close/" + workOrderId
            if (confirm("您确认已结案吗？")) {
                $.ajax({
                    url: closeWorkOrderApi,
                    type: 'get',
                    dataType: 'json',
                    success: function (res) {
                        if (res.code == 1) {
                            if (modelWin) {
                                modelWin.modal('hide');
                                resetDataTable(dataTable, ctx + '/api/workorder');
                            }
                            dataTable.ajax.reload(null, true);
                            clearGlobalValue();
                            toastr.success(res.message);
                        }
                    }
                });
            }
        }


        /** 模式窗体绑定事件
         * @param data 工单对象
         * @param modalType:操作模式：CREATE：新建窗口,DETAIL:查看工单详情窗口,EDIT:编辑窗口
         */
        var bindModalEvent = function ($modal, data, modalType) {

            // 用于table渲染时第一列的序号
            var recordIndex = 1;
            var refundProdIndex = 1;

            if (data != null) {
                globalWorkOrderId = data.id;
            }

            // 重置模式窗体内html
            $modal.html(template.render({
                modal: modalType != 'DETAIL' ? true : false,
                data: data || {},
                showDetail: modalType == 'DETAIL' ? true : false,
                refundProdList: isEditModalAndRefund(data, modalType),
                expressName: findExpressName(data),
                typeName: findWorkOrderTypeName(data),
                isEditModal: modalType == 'EDIT' ? true : false
            }));

            // 激活checkbox为ichecks
            $modal.find('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green'
            });
            // Raido默认选中咨询,不显示物流相关信息
            $('.extrainfo').hide();

            //结案按钮
            var closeWorkOrderBtn = $("#close-workorder");

            if (modalType == 'CREATE') {
                closeWorkOrderBtn.hide();
            } else if (modalType == 'EDIT') {
                if (data.closeAllowed) {
                    closeWorkOrderBtn.show();
                } else {
                    closeWorkOrderBtn.hide();
                }
            }

            //切换工单类型触发的事件 iChecks的事件
            $('input:radio[name="type"]').on('ifChecked', function (event) {
                if ('REFUND' == event.currentTarget.defaultValue) {
                    $(".extrainfo").show();
                } else {
                    $(".extrainfo").hide();
                }
            });

            // 加载快递列表
            $(express).each(function () {
                $("#workorder-express").append("<option value='" + this.id + "'>" + this.name + "</option>");
            });

            var renderWorkOrderRecord = function () {
                // 工单操作记录
                var recordDataTable = $('#workorderRecordDataTable').DataTable({
                    // 初始化column的一些属性
                    columnDefs: [{
                        defaultContent: '',
                        targets: '_all'
                    }, {
                        orderable: false,
                        targets: '_all'
                    }],

                    columns: [{
                        data: 'id',
                        className: 'td_center',
                        width: '3%',
                        render: function (data, type, full, meta) {
                            return recordIndex++;
                        }
                    }, {
                        data: 'note',
                        title: '工作记录',
                        width: '33%',
                        className: 'record_note',
                        render: function (data, type, full, meta) {
                            return data.length > 20 ? data.substr(0, 20) + '...' : data;
                        }
                    }, {
                        data: 'operatorDateTime',
                        title: '操作时间',
                        width: '20%',
                        render: function (data, type, full, meta) {
                            return RocoUtils.formatDate(new Date(data), 'yyyy-MM-dd hh:mm');
                        }
                    }, {
                        data: 'operator.username',
                        title: '操作人',
                        width: '10%'
                    }, {
                        title: '操作',
                        width: '15%',
                        className: 'td_center',
                        render: function (data, type, full, meta) {
                            if (modalType != 'DETAIL'  && loginAdminId == full.operator.id) {
                                return template.render({
                                    recordEditBtn: {
                                        id: full.id,
                                        content: full.note
                                    }
                                });
                            } else {
                                return ''
                            }
                        }
                    }],
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: ctx + '/api/workorderrecord',
                        type: 'GET',
                        data: function (d) {
                            if (modalType == 'DETAIL') {
                                return {
                                    "workOrderId": data.id
                                }
                            }
                            if (globalWorkOrderId == null) {
                                return {
                                    "workOrderId": -1
                                };
                            } else {
                                return {
                                    "workOrderId": globalWorkOrderId
                                }
                            }
                        }
                    },
                    lengthChange: false,
                    paging: true,
                    ordering: false,
                    info: true,
                    searching: false,
                    // 每页20条
                    pageLength: 20,
                    lengthMenu: [20],
                    order: [0, 'desc'],
                    bDestroy: true,
                    preDrawCallback: function () {
                        recordIndex = 1;
                    },
                    drawCallback: function () {
                        if (modalType == 'DETAIL') {
                            resetDataTable(dataTable, ctx + '/api/workorder');
                        }
                    }
                });

                if (modalType != 'REFUND') {
                    // 工单记录添加按钮的事件
                    $(':button[data-handle="add-workorder-record"]').on('click', function (event) {
                        var index = 1;
                        var tbody = $(recordDataTable.body());
                        if ('没有数据' == tbody.children('tr:first').text()) {
                            tbody.children('tr:first').first().remove();
                        } else {
                            index = tbody.children('tr:last').children('td:first').text();
                            index++;
                        }
                        $(tbody).append(
                            '<tr>' +
                            '<td class="td_center">' + index + '</td>' +
                            '<td class="order_record" width="33%"><input type="text" name="note" size="25"></td>' +
                            '<td></td>' +
                            '<td></td>' +
                            '<td class="td_center"><button data-handle="save-record" data-id="' + globalWorkOrderId + '" class="btn btn-primary btn-xs" type="button">保存</button>' +
                            '&nbsp; <button data-handle="delete-record-row" data-id="' + globalWorkOrderId + '" class="btn btn-primary btn-xs" type="button">删除</button></td>' +
                            '</tr>'
                        );

                        // 工单记录保存按钮事件
                        $(':button[data-handle="save-record"]').on('click', function (event) {
                            var note = $(this).parent('td').prevAll('.order_record').children(':input').val();
                            if (globalWorkOrderId == null) {
                                var workOrderType = $(':radio[name="type"]:checked').val();
                                var postData = {"type": workOrderType};
                                $.ajax({
                                    url: ctx + '/api/workorder/save',
                                    type: 'post',
                                    dataType: 'json',
                                    data: {"content": JSON.stringify(postData)},
                                    async: false,
                                    success: function (res, status) {
                                        if (res.code == 1) {
                                            globalWorkOrderId = res.data.id;
                                        }
                                    }
                                });
                            }
                            $.ajax({
                                url: ctx + '/api/workorderrecord/create',
                                type: 'post',
                                dataType: 'json',
                                data: {
                                    'workOrder.id': globalWorkOrderId,
                                    note: note
                                },
                                success: function (res, status) {
                                    if (res.code == 1) {
                                        recordDataTable.ajax.reload(null, true);
                                    }
                                }
                            });
                        });

                        //工单删除按钮事件
                        $(':button[data-handle="delete-record-row"]').on('click', function (event) {
                            $(this).parent('td').parent('tr').remove();
                        });
                    });

                    // 绑定工单记录的编辑按钮事件
                    recordDataTable.on('click', '[data-handle="record-edit"]', function (event) {
                        var id = $(this).data('id');
                        //获取原来的内容
                        var content = $(this).data('content');
                        //将文本改成input框
                        var recordTd = $(this).parent('td').prevAll('.record_note');
                        recordTd.text('');
                        recordTd.append('<input type="text" name="note" value="' + content + '" size="25" />');
                        //编辑按钮改为保存按钮接触原来的绑定事件
                        $(this).text('保存');
                        $(this).unbind('click');
                        //重新绑定按钮事件
                        $(this).on('click', function (event) {
                            var note = $(this).parent('td').prevAll('.record_note').children(':input').val();
                            $.ajax({
                                url: ctx + '/api/workorderrecord/update',
                                type: 'POST',
                                data: {
                                    id: id,
                                    note: note
                                },
                                dataType: 'json',
                                success: function (res, state) {
                                    if (res.code == 1) {
                                        recordDataTable.ajax.reload(null, true);
                                    }
                                }
                            });
                        })
                    });
                }
            };

            renderWorkOrderRecord();

            // 编辑模式下select的回显
            if (modalType == 'EDIT' && data != null && data.type == 'REFUND' && data.express != null) {
                $('#workorder-express').find('option').each(function () {
                    if (data.express.id == $(this).attr('value')) {
                        $(this).attr('selected', 'selected');
                    }
                });
            }


            // 点击”查询商品“按钮绑定的事件
            $(':button[data-handle="choose-prod"]').on('click', function (event) {
                var orderCode = $(':input[name="order.orderCode"]').val();
                orderCode = $.trim(orderCode);
                if (orderCode.length < 1) {
                    toastr.info('请输入主订单编号');
                    return;
                }
                // 初始化列表
                if (prodDataTable != undefined) {
                    prodDataTable.fnDestroy();
                }

                var chooseProdDataTable = $('#chooseProdDataTable');

                var prodDataTable = chooseProdDataTable.DataTable({
                    // 初始化column的一些属性
                    columnDefs: [{
                        defaultContent: '',
                        targets: '_all'
                    }, {
                        orderable: false,
                        targets: '_all'
                    }],

                    columns: [{
                        className: 'td_center',
                        title: '<input type="checkbox" class="i-checks" data-handle="all" />',
                        width: '3%',
                        render: function (data, type, full, meta) {
                            var chkboxTemp = '<input type="checkbox" name="chooseitem" class="i-checks" data-handle="selectOne" data-id="#dataId" data-sku="#dataSku" data-quantity="#dataQuantity"  data-cent="#dataCent" data-amt="#dataAmt" data-warehouse="#dataWareHouse" data-orderCode="#dataOrderCode" />';
                            chkboxTemp = chkboxTemp.replace("#dataId", full.id);
                            chkboxTemp = chkboxTemp.replace("#dataSku", full.sku.id);
                            chkboxTemp = chkboxTemp.replace("#dataQuantity", full.quantity);
                            chkboxTemp = chkboxTemp.replace("#dataCent", full.cent * full.quantity);
                            chkboxTemp = chkboxTemp.replace("#dataAmt", full.price * full.quantity);
                            chkboxTemp = chkboxTemp.replace("#dataWareHouse", full.wareHouse.id);
                            chkboxTemp = chkboxTemp.replace("#dataOrderCode", full.orderCode);
                            return chkboxTemp;
                        }
                    }, {
                        data: 'sku.code',
                        title: '商品编号',
                        width: '13%'
                    }, {
                        data: 'productName',
                        title: '商品名称',
                        width: '28%'
                    }, {
                        data: 'quantity',
                        title: '数量',
                        width: '8%'
                    }, {
                        data: 'cent',
                        title: '积分',
                        width: '8%'
                    }, {
                        data: 'price',
                        title: '现金',
                        width: '8%'
                    }, {
                        data: 'id',
                        title: '退货(数量/积分/金额)',
                        width: '40%',
                        className: 'refund_operate',
                        render: function (data, type, full, meta) {
                            // 返回编辑按钮 包含事件名称和id值
                            return template.render({
                                refundProdBtn: {
                                    id: full.id,
                                    quantity: full.quantity,
                                    cent: full.cent * full.quantity,
                                    price: full.price * full.quantity
                                }
                            });
                        }
                    }],
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: ctx + '/api/order/byCode',
                        type: 'GET',
                        data: {
                            orderCode: orderCode
                        }
                    },
                    lengthChange: false,
                    paging: true,
                    ordering: false,
                    info: true,
                    searching: false,
                    // 每页20条
                    pageLength: 20,
                    lengthMenu: [20],
                    order: [0, 'desc'],
                    bDestroy: true,
                    drawCallback: function () {
                        chooseProdDataTable.on('ifChecked', '[data-handle="all"]', function (e) {
                            var selectAll = chooseProdDataTable.find('[name="chooseitem"]');
                            selectAll.iCheck('check');

                            selectAll.each(function (idx, item) {
                                if (!$(item).hasClass('selected')) $(item).addClass('selected');
                            });

                            e.stopPropagation();
                        });

                        // 全不选
                        chooseProdDataTable.on('ifUnchecked', '[data-handle="all"]', function (e) {
                            var selectAll = chooseProdDataTable.find('[name="chooseitem"]');
                            selectAll.iCheck('uncheck');

                            selectAll.each(function (idx, item) {
                                $(item).removeClass('selected');
                            });

                            e.stopPropagation();
                        });

                        // 激活ichecks
                        chooseProdDataTable.find('.i-checks').iCheck({
                            checkboxClass: 'icheckbox_square-green',
                            radioClass: 'iradio_square-green'
                        });

                        // 选择列表中的元素
                        chooseProdDataTable.on('ifChecked', '[name="chooseitem"]', function (e) {
                            var self = $(this);
                            if (!self.hasClass('selected')) self.addClass('selected');
                        });

                        // 取消列表中的元素
                        chooseProdDataTable.on('ifUnchecked', '[name="chooseitem"]', function (e) {
                            var self = $(this);
                            self.removeClass('selected');
                        });


                        chooseProdDataTable.on('blur', "input[type='number']", function (event) {
                            var cent = $.trim($(this).val());
                            if (!$.isNumeric(cent) || parseInt(cent) < 0) {
                                alert('必须输入正数');
                                this.select();
                                return;
                            }
                            cent = cent - 0;
                            var max = parseInt($(this).attr("max"));
                            if (cent > max) {
                                $(this).val(max);
                            }

                            var tr = $(this).parents("tr");
                            var trchkbox = $(tr).find("input[name='chooseitem']");

                            var qty = $(this).val();
                            var name = $(this).attr("name");
                            if ("quantity" == name) {
                                trchkbox.attr("data-quantity", qty);
                            } else if ("cent" == name) {
                                trchkbox.attr("data-cent", qty);
                            } else if ("price" == name) {
                                trchkbox.attr("data-amt", qty);
                            }
                        });
                    }
                });
            });

            // 如果是编辑 或者显示详细模式 并且类型为退货 只显示退货信息
            if (isEditModalAndRefund(data, modalType)) {
                var refundProdDataTable = $('#refundProdDataTable').DataTable({
                    // 初始化column的一些属性
                    columnDefs: [{
                        defaultContent: '',
                        targets: '_all'
                    }, {
                        orderable: false,
                        targets: '_all'
                    }],

                    columns: [{
                        data: 'id',
                        className: 'td_center',
                        width: '3%',
                        render: function (data, type, full, meta) {
                            return refundProdIndex++;
                        }
                    }, {
                        data: 'orderItem.productName',
                        title: '商品名称',
                        width: '20%'
                    }, {
                        data: 'orderItem.quantity',
                        title: '购买量',
                        width: '10%'
                    }, {
                        data: 'orderItem.cent',
                        title: '积分价',
                        width: '10%'
                    }, {
                        data: 'orderItem.price',
                        title: '现金价',
                        width: '10%'
                    }, {
                        data: 'quantity',
                        title: '退货量',
                        width: '10%'
                    }, {
                        data: 'cent',
                        title: '退积分',
                        width: '10%'
                    }, {
                        data: 'amount',
                        title: '退现金',
                        width: '10%'
                    }, {
                        data: 'refunded',
                        title: '入库否',
                        width: '10%',
                        render: function (data) {
                            return data ? "已入库" : "未入库";
                        }
                    }],
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: ctx + '/api/workorderrefund',
                        type: 'GET',
                        data: {
                            workOrderId: data.id
                        }
                    },
                    lengthChange: false,
                    paging: true,
                    ordering: false,
                    info: true,
                    searching: false,
                    // 每页20条
                    pageLength: 20,
                    lengthMenu: [20],
                    order: [0, 'desc'],
                    drawCallback: function () {
                        refundProdIndex = 1;
                        resetDataTable(dataTable, ctx + '/api/workorder');
                    }
                });
            }

            // 展示模式窗体
            $modal.modal({
                keyboard: true
            });

            // 保存客服工单 按钮事件
            $('#saveWorkorderBtn').on('click', function (event) {

                if (modalType == 'CREATE') {
                    //如果是 添加模式：
                    var workOrderType = $("input[name='type']:checked").val();
                    if ('REFUND' == workOrderType) {
                        var checkRefundChkbox = $("#chooseProdDataTable").find("input[name='chooseitem']");
                        if (checkRefundChkbox.length < 1) {
                            alert("请先选择退货商品信息");
                            return;
                        }
                    }
                }

                var jsonObj = buildPostData(data, false, modalType);
                if (modalType == 'EDIT') {
                    if (!((jsonObj.express.id > 0 && jsonObj.transportNo.length > 0) || (jsonObj.express.id < 1 && jsonObj.transportNo.length < 1))) {
                        alert("快递公司和运单号要么都不填，要么填写完整");
                        return;
                    }
                }

                $.ajax({
                    url: ctx + '/api/workorder/save',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        "content": JSON.stringify(jsonObj)
                    },
                    beforeSend: function () {
                        btnDisable($(this));
                    },
                    success: function (res, status) {
                        if (res.code == 1) {
                            toastr.success('操作成功');
                            $modal.modal('hide');
                            resetDataTable(dataTable, ctx + '/api/workorder');
                            dataTable.ajax.reload(null, true);
                            clearGlobalValue();
                        }
                    },
                    complete: function () {
                        btnEnable($(this));
                    }
                });
            });

            // 结案按钮
            closeWorkOrderBtn.on('click', function (event) {
                closeWorkOrder(data.id, $modal);
            });

            // 关闭按钮事件
            $(':button[data-handle="hide-modal"]').on('click', function (event) {
                $modal.modal('hide');
                if (globalWorkOrderId != null && globalWorkOrderId > 0) {
                    resetDataTable(dataTable, ctx + '/api/workorder');
                    dataTable.ajax.reload(null, true);
                }
                clearGlobalValue();
            });

            // 构建提交表单的数据
            var buildPostData = function (data, state, modal) {
                if (data != null) {
                    globalWorkOrderId = data.id;
                }
                var workOrderType = data == null ? $(':radio[name="type"]:checked').val() : data.type;
                var paramJsonObj = {};
                if (workOrderType != 'REFUND') {
                    if (globalWorkOrderId != null) {
                        $.extend(paramJsonObj, {
                            id: globalWorkOrderId
                        }, {
                            type: workOrderType,
                            state: state
                        });
                    } else {
                        $.extend(paramJsonObj, {
                            type: workOrderType,
                            state: state
                        });
                    }
                } else {
                    var orderCode = $(':input[name="order.orderCode"]').val();
                    var expressId = null;
                    var transportNo = '';
                    //已保存过的快递公司Id,如果已经保存过快递则不能修改
                    var oldExpressId = $("input[name='oldExpressId']").val() - 0;
                    if (oldExpressId < 1) {
                        expressId = $('select[name="express.id"]').val();
                        transportNo = $.trim($('#workorder-logistics').val());
                    }
                    var workOrderCode = $("#workorder-code").val();
                    if (modal != null && modal == 'EDIT') {
                        $.extend(paramJsonObj, {
                            "id": globalWorkOrderId == null ? '' : globalWorkOrderId,
                            "code": workOrderCode,
                            "type": workOrderType,
                            "express": {"id": expressId},
                            "transportNo": transportNo,
                            "state": state
                        });
                    } else {
                        //创建退货 客服工单
                        var selectProdList = $(':checkbox[name="chooseitem"]:checked');
                        paramJsonObj = {
                            "id": globalWorkOrderId == null ? '' : globalWorkOrderId,
                            "type": workOrderType,
                            "order": {"orderCode": orderCode},
                            "workOrderRefundDetails": [],
                            "state": state
                        };
                        selectProdList.each(function () {
                            var subOrderId = $(this).data('id');
                            var skuid = $(this).data('sku');
                            var quantity = $(this).data('quantity');
                            var cent = $(this).data('cent');
                            var warehouseId = $(this).data('warehouse');
                            var amt = $(this).data('amt');
                            var subOrderCode = $(this).data('ordercode');

                            var detail = {}
                            paramJsonObj.workOrderRefundDetails.push({
                                "workOrder": {
                                    "id": globalWorkOrderId == null ? '' : globalWorkOrderId
                                },
                                "warehouse": {"id": warehouseId},
                                "sku": {"id": skuid},
                                "orderItem": {"id": subOrderId, "orderCode": subOrderCode},
                                "quantity": quantity,
                                "cent": cent,
                                "amount": amt
                            });
                        });
                    }
                }
                return paramJsonObj;
            };
        };

        bindEvent();
        // 禁用按钮
        var btnDisable = function ($button) {
            $button.attr('disabled', 'disabled');
            $button.attr('disabled', 'disabled');
        };

        // 启用按钮
        var btnEnable = function ($button) {
            $button.removeAttr('disabled');
            $button.removeAttr('disabled');
        };

        /**
         * 判断是否是编辑模式(或者查看详情),并且类型为退货
         * @param data
         * @param type
         */
        var isEditModalAndRefund = function (data, type) {
            if ((type == 'EDIT' || type == 'DETAIL') && data.type == 'REFUND') {
                return true;
            } else {
                return false;
            }
        };

        /**
         * 根据快递id查询快递名
         * @param data
         */

        var findExpressName = function (data) {
            if (data == null || data.type != 'REFUND' || data.express == null)
                return '';
            var expressId = data.express.id;
            var expressName = '';
            $(express).each(function () {
                if (this.id == expressId) {
                    expressName = this.name;
                }
            });
            return expressName;
        };

        // 根据类型查找对应的中文名称
        var findWorkOrderTypeName = function (data) {
            if (data == null) {
                return '';
            } else if (data.type == 'CONSULT') {
                return '咨询';
            } else if (data.type == 'COMPLAINT') {
                return '投诉';
            } else if (data.type == 'REFUND') {
                return '退货';
            }
            return ''
        };

        var clearGlobalValue = function () {
            globalWorkOrderId = null;
        };


        //重置索引
        var resetIndex = function () {
            var proTable = $("#proTable").find("table");
            if (proTable.length > 0) {
                $(proTable).each(function (index, value) {
                    $(value).find("input[data-id='id']").attr("name", "prodStockApplyItems[" + index + "].prod.id");
                    $(value).find("input[data-num='num']").attr("name", "prodStockApplyItems[" + index + "].quantity");
                })
            }
        };
        //设置结果集
        var setResult = function (data) {
            if (data.length == 0) {
                proList = null;
                return;
            }
            var arr = [];
            $(data).each(function (index, value) {
                var str = "{id:" + value.prod.id + ",code:'" + value.prod.code + "',name:'" + value.prod.name + "'}";
                arr.push(str);
            });
            proList = eval("[" + arr.join(",") + "]");
        };

        //重置datatable的url
        var resetDataTable = function (dataTable, url) {
            dataTable.settings({
                ajax: {
                    url: url,
                    type: 'GET',
                    data: function (d) {
                        return $.extend(RocoUtils.buildParam(d), searchParam);
                    }
                }
            })
        };
    });
})(window, document, this.jQuery, Hogan, this.RocoUtils);