package com.rocoinfo.rocomall.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: 树形结构dto</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/6/29 14:48</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class CategoryTreeDto {

    public CategoryTreeDto() {
        super();
    }

    public CategoryTreeDto(Long id, String text, int level) {
        super();
        this.id = id;
        this.text = text;
        a_attr.put("data-lev", level);
    }

    /**
     * 一级节点
     */
    public static final int LEVEL_1 = 1;

    /**
     * 二级节点
     */
    public static final int LEVEL_2 = 2;

    /**
     * 三级节点
     */
    public static final int LEVEL_3 = 3;

    /**
     * 节点id
     */
    private Long id;

    /**
     * 保存level信息
     */
    private Map<String, Integer> a_attr = new HashMap<>();

    /**
     * 子节点
     */
    private List<CategoryTreeDto> children;

    /**
     * 文本信息
     */
    private String text;

    public CategoryTreeDto(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Map<String, Integer> getA_attr() {
        return a_attr;
    }

    public void setA_attr(Map<String, Integer> a_attr) {
        this.a_attr = a_attr;
    }

    public List<CategoryTreeDto> getChildren() {
        return children;
    }

    public void setChildren(List<CategoryTreeDto> children) {
        this.children = children;
    }

    public void setLevel(int level) {
        a_attr.put("data-lev", level);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }
}
