package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.enumconst.AdvType;
import com.rocoinfo.rocomall.enumconst.Status;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * <dl>
 * <dd>Description: 广告管理</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/6/30 10:16</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class Adv extends IdEntity {

    /**
     * 广告类型
     */
    private AdvType type;

    /**
     * 广告标题
     */
    private String title;

    /**
     * 背景颜色
     */
    private String bgColor;

    /**
     * 广告语
     */
    private String slogan;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 链接地址
     */
    private String linkUrl;

    /**
     * 显示顺序
     */
    private Integer sortId;

    /**
     * 状态 OPEN:显示 LOCK:不显示
     */
    private Status status;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 创建人
     */
    private AdminUser creator;

    public AdvType getType() {
        return type;
    }

    public void setType(AdvType type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBgColor() {
        if (StringUtils.isNoneBlank(bgColor))
            bgColor = bgColor.replaceAll("＃", "#");
        return bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public String getSlogan() {
        return slogan;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public Integer getSortId() {
        return sortId;
    }

    public void setSortId(Integer sortId) {
        this.sortId = sortId;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public AdminUser getCreator() {
        return creator;
    }

    public void setCreator(AdminUser creator) {
        this.creator = creator;
    }
}
