package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.enumconst.CacheableTag;
import com.rocoinfo.rocomall.redis.CacheKeys;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.NumberFormat;

import java.util.List;

/**
 * 商品分类
 * 
 * @author yangxc
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@CacheableTag(cacheKeyPrev = CacheKeys.CATALOG_KEY_PREFIX)
public class Catalog extends IdEntity {

	private static final long serialVersionUID = -33477870020039425L;

	private Catalog parent;

	private String name;

	private String code;

	private Integer displayOrder;

	private Status status;

	private List<Catalog> children;

	private String imgUrl;

	@Transient
	private Long parentId;

	public static enum Status {
		BOTH_VISIBLE("全部可见"), PC_VISIBLE("仅PC可见"), APP_VISIBLE("仅移动App可见"), INVISIBLE("都不可见");
		private String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	public Catalog() {
		super();
	}

	public Catalog(long catId) {
		this();
		this.id = catId;
	}

	public Catalog getParent() {
		return parent;
	}

	@JsonIgnore
	public Long getParentId() {
		return parentId;
	}

	public void setParent(Catalog parent) {
		this.parent = parent;
	}

	@Required
	@SafeHtml
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Required
	@SafeHtml
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@NumberFormat
	public Integer getDisplayOrder() {
		return displayOrder;
	}

	public void setDisplayOrder(Integer displayOrder) {
		this.displayOrder = displayOrder;
	}

	@Required
	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public List<Catalog> getChildren() {
		return children;
	}

	public void setChildren(List<Catalog> children) {
		this.children = children;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getImgUrl() {
		return imgUrl;
	}

	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}

	public String getFullImageUrl() {
		return PropertyHolder.getFullImageUrl(this.getImgUrl());
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Catalog other = (Catalog) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}

}