package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.PropertyHolder;

/**
 * 商品图片
 * 
 * @author yangxc
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductImage extends IdEntity {

	private static final long serialVersionUID = 8076814317319147707L;

	private Product product;

	private Sku sku;

	private String path;

	private Integer displayOrder;

	private ImageType imageType; // 图片类型

	public static enum ImageType {
		MAIN("商品主图"), ATTACH("商品附图"), SKU("sku图片");
		private String type;

		ImageType(String type) {
			this.type = type;
		}

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}
	}

	public Product getProduct() {
		return product;
	}

	public void setProduct(Product product) {
		this.product = product;
	}

	public Sku getSku() {
		return sku;
	}

	public void setSku(Sku sku) {
		this.sku = sku;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getImageUrl() {
		return PropertyHolder.getFullImageUrl(path);
	}

	public Integer getDisplayOrder() {
		return displayOrder;
	}

	public void setDisplayOrder(Integer displayOrder) {
		this.displayOrder = displayOrder;
	}

	/**
	 * 返回是否是产品主图片
	 * 
	 * @return true表示产品主图，false表示是sku图片
	 */
	public boolean isProductPrimaryImg() {
		if (this.sku == null || this.sku.getId() < 1) {
			return true;
		}
		return false;
	}

	public ImageType getImageType() {
		return imageType;
	}

	public void setImageType(ImageType imageType) {
		this.imageType = imageType;
	}
}
