package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Transient;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 单品
 * 
 * @author weiys
 */
@SuppressWarnings("all")
@JsonIgnoreProperties(ignoreUnknown = true)
public class Sku extends IdEntity {
	private static final long serialVersionUID = 4770148383261348441L;

	private static final String BLANK = " ";

	private String code;
	private String name;

	private Product product;

	private String attribute1;

	private String attribute2;

	private String attribute3;

	/**
	 * 仓库位置
	 */
	private DictWarehouse wareHouse;

	/**
	 * 良品库： <br/>
	 * (1)减少：a:发货 b:换货处理时选择商品不可用 <br/>
	 * (2)增加：退货处理时选择商品可用
	 */
	private Integer stock;

	/**
	 * 下单支付后增加、发货或取消订单 后减少
	 */
	private Integer occupiedStock;

	private Integer virtualStock;

	private Integer warningStock;

	private Status status;

	private Boolean displayInlist; // 是否在列表页显示

	private String supplierProdCode;

	private Double cashAmt; // 现金价值

	private Integer cent; // 积分价值

	private Double mergeCashAmt; // 合并现金价值

	private Double mergeCent; // 合并积分价值

	private Double origCashAmt; // 现金价值

	private Integer origCent; // 积分价值

	private Double origMergeCashAmt; // 合并现金价值

	private Double origMergeCent; // 合并积分价值

	@Transient
	private List<ProductImage> productImages;

	@Transient
	private List<String> canDos;

	private String supplierName;

	public static enum Status {
		ENABLED("启用"), DISABLED("停用");
		private final String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	/**
	 * 库存状态枚举类型
	 */
	public static enum StockStatus {
		NORMAL("正常"), WARNING("预警");

		private final String label;

		StockStatus(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getOccupiedStock() {
		return occupiedStock;
	}

	public void setOccupiedStock(Integer occupiedStock) {
		this.occupiedStock = occupiedStock;
	}

	public Product getProduct() {
		return product;
	}

	public void setProduct(Product product) {
		this.product = product;
	}

	public String getAttribute1() {
		return attribute1;
	}

	public void setAttribute1(String attribute1) {
		this.attribute1 = attribute1;
	}

	public String getAttribute2() {
		return attribute2;
	}

	public void setAttribute2(String attribute2) {
		this.attribute2 = attribute2;
	}

	public String getAttribute3() {
		return attribute3;
	}

	public void setAttribute3(String attribute3) {
		this.attribute3 = attribute3;
	}

	public Integer getStock() {
		return stock;
	}

	public void setStock(Integer stock) {
		this.stock = stock;
	}

	public Integer getWarningStock() {
		return warningStock;
	}

	public void setWarningStock(Integer warningStock) {
		this.warningStock = warningStock;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public Integer getVirtualStock() {
		return virtualStock;
	}

	public void setVirtualStock(Integer virtualStock) {
		this.virtualStock = virtualStock;
	}

	public List<ProductImage> getProductImages() {
		return productImages;
	}

	public void setProductImages(List<ProductImage> productImages) {
		this.productImages = productImages;
	}

	public void addImage(ProductImage skuImg) {
		if (skuImg != null) {
			if (this.productImages == null) {
				this.productImages = Lists.newArrayList();
			}
			productImages.add(skuImg);
		}
	}

	/**
	 * 返回可销售的库存数量
	 */
	public int getAvailableStockQuantity() {
		// 可售库存=良品库存+商品虚拟库存-占用库存
		if (this.stock != null && this.virtualStock != null && this.occupiedStock != null) {
			return Math.max(this.virtualStock + this.stock - this.occupiedStock, 0);
		}
		return 0;
	}

	/**
	 * 计算 sku加入购物车后剩余多少库存 剩余库存数量>0 则可以购物，否则不能加入购物车
	 * 
	 * @param quantity 购买数量
	 */
	public int calcLessStockAfterAddCart(int quantity) {
		return this.getAvailableStockQuantity() - quantity;
	}

	/**
	 * 是否当 前sku是否正在销售中
	 */
	public boolean isOnSale() {
		boolean isSaleing = false;
		if (this.product != null) {
			isSaleing = Status.ENABLED.equals(this.status) && Product.Status.LIST.equals(this.product.getStatus());
		}
		return isSaleing;
	}

	// -- 前台显示sku对应的图片，如果sku没有上传图片，则取产品主图 --//
	public String getPreviewImagePath() {
		if (!CollectionUtils.isEmpty(productImages)) {
			return PropertyHolder.getFullImageUrl(productImages.get(0).getPath());
		}

		if (this.product != null && !CollectionUtils.isEmpty(this.product.getProductImages())) {
			return PropertyHolder.getFullImageUrl(this.product.getProductImages().get(0).getPath());
		}
		return StringUtils.EMPTY;
	}

	/**
	 * @return 返回产品列表显示的商品名称
	 */
	public String getProductFullName() {
		if (product != null && StringUtils.isNotBlank(product.getName())) {
			return new StringBuilder(product.getName()).append(BLANK).append(getAttributes()).toString();
		} else {
			return StringUtils.EMPTY;
		}
	}

	public String getAttributes() {
		StringBuilder sb = new StringBuilder();
		if (StringUtils.isNotBlank(attribute1)) {
			sb.append(attribute1).append(BLANK);
		}
		if (StringUtils.isNotBlank(attribute2)) {
			sb.append(attribute2).append(BLANK);
		}
		if (StringUtils.isNotBlank(attribute3)) {
			sb.append(attribute3).append(BLANK);
		}

		if (sb.length() > 0) {
			sb.deleteCharAt(sb.length() - 1);
		}
		return sb.toString();
	}

	/**
	 * @return 库存状态
	 */
	public StockStatus getStockStatus() {
		if (getStock() != null && getVirtualStock() != null && getWarningStock() != null && getOccupiedStock() != null) {
			if (getAvailableStockQuantity() > getWarningStock()) {
				return StockStatus.NORMAL;
			} else {
				return StockStatus.WARNING;
			}
		}
		return null;
	}

	public Double getCashAmt() {
		return cashAmt;
	}

	public void setCashAmt(Double cashAmt) {
		this.cashAmt = cashAmt;
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public Double getMergeCashAmt() {
		return mergeCashAmt;
	}

	public void setMergeCashAmt(Double mergeCashAmt) {
		this.mergeCashAmt = mergeCashAmt;
	}

	public Double getMergeCent() {
		return mergeCent;
	}

	public void setMergeCent(Double mergeCent) {
		this.mergeCent = mergeCent;
	}

	public Double getOrigCashAmt() {
		return origCashAmt;
	}

	public void setOrigCashAmt(Double origCashAmt) {
		this.origCashAmt = origCashAmt;
	}

	public Integer getOrigCent() {
		return origCent;
	}

	public void setOrigCent(Integer origCent) {
		this.origCent = origCent;
	}

	public Double getOrigMergeCashAmt() {
		return origMergeCashAmt;
	}

	public void setOrigMergeCashAmt(Double origMergeCashAmt) {
		this.origMergeCashAmt = origMergeCashAmt;
	}

	public Double getOrigMergeCent() {
		return origMergeCent;
	}

	public void setOrigMergeCent(Double origMergeCent) {
		this.origMergeCent = origMergeCent;
	}

	public static String getBlank() {
		return BLANK;
	}

	public String getSupplierProdCode() {
		return supplierProdCode;
	}

	public void setSupplierProdCode(String supplierProdCode) {
		this.supplierProdCode = supplierProdCode;
	}

	public Boolean getDisplayInlist() {
		return displayInlist;
	}

	public void setDisplayInlist(Boolean displayInlist) {
		this.displayInlist = displayInlist;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public DictWarehouse getWareHouse() {
		return wareHouse;
	}

	public void setWareHouse(DictWarehouse wareHouse) {
		this.wareHouse = wareHouse;
	}

	public List<String> getCanDos() {
		return canDos;
	}

	public void setCanDos(List<String> canDos) {
		this.canDos = canDos;
	}
}