package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.enumconst.CacheableTag;
import com.rocoinfo.rocomall.redis.CacheKeys;

/**
 * 供应商信息
 * 
 * @author zhangmin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@CacheableTag(cacheKeyPrev = CacheKeys.SUPPLIER_KEY_PREV)
public class Supplier extends IdEntity {

	private static final long serialVersionUID = -3934382448427037058L;

	private String code;

	private String name;

	private String shortName;

	private Integer displayOrder;

	// 合作/中止
	private Boolean useable;

	public Supplier() {
	}

	public Supplier(Long id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public Integer getDisplayOrder() {
		return displayOrder;
	}

	public void setDisplayOrder(Integer displayOrder) {
		this.displayOrder = displayOrder;
	}

	public Boolean getUseable() {
		return useable;
	}

	public void setUseable(Boolean useable) {
		this.useable = useable;
	}
}