package com.rocoinfo.rocomall.entity.account;

import com.rocoinfo.rocomall.entity.IdEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;

import javax.xml.bind.annotation.*;
import java.util.List;

/**
 * 角色
 * 
 * @author zhangmin
 */
@XmlType
@XmlRootElement(name = "role")
@XmlAccessorType(XmlAccessType.FIELD)
public class Role extends IdEntity {

	private static final long serialVersionUID = 2510859557988256648L;

	public static final String ADMIN = "admin";
	public static final String USER = "user";

	private String name;

	@XmlElement(name = "desc")
	private String description;

	private List<String> permissions; // 角色拥有的权限

	public Role() {
	}

	public Role(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public List<String> getPermissions() {
		return permissions;
	}

	public void setPermissions(List<String> permissions) {
		this.permissions = permissions;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
}
