package com.rocoinfo.rocomall.entity.cent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.AdminUser;

import java.util.Date;

/**
 * @author zhangmin
 */
public class Apply extends IdEntity {

	private static final long serialVersionUID = 1L;

	private String applyCode;

	private AdminUser applyer;

	private State state;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date applyDate;

	private String note;

	public enum State {

		DRAFT("草稿"), WAIT_AUDIT("待审批"), PASS("通过"), FAILED("失败");

		private final String label;

		State(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}

		public String getValue() {
			return this.name();
		}
	}

	public String getApplyCode() {
		return applyCode;
	}

	public void setApplyCode(String applyCode) {
		this.applyCode = applyCode;
	}

	public AdminUser getApplyer() {
		return applyer;
	}

	public void setApplyer(AdminUser applyer) {
		this.applyer = applyer;
	}

	public State getState() {
		return state;
	}

	public void setState(State state) {
		this.state = state;
	}

	public Date getApplyDate() {
		return applyDate;
	}

	public void setApplyDate(Date applyDate) {
		this.applyDate = applyDate;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}
}