package com.rocoinfo.rocomall.entity.cent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.dict.DictCentAttribution;

import java.util.Date;

/**
 * 积分规则
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CentRule extends IdEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 编码
	 */
	private String code;

	/**
	 * 名称
	 */
	private String name;

	/**
	 * 描述
	 */
	private String description;

	/**
	 * 归属类型
	 */
	private DictCentAttribution attribution;

	/**
	 * 秘钥
	 */
	private String secretKey;

	/**
	 * 单次分值,使用此规则每次产生的积分数
	 */
	private Integer cent;

	/**
	 * 预算总积分 ，已发放出去的总积分不能大于预算总积分
	 */
	private Integer budget;

	/**
	 * 通过本条规则已发放的累计积分
	 */
	private Integer totalCent;

	/**
	 * 规则可以被调用的开始日期
	 */
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date startDate;

	/**
	 * 规则可以被调用的结束日期，如果为空,则有效期永远有效
	 */
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date endDate;

	/**
	 * 有效期类型 (0或1) 0：指定有效期 ; 1：生成积分时,自动延长extendDay
	 */
	private Integer effectiveType;

	/**
	 * 通过此规则生成的积分：有效截止日
	 */
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date effectiveDate;

	/**
	 * 延长天数。生成积分时,自动延长extendDay
	 */
	private Integer extendDay;

	/**
	 * 通过此规则生成积分后,是否发送短信通知用户
	 */
	private Boolean smsFlag;

	/**
	 * 状态
	 */
	private Status status;

	public static enum Status {
		DRAFT("草稿"), WAIT_AUDIT("待审批"), OPEN("开启"), LOCK("停止");

		private String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public DictCentAttribution getAttribution() {
		return attribution;
	}

	public void setAttribution(DictCentAttribution attribution) {
		this.attribution = attribution;
	}

	public String getSecretKey() {
		return secretKey;
	}

	public void setSecretKey(String secretKey) {
		this.secretKey = secretKey;
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public Integer getBudget() {
		return budget;
	}

	public void setBudget(Integer budget) {
		this.budget = budget;
	}

	public Integer getTotalCent() {
		return totalCent;
	}

	public void setTotalCent(Integer totalCent) {
		this.totalCent = totalCent;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public Integer getEffectiveType() {
		return effectiveType;
	}

	public void setEffectiveType(Integer effectiveType) {
		this.effectiveType = effectiveType;
	}

	public Integer getExtendDay() {
		return extendDay;
	}

	public void setExtendDay(Integer extendDay) {
		this.extendDay = extendDay;
	}

	public Boolean getSmsFlag() {
		return smsFlag;
	}

	public void setSmsFlag(Boolean smsFlag) {
		this.smsFlag = smsFlag;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	/**
	 * 返回积分规则是否可以使用,是否能生成积分
	 */
	public boolean isUsable() {
		return isEffective() && Status.OPEN.equals(this.status) && getBudgetBalance() > 0;
	}

	/**
	 * @return 积分规则 是否是有效的
	 */
	public boolean isEffective() {
		java.sql.Date now = new java.sql.Date(System.currentTimeMillis());
		if (this.startDate == null || now.before(startDate)) {
			return false;
		}
		if (this.endDate != null && now.after(endDate)) {
			return false;
		}
		return true;
	}

	//返回剩余的预算余额
	public Integer getBudgetBalance() {
		if (budget != null && totalCent != null) {
			return Math.max(budget - totalCent, 0);
		}
		return null;
	}
}