package com.rocoinfo.rocomall.entity.order;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;

import java.util.Date;

/**
 * 配送单
 * 
 * @author zhangmin
 */
public class DistributionOrder extends IdEntity {

	private static final long serialVersionUID = 2838633898073833694L;

	/** 配送单号 */
	private String code;

	private OrderItem orderItem;

	/** 是否已配送导出,只能配送导出一次,配送导出后，生成出库单 */
	private Boolean exported;

	/** 配送导出人 **/
	private AdminUser exporter;

	/** 快递 **/
	private DictExpress express;

	/** 快递运单号 **/
	private String transportNo;

	/** 出库单id,生成的出库单id,多个配送单对应1张出库单 **/
	private Long outStoreId;

	/** 配送单合单编号 **/
	private String mergeCode;

	private Date createTime;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public OrderItem getOrderItem() {
		return orderItem;
	}

	public void setOrderItem(OrderItem orderItem) {
		this.orderItem = orderItem;
	}

	public Boolean getExported() {
		return exported;
	}

	public void setExported(Boolean exported) {
		this.exported = exported;
	}

	public AdminUser getExporter() {
		return exporter;
	}

	public void setExporter(AdminUser exporter) {
		this.exporter = exporter;
	}

	public DictExpress getExpress() {
		return express;
	}

	public void setExpress(DictExpress express) {
		this.express = express;
	}

	public String getTransportNo() {
		return transportNo;
	}

	public void setTransportNo(String transportNo) {
		this.transportNo = transportNo;
	}

	public Long getOutStoreId() {
		return outStoreId;
	}

	public void setOutStoreId(Long outStoreId) {
		this.outStoreId = outStoreId;
	}

	public String getMergeCode() {
		return mergeCode;
	}

	public void setMergeCode(String mergeCode) {
		this.mergeCode = mergeCode;
	}

	//是否已经导入了快递信息
	public boolean hasExpress() {
		return this.express != null && this.express.getId() > 0;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
}
