package com.rocoinfo.rocomall.entity.order;

import com.rocoinfo.rocomall.entity.IdEntity;
import org.apache.commons.lang3.StringUtils;

/**
 * <dl>
 * <dd>描述:订单收货信息快照--配送单</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/4 上午10:34</dd>
 * <dd>创建人： weiys</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
@SuppressWarnings("all")
public class OrderDelivery extends IdEntity {
	//总订单Id
	private Long orderId;
	//省份
	private String province;
	//城市
	private String city;
	//国家
	private String county;
	//地址
	private String addrDetail;
	//收件人名称
	private String recipient;
	//邮编
	private String postcode;
	//收件人电话
	private String recipientPhone;

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public String getAddrDetail() {
		return addrDetail;
	}

	public void setAddrDetail(String addrDetail) {
		this.addrDetail = addrDetail;
	}

	public String getRecipient() {
		return recipient;
	}

	public void setRecipient(String recipient) {
		this.recipient = recipient;
	}

	public String getPostcode() {
		return postcode;
	}

	public void setPostcode(String postcode) {
		this.postcode = postcode;
	}

	public String getRecipientPhone() {
		return recipientPhone;
	}

	public void setRecipientPhone(String recipientPhone) {
		this.recipientPhone = recipientPhone;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}

	public String getAddrPrefix() {
		StringBuilder sb = new StringBuilder();
		String spliter = "、";
		if (StringUtils.isNotBlank(province)) {
			sb.append(province);
		}

		if (StringUtils.isNotBlank(this.city)) {
			if (StringUtils.isNotBlank(province)) {
				sb.append(spliter);
			}
			sb.append(city);
		}

		if (StringUtils.isNotBlank(this.county)) {
			if (StringUtils.isNotBlank(city)) {
				sb.append(spliter);
			}
			sb.append(county);
		}

		return sb.toString();
	}
}