package com.rocoinfo.rocomall.entity.params;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.order.Order;

/**
 * <dl>
 * <dd>Description:封装下单参数的实体类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016年8月12日 上午10:47:34</dd>
 * <dd>@author：Kong</dd>
 * </dl>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class OrderParams extends IdEntity {

    /**
     * OrderParams serialVersionUID
     */
    private static final long serialVersionUID = 3852371892913791316L;

    /**
     * 下单用户id
     */
    private Long userId;
    /**
     * 订单id
     */
    private Long orderId;
    
    /**
     * 购买商品skuId
     */
    private Long skuId;

    /**
     * 购买商品数量
     */
    private Integer quantity;

    /**
     * 是否自取 true:自取  false快递
     */
    private Boolean isInvite;

    /**
     * 收货地址id
     */
    private Long addressId;

    /**
     * 卖家留言
     */
    private String note;
    
    /**
     * 支付方式  
     */
    private Order.CashPayType paymode;
    
    /**
     * 订单总额
     */
    private Double amount;
    
    /**
     * 运费
     */
    private Double cost;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Long getAddressId() {
        return addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }

    public Boolean getIsInvite() {
        return isInvite;
    }

    public void setIsInvite(Boolean isInvite) {
        this.isInvite = isInvite;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }


	public Order.CashPayType getPaymode() {
		return paymode;
	}

	public void setPaymode(Order.CashPayType paymode) {
		this.paymode = paymode;
	}

	public Double getAmount() {
		return amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public Double getCost() {
		return cost;
	}

	public void setCost(Double cost) {
		this.cost = cost;
	}
    
}

