package com.rocoinfo.rocomall.jms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

import javax.jms.*;

/**
 * JMS订单状态消息生产者.
 *
 * @author liuwei
 */
public class OrderStatusMessageProducer {

    private Logger logger = LoggerFactory.getLogger(OrderStatusMessageProducer.class);

    private JmsTemplate jmsTemplate;
    private Destination notifyQueue;

    public void sendQueue(final String orderCode, final String status) {
        logger.debug("正在发送JMS消息。orderCode={}, status={}", orderCode, status);
        jmsTemplate.send(notifyQueue, new MessageCreator() {
            @Override
            public Message createMessage(Session session) throws JMSException {
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setString("orderCode", orderCode);
                mapMessage.setString("status", status);
                return mapMessage;
            }
        });
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setNotifyQueue(Destination notifyQueue) {
        this.notifyQueue = notifyQueue;
    }
}
