package com.rocoinfo.rocomall.pay.wechat;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.*;

/**
 * 微信统一下单返回xml
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-11-4 上午9:34:11</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@XmlType
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class UnifiedOrderResult {
	@XmlElement(name = "return_code")
	private String returnCode;

	@XmlElement(name = "return_msg")
	private String returnMsg;

	@XmlElement(name = "appid")
	private String appId;

	@XmlElement(name = "mch_id")
	private String mchId;

	@XmlElement(name = "nonce_str")
	private String nonceStr;

	@XmlElement(name = "sign")
	private String sign;

	@XmlElement(name = "result_code")
	private String resultCode;

	@XmlElement(name = "err_code")
	private String errCode;

	@XmlElement(name = "err_code_des")
	private String errCodeDes;

	@XmlElement(name = "trade_type")
	private String tradeType;

	@XmlElement(name = "prepay_id")
	private String prepayId;

	@XmlElement(name = "code_url")
	private String codeUrl;

	public String getReturnCode() {
		return returnCode;
	}

	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}

	public String getReturnMsg() {
		return returnMsg;
	}

	public void setReturnMsg(String returnMsg) {
		this.returnMsg = returnMsg;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getResultCode() {
		return resultCode;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getErrCodeDes() {
		return errCodeDes;
	}

	public void setErrCodeDes(String errCodeDes) {
		this.errCodeDes = errCodeDes;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}

	public String getPrepayId() {
		return prepayId;
	}

	public void setPrepayId(String prepayId) {
		this.prepayId = prepayId;
	}

	public String getCodeUrl() {
		return codeUrl;
	}

	public void setCodeUrl(String codeUrl) {
		this.codeUrl = codeUrl;
	}

	public boolean isCanPay() {
		if (StringUtils.equalsIgnoreCase(returnCode, WxpayHelper.SUCCESS)) {
			return StringUtils.equalsIgnoreCase(resultCode, WxpayHelper.SUCCESS);
		}
		return false;
	}
}
