package com.rocoinfo.rocomall.pay.wechat;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.pay.MD5;
import com.rocoinfo.rocomall.utils.ReflectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.annotation.XmlElement;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WxSignUtil {
	private static Logger logger = LoggerFactory.getLogger(WxSignUtil.class);

	/**
	 * 签名
	 * 
	 * @return
	 */
	public static String sign(Class<?> c, Object object,String signature) {
		Map<String, String> map = Maps.newHashMap();
		for (Field field : c.getDeclaredFields()) {
			XmlElement ant = field.getAnnotation(XmlElement.class);
			String fieldName = field.getName();
			String val = String.valueOf(ReflectionUtils.getFieldValue(object, fieldName));
			if (StringUtils.isNotBlank(val) && !StringUtils.equals(fieldName, "sign") && !StringUtils.equals(val, "null")) {
				map.put(ant.name(), val);
			}
		}
		List<String> notEmptyFiled = Lists.newArrayList(map.keySet());
		Collections.sort(notEmptyFiled);
		StringBuffer sb = new StringBuffer();
		for (String str : notEmptyFiled) {
			sb.append(str).append("=").append(map.get(str)).append("&");
		}//
		sb.append("key=").append(signature);
		logger.info("签名字符串  {}", sb.toString());
		return MD5.getMD5ofStr(sb.toString()).toUpperCase();
	}
	/**
	 * 签名
	 *
	 * @return
	 */
	public static String sign(Map<String,String> map,String signature) {
		//Map<String, String> map = Maps.newHashMap();

		List<String> notEmptyFiled = Lists.newArrayList(map.keySet());
		Collections.sort(notEmptyFiled);
		StringBuffer sb = new StringBuffer();
		for (String str : notEmptyFiled) {
			sb.append(str).append("=").append(map.get(str)).append("&");
		}//
		sb.append("key=").append(signature);
		logger.info("签名字符串  {}", sb.toString());
		return MD5.getMD5ofStr(sb.toString()).toUpperCase();
	}

}
