package com.rocoinfo.rocomall.repository;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.Address;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户收货地址DAO Created by robin on 14-6-11. author yangxc
 */
@MyBatisRepository
public interface AddressDao extends CrudDao<Address> {

    /**
     * 根据用户id查询用户当前地址
     *
     * @param userId 用户id
     * @return
     */
    List<Address> findByUserId(@Param("userId") Long userId);

    /**
     * 将用户的地址置为非默认
     *
     * @param userId 用户id
     */
    void setUnDefaultByUserId(@Param("userId") Long userId);

    /**
     * 设置默认地址
     *
     * @param userId 用户id
     * @param id     需要设置为默认地址的记录id
     */
    void setDefault(@Param("userId") Long userId, @Param("id") Long id);
}
