package com.rocoinfo.rocomall.repository;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.Product;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 商品DAO
 *
 * @author liuwei
 */
@MyBatisRepository
public interface ProductDao extends CrudDao<Product> {

    long countListedProductBySupplierId(Long supplierId);

    /**
     * 查找定时上架商品Ids
     */
    List<Long> findScheduleReadyListProductIds(Date date);

    /**
     * 查找定时下架商品Ids
     */
    List<Long> findScheduleDeListProductIds(Date date);

    void updateProductStatus(@Param("newStatus") Product.Status newStatus, @Param("prodIdList") List<Long> prodIdList);

    /**
     * 分页查询商品信息(带主图信息)
     *
     * @param params 查询参数
     * @return
     */
    List<Product> searchWithMainImg(Map<String, Object> params);
}
