package com.rocoinfo.rocomall.repository;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.ProductImage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商品图片DAO Created by robin on 14-6-12. author yangxc
 */
@MyBatisRepository
public interface ProductImageDao extends CrudDao<ProductImage> {

	/**
	 * 返回产品的所有图片，包括 主图 和 所有sku的图片
	 */
	List<ProductImage> getByProductId(Long productId);

	public List<ProductImage> findByProductIdIn(List<Long> productIdList);

	/**
	 * 返回产品的主图
	 */
	List<ProductImage> getProductPrimaryImages(Long productId);

	/**
	 * 返回某个sku的图片列表和此sku对应的产品的主图
	 * 
	 * @param productId
	 *            产品Id
	 * @param skuId
	 *            单品Id
	 * @return
	 */
	List<ProductImage> getProdSkuImgListWithPrimaryImag(@Param(value = "prodId") Long productId, @Param(value = "skuId") Long skuId);

	/**
	 * @param prodIdList
	 *            产品Id列表
	 * @return 返回各个产品的所有图片列表（包括主图和sku图片）
	 */
	List<ProductImage> findProductsAllImg(final List<Long> prodIdList);

	List<ProductImage> getBySkuId(Long skuId);

}
