package com.rocoinfo.rocomall.repository.account;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.account.UserBind;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <dl>
 * <dd>描述: 用户绑定Dao</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月4日 下午6:20:00</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@MyBatisRepository
public interface UserBindDao extends CrudDao<UserBind> {

	/**
	 * 返回绑定的userId,如果尚未绑定，则返回null
	 */
	public Long getBindUserIdByPlatformCodeAndOuid(@Param("platformCode") String platformCode, @Param("ouid") String ouid);

	/**
	 * 返回绑定的userId,如果尚未绑定，则返回null
	 */
	public Long getBindUserIdByPlatformIdAndOuid(@Param("platformId") Long platformId, @Param("ouid") String ouid);

	/**
	 * 返回已经绑定当其他平台的ouid,如果尚未绑定，则返回null
	 */
	public String getBindOuidByPlatformCodeAndUserId(@Param("platformCode") String platformCode, @Param("userId") Long userId);

	/**
	 * 返回绑定的开通平台
	 */
	public List<UserBind> findBoundOpenedPlatformByUserId(Long userId);

	/**
	 * 返回绑定的平台个数
	 */
	public int countBoundedPlatformsByUserId(Long userId);

}